/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.task.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionFactory;
import org.apache.synapse.task.TaskDescriptionSerializer;
import org.wso2.carbon.task.stub.TaskAdminStub;
import org.wso2.carbon.task.stub.TaskManagementException;
import org.wso2.carbon.task.stub.types.carbon.TaskData;
import org.wso2.carbon.task.ui.internal.ResponseInformation;
import org.wso2.carbon.ui.CarbonUIUtil;

public class TaskManagementClient {
    private static final Log log = LogFactory.getLog(TaskManagementClient.class);
    private static final String TASK_EXTENSION_NS = "http://www.wso2.org/products/wso2commons/tasks";
    private static final OMNamespace TASK_OM_NAMESPACE = OMAbstractFactory.getOMFactory().createOMNamespace("http://www.wso2.org/products/wso2commons/tasks", "task");
    private static final QName ROOT_QNAME = new QName("http://www.wso2.org/products/wso2commons/tasks", "taskExtension", "task");
    private TaskAdminStub stub;

    private TaskManagementClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault, TaskManagementException {
        String serviceURL = backendServerURL + "TaskAdmin";
        this.stub = new TaskAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public static TaskManagementClient getInstance(ServletConfig config, HttpSession session) throws TaskManagementException, AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new TaskManagementClient(cookie, backendServerURL, configContext);
    }

    public ResponseInformation addTaskDescription(TaskDescription taskDescription) {
        TaskManagementClient.validateTaskDescription(taskDescription);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to add TaskDescription :" + taskDescription));
        }
        OMElement taskElement = TaskDescriptionSerializer.serializeTaskDescription((OMNamespace)TASK_OM_NAMESPACE, (TaskDescription)taskDescription);
        TaskManagementClient.validateTaskElement(taskElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("TasK configuration :" + taskElement));
        }
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            this.stub.addTaskDescription(taskElement);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation deleteTaskDescription(String name, String group) {
        TaskManagementClient.validateName(name);
        TaskManagementClient.validateGroup(group);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to delete a TaskDescription with name : " + name));
        }
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            this.stub.deleteTaskDescription(name, group);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation editTaskDescription(TaskDescription taskDescription) {
        TaskManagementClient.validateTaskDescription(taskDescription);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to Edit TaskDescription :" + taskDescription));
        }
        OMElement taskElement = TaskDescriptionSerializer.serializeTaskDescription((OMNamespace)TASK_OM_NAMESPACE, (TaskDescription)taskDescription);
        TaskManagementClient.validateTaskElement(taskElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("TasK configuration :" + taskElement));
        }
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            this.stub.editTaskDescription(taskElement);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public List<TaskDescription> getAllTaskDescriptions() throws Exception {
        OMElement element = this.stub.getAllTaskDescriptions(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("All TasKs configurations :" + element));
        }
        ArrayList<TaskDescription> descriptions = new ArrayList<TaskDescription>();
        if (element == null) {
            return descriptions;
        }
        OMElement taskRoot = element.getFirstChildWithName(ROOT_QNAME);
        if (taskRoot == null) {
            return descriptions;
        }
        Iterator iterator = taskRoot.getChildElements();
        while (iterator.hasNext()) {
            TaskDescription taskDescription;
            OMElement taskElement = (OMElement)iterator.next();
            if (taskElement == null || (taskDescription = TaskDescriptionFactory.createTaskDescription((OMElement)taskElement, (OMNamespace)TASK_OM_NAMESPACE)) == null) continue;
            descriptions.add(taskDescription);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All TasKs Descriptions :" + descriptions));
        }
        return descriptions;
    }

    public TaskData[] getAllTaskData() throws Exception {
        TaskData[] taskData = null;
        try {
            taskData = this.stub.getAllTaskData();
        }
        catch (Exception e) {
            TaskManagementClient.handleException(e.getLocalizedMessage());
        }
        return taskData;
    }

    public TaskDescription getTaskDescription(String name, String group) throws Exception {
        TaskManagementClient.validateName(name);
        TaskManagementClient.validateGroup(group);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to retrieve a Task Description for give name :" + name));
        }
        OMElement returnElement = this.stub.getTaskDescription(name, group);
        TaskManagementClient.validateTaskElement(returnElement);
        OMElement taskElement = returnElement.getFirstElement();
        TaskManagementClient.validateTaskElement(taskElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved Task Configuration : " + returnElement));
        }
        TaskDescription taskDescription = TaskDescriptionFactory.createTaskDescription((OMElement)taskElement, (OMNamespace)TASK_OM_NAMESPACE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved Task : " + taskDescription));
        }
        TaskManagementClient.validateTaskDescription(taskDescription);
        long interval = taskDescription.getInterval();
        if (taskDescription.getIntervalInMs()) {
            interval /= 1000L;
        }
        taskDescription.setInterval(interval);
        taskDescription.setIntervalInMs(false);
        return taskDescription;
    }

    public boolean isContains(String name, String group) throws Exception {
        TaskManagementClient.validateName(name);
        TaskManagementClient.validateGroup(group);
        return this.stub.isContains(name, group);
    }

    public ResponseInformation loadTaskProperties(String className, String group) {
        TaskManagementClient.validateName(className);
        TaskManagementClient.validateGroup(group);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to retrieve properties of the Task implementation : " + className));
        }
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            OMElement properties;
            OMElement returnElement = this.stub.loadTaskClassProperties(className.trim(), group);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded class properties as XML : " + returnElement));
            }
            if (returnElement != null && (properties = returnElement.getFirstChildWithName(new QName(TASK_EXTENSION_NS, "properties", "task"))) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Returning properties : " + properties));
                }
                responseInformation.setResult(properties);
            }
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation getAllJobGroups() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Going to retrieve all JOBGroup names");
        }
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            Object[] jobGroups = this.stub.getAllJobGroups();
            if (jobGroups != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded JOBGroup names : " + Arrays.toString(jobGroups)));
                }
                responseInformation.setResult(jobGroups);
            }
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    private static void validateTaskDescription(TaskDescription description) {
        if (description == null) {
            TaskManagementClient.handleException("Task Description can not be found.");
        }
    }

    private static void validateTaskElement(OMElement taskElement) {
        if (taskElement == null) {
            TaskManagementClient.handleException("Task Description OMElement can not be found.");
        }
    }

    private static void validateName(String name) {
        if (name == null || "".equals(name)) {
            TaskManagementClient.handleException("Name is null or empty");
        }
    }

    private static void validateGroup(String name) {
        if (name == null || "".equals(name)) {
            TaskManagementClient.handleException("Group is null or empty");
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }
}

