/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.task.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.TaskDescription;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Element;
import org.wso2.carbon.task.ui.internal.TaskManagementClient;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TaskManagementHelper {
    private static final Log log = LogFactory.getLog(TaskManagementHelper.class);
    private static final String TASK_EXTENSION_NS = "http://www.wso2.org/products/wso2commons/tasks";
    private static final OMFactory FACTORY = OMAbstractFactory.getOMFactory();
    private static final OMNamespace TASK_OM_NAMESPACE = FACTORY.createOMNamespace("http://www.wso2.org/products/wso2commons/tasks", "task");

    public static TaskDescription createTaskDescription(HttpServletRequest request) throws ServletException {
        String propertyCount;
        String pinnedServers;
        String taskClass;
        String group;
        String name = request.getParameter("taskName");
        if ((name == null || "".equals(name)) && ((name = request.getParameter("taskName_hidden")) == null || "".equals(name))) {
            TaskManagementHelper.handleException("Name cannot be null or empty");
        }
        if (((group = request.getParameter("taskGroup")) == null || "".equals(group)) && ((group = request.getParameter("taskGroup_hidden")) == null || "".equals(group))) {
            TaskManagementHelper.handleException("Task group cannot be null or empty");
        }
        if ((taskClass = request.getParameter("taskClass")) == null || "".equals(taskClass)) {
            TaskManagementHelper.handleException("Task Class cannot be null or empty");
        }
        TaskDescription taskDescription = new TaskDescription();
        taskDescription.setName(name.trim());
        taskDescription.setTaskGroup(group.trim());
        taskDescription.setTaskImplClassName(taskClass.trim());
        String trigger = request.getParameter("taskTrigger");
        if (trigger != null && !"".equals(trigger)) {
            if ("simple".equals(trigger)) {
                String count;
                String interval = request.getParameter("triggerInterval");
                if (interval != null && !"".equals(interval)) {
                    try {
                        taskDescription.setInterval(Long.parseLong(interval.trim()) * 1000L);
                        taskDescription.setIntervalInMs(true);
                    }
                    catch (NumberFormatException e) {
                        TaskManagementHelper.handleException("Invalid value for interval (Expected type is long) : " + interval);
                    }
                }
                if ((count = request.getParameter("triggerCount")) != null && !"".equals(count)) {
                    try {
                        taskDescription.setCount(Integer.parseInt(count.trim()));
                    }
                    catch (NumberFormatException e) {
                        TaskManagementHelper.handleException("Invalid value for Count (Expected type is int) : " + count);
                    }
                }
            } else if ("cron".equals(trigger)) {
                String cron = request.getParameter("triggerCron");
                if (cron != null && !"".equals(cron)) {
                    taskDescription.setCronExpression(cron.trim());
                } else {
                    TaskManagementHelper.handleException("Cron expression cannot be empty for cron trigger");
                }
            }
        } else {
            TaskManagementHelper.handleException("No Trigger has been selected");
        }
        if ((pinnedServers = request.getParameter("pinnedServers")) != null || !"".equals(pinnedServers)) {
            StringTokenizer st = new StringTokenizer(pinnedServers, " ,");
            ArrayList<String> pinnedServersList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() == 0) continue;
                pinnedServersList.add(token);
            }
            taskDescription.setPinnedServers(pinnedServersList);
        }
        if ((propertyCount = request.getParameter("propertyCount")) != null && !"".equals(propertyCount)) {
            try {
                int propCount = Integer.parseInt(propertyCount.trim());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Number of properties : " + propCount));
                }
                for (int i = 0; i < propCount; ++i) {
                    OMNamespace nullNS;
                    OMElement propElem;
                    String value;
                    String id = "property_name_hidden" + String.valueOf(i);
                    String propName = request.getParameter(id);
                    if (propName == null || "".equals(propName)) continue;
                    String propertyType = request.getParameter("propertyTypeSelection" + String.valueOf(i));
                    if ("literal".equals(propertyType)) {
                        value = request.getParameter("textField" + String.valueOf(i));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("[ Property Name : " + name + " ][ Property Value : " + value + " ]"));
                        }
                        if (value == null || "".equals(value)) continue;
                        propElem = FACTORY.createOMElement("property", TASK_OM_NAMESPACE);
                        nullNS = FACTORY.createOMNamespace("", "");
                        propElem.addAttribute("name", propName.trim(), nullNS);
                        propElem.addAttribute("value", value.trim(), nullNS);
                        taskDescription.setXmlProperty(propElem);
                        continue;
                    }
                    if (!"xml".equals(propertyType)) continue;
                    value = request.getParameter("textArea" + String.valueOf(i));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[ Property Name : " + name + " ][ Property Value : " + value + " ]"));
                    }
                    if (value == null || "".equals(value)) continue;
                    propElem = FACTORY.createOMElement("property", TASK_OM_NAMESPACE);
                    nullNS = FACTORY.createOMNamespace("", "");
                    propElem.addAttribute("name", propName.trim(), nullNS);
                    try {
                        propElem.addChild((OMNode)TaskManagementHelper.createOMElement(value.trim()));
                    }
                    catch (Throwable e) {
                        TaskManagementHelper.handleException("Invalid XML has been provided for property : " + propName);
                    }
                    taskDescription.setXmlProperty(propElem);
                }
            }
            catch (NumberFormatException ignored) {
                TaskManagementHelper.handleException("Invalid number of properties " + propertyCount);
            }
        }
        return taskDescription;
    }

    private static OMElement createOMElement(String xml) throws Exception {
        return XMLUtils.toOM((Element)TaskManagementHelper.getSecuredDocumentBuilder(true).parse(new ByteArrayInputStream(xml.getBytes())).getDocumentElement());
    }

    private static void handleException(String msg) throws ServletException {
        log.error((Object)msg);
        throw new ServletException(msg);
    }

    public static TaskDescription getTaskDescription(HttpServletRequest request, TaskManagementClient client, String name, String group) throws Exception {
        TaskDescription taskDescription;
        if (name == null || "".equals(name)) {
            TaskManagementHelper.handleException("Task Name cannot be empty");
        }
        if ((taskDescription = client.getTaskDescription(name = name.trim(), group)) == null) {
            TaskManagementHelper.handleException("No task description for name :" + name);
        }
        return taskDescription;
    }

    public static List<OMElement> mergeProperties(OMElement allPropertyElement, Set<OMElement> propertySources) {
        ArrayList<OMElement> toBeReturn = new ArrayList<OMElement>();
        if (allPropertyElement == null || propertySources == null) {
            return toBeReturn;
        }
        Iterator propertyIterator = allPropertyElement.getChildElements();
        while (propertyIterator.hasNext()) {
            String name;
            OMElement property = (OMElement)propertyIterator.next();
            if (property == null || (name = property.getAttributeValue(new QName("", "name", ""))) == null || "".equals(name)) continue;
            OMElement element = TaskManagementHelper.getValueElement(propertySources, name);
            if (element != null) {
                toBeReturn.add(element.cloneOMElement());
                continue;
            }
            toBeReturn.add(property.cloneOMElement());
        }
        return toBeReturn;
    }

    private static OMElement getValueElement(Set<OMElement> sources, String name) {
        for (OMElement element : sources) {
            String elementName;
            if (element == null || (elementName = element.getAttributeValue(new QName("", "name", ""))) == null || "".equals(elementName) || !elementName.trim().equals(name.trim())) continue;
            return element;
        }
        return null;
    }

    public static DocumentBuilder getSecuredDocumentBuilder(boolean setIgnoreComments) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(setIgnoreComments);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setXIncludeAware(false);
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        documentBuilderFactory.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                throw new SAXException("Possible XML External Entity (XXE) attack. Skipping entity resolving");
            }
        });
        return documentBuilder;
    }
}

