/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.task;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionFactory;
import org.apache.synapse.task.TaskDescriptionSerializer;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.task.TaskData;
import org.wso2.carbon.task.TaskManagementException;
import org.wso2.carbon.task.TaskManager;

public class CarbonTaskManagementService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(CarbonTaskManagementService.class);
    private static final String TASK_EXTENSION_NS = "http://www.wso2.org/products/wso2commons/tasks";
    private static final OMFactory FACTORY = OMAbstractFactory.getOMFactory();
    private static final String COMMON_ENDPOINT_POSTFIX = "--SYNAPSE_INBOUND_ENDPOINT";
    private static final OMNamespace TASK_OM_NAMESPACE = FACTORY.createOMNamespace("http://www.wso2.org/products/wso2commons/tasks", "task");

    public boolean addTaskDescription(OMElement taskElement) throws TaskManagementException {
        TaskDescription taskDescription;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add TaskDescription - Get a Task configuration  :" + taskElement));
        }
        if (this.isContains((taskDescription = CarbonTaskManagementService.validateAndCreate(taskElement)).getName(), taskDescription.getTaskGroup())) {
            throw new TaskManagementException("Task with name " + taskDescription.getName() + " is already there.");
        }
        try {
            this.getTaskManager().addTaskDescription(taskDescription);
        }
        catch (Exception e) {
            try {
                this.getTaskManager().deleteTaskDescription(taskDescription.getName(), taskDescription.getTaskGroup());
            }
            catch (Exception exception) {
                // empty catch block
            }
            CarbonTaskManagementService.handleException("Error creating a task : " + e.getMessage(), e);
        }
        return true;
    }

    public boolean deleteTaskDescription(String s, String group) throws TaskManagementException {
        CarbonTaskManagementService.validateName(s);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delete TaskDescription - Get a name of the TaskDescription to be deleted : " + s));
        }
        try {
            this.getTaskManager().deleteTaskDescription(s, group);
        }
        catch (Exception e) {
            CarbonTaskManagementService.handleException("Error deleting a task with name : " + s + " : " + e.getMessage(), e);
        }
        return true;
    }

    public void editTaskDescription(OMElement taskElement) throws TaskManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Edit TaskDescription - Get a Task configuration  :" + taskElement));
        }
        try {
            this.getTaskManager().editTaskDescription(CarbonTaskManagementService.validateAndCreate(taskElement), this.getAxisConfig());
        }
        catch (Exception e) {
            CarbonTaskManagementService.handleException("Error editing a task : " + e.getMessage(), e);
        }
    }

    public OMElement getAllTaskDescriptions() throws TaskManagementException {
        OMElement root = OMAbstractFactory.getOMFactory().createOMElement(new QName(TASK_EXTENSION_NS, "taskExtension", "task"));
        try {
            List<TaskDescription> descriptions = this.getTaskManager().getAllTaskDescriptions();
            for (TaskDescription taskDescription : descriptions) {
                if (taskDescription == null || taskDescription.getName() == null || taskDescription.getName().endsWith(COMMON_ENDPOINT_POSTFIX)) continue;
                OMElement taskElement = TaskDescriptionSerializer.serializeTaskDescription((OMNamespace)TASK_OM_NAMESPACE, (TaskDescription)taskDescription);
                CarbonTaskManagementService.validateTaskElement(taskElement);
                root.addChild((OMNode)taskElement);
            }
        }
        catch (Exception e) {
            CarbonTaskManagementService.handleException("Error loading all tasks : " + e.getMessage(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning all TaskDescriptions as  :" + root));
        }
        return root;
    }

    public OMElement getTaskDescription(String s, String group) throws TaskManagementException {
        CarbonTaskManagementService.validateName(s);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get TaskDescription - Get a name of the TaskDescription to be returned : " + s));
        }
        try {
            TaskDescription taskDescription = this.getTaskManager().getTaskDescription(s, group);
            if (taskDescription != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Retrieved a TaskDescription : " + taskDescription));
                }
                OMElement taskElement = TaskDescriptionSerializer.serializeTaskDescription((OMNamespace)TASK_OM_NAMESPACE, (TaskDescription)taskDescription);
                CarbonTaskManagementService.validateTaskElement(taskElement);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task Configuration : " + taskElement));
                }
                return taskElement;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no TaskDescription with name :" + s));
            }
        }
        catch (Exception e) {
            CarbonTaskManagementService.handleException("Error loading a task with name " + s + " : " + e.getMessage(), e);
        }
        return null;
    }

    public TaskData[] getAllTaskData() throws TaskManagementException {
        TaskData[] taskData = null;
        if (this.getTaskManager().getAllTaskData(this.getAxisConfig()) != null) {
            taskData = this.getTaskManager().getAllTaskData(this.getAxisConfig());
        }
        return taskData;
    }

    public boolean isContains(String s, String group) throws TaskManagementException {
        CarbonTaskManagementService.validateName(s);
        return this.getTaskManager().isContains(s, group);
    }

    public OMElement loadTaskClassProperties(String className, String group) throws TaskManagementException {
        CarbonTaskManagementService.validateName(className);
        try {
            List<String> names = this.getTaskManager().getPropertyNames(className.trim(), group);
            OMNamespace nullNS = FACTORY.createOMNamespace("", "");
            OMElement propertiesElement = FACTORY.createOMElement("properties", TASK_OM_NAMESPACE);
            if (names == null || names.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Empty Property name list for class : " + className));
                }
                return propertiesElement;
            }
            for (String name : names) {
                if (name == null || "".equals(name)) continue;
                OMElement propElem = FACTORY.createOMElement("property", TASK_OM_NAMESPACE);
                propElem.addAttribute("name", name, nullNS);
                propElem.addAttribute("value", "", nullNS);
                propertiesElement.addChild((OMNode)propElem);
            }
            return propertiesElement;
        }
        catch (Exception e) {
            CarbonTaskManagementService.handleException("Error loading task implementation : " + e.getMessage(), e);
            return null;
        }
    }

    public String[] getAllJobGroups() {
        List<String> strings = this.getTaskManager().getAllJobGroups();
        return strings.toArray(new String[strings.size()]);
    }

    private static TaskDescription validateAndCreate(OMElement taskElement) throws TaskManagementException {
        CarbonTaskManagementService.validateTaskElement(taskElement);
        TaskDescription taskDescription = TaskDescriptionFactory.createTaskDescription((OMElement)taskElement, (OMNamespace)TASK_OM_NAMESPACE);
        CarbonTaskManagementService.validateTaskDescription(taskDescription);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Task Description : " + taskDescription));
        }
        return taskDescription;
    }

    private static void validateTaskDescription(TaskDescription description) throws TaskManagementException {
        if (description == null) {
            CarbonTaskManagementService.handleException("Task Description can not be found.");
        }
    }

    private static void validateTaskElement(OMElement taskElement) throws TaskManagementException {
        if (taskElement == null) {
            CarbonTaskManagementService.handleException("Task Description OMElement can not be found.");
        }
    }

    private static void validateName(String name) throws TaskManagementException {
        if (name == null || "".equals(name)) {
            CarbonTaskManagementService.handleException("Name is null or empty");
        }
    }

    private static void handleException(String msg) throws TaskManagementException {
        log.error((Object)msg);
        throw new TaskManagementException(msg);
    }

    private static void handleException(String msg, Exception e) throws TaskManagementException {
        log.error((Object)msg, (Throwable)e);
        throw new TaskManagementException(msg, e);
    }

    private synchronized TaskManager getTaskManager() {
        return (TaskManager)this.getConfigContext().getProperty("CARBON_TASK_MANAGER");
    }
}

