/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { LinkedAccountInterface, ProfileInfoInterface, ProfileSchemaInterface } from "../../models";
import { ProfileActionTypes, SetProfileInfoActionInterface, SetProfileSchemasActionInterface, ToggleSCIMEnabledActionInterface } from "./types";
/**
 * Redux action to set profile info.
 *
 * @param info - Profile information.
 * @return {SetProfileInfoActionInterface} An action of type `SET_PROFILE_INFO`
 */
export declare const setProfileInfo: (info: any) => SetProfileInfoActionInterface;
/**
 * Redux action to set profile schemas.
 *
 * @param {ProfileSchemaInterface[]} schemas - Profile schemas.
 * @return {SetProfileSchemasActionInterface} An action of type `SET_PROFILE_SCHEMAS`
 */
export declare const setSCIMSchemas: (schemas: ProfileSchemaInterface[]) => SetProfileSchemasActionInterface;
/**
 * Redux action to set profile linked accounts.
 *
 * @param {LinkedAccountInterface[]} accounts - Profile schemas.
 * @return {SetProfileSchemasActionInterface} An action of type `SET_PROFILE_SCHEMAS`
 */
export declare const setProfileLinkedAccounts: (accounts: LinkedAccountInterface[]) => {
    payload: LinkedAccountInterface[];
    type: ProfileActionTypes;
};
/**
 * Redux action to toggle SCIM enabled.
 *
 * @param {boolean} isEnabled - Flag to determine if SCIM is enabled.
 * @return {ToggleSCIMEnabledActionInterface} An action of type `TOGGLE_SCIM_ENABLED`
 */
export declare const toggleSCIMEnabled: (isEnabled: boolean) => ToggleSCIMEnabledActionInterface;
/**
 * Redux action to get the profile schemas for a specific user.
 * Makes an API call to the SCIM endpoint and retrieves the profile schemas.
 *
 * @param {ProfileInfoInterface} profileInfo - Profile information.
 * @param {(info: ProfileInfoInterface, schemas: ProfileSchema[]) => void} onProfileCompletionUpdate - Callback to be
 * fired to calculate the profile completion.
 * @return {(dispatch) => void}
 */
export declare const getSCIMSchemas: (profileInfo?: ProfileInfoInterface, onProfileCompletionUpdate?: (info: ProfileInfoInterface, schemas: ProfileSchemaInterface[]) => void) => (dispatch: any) => void;
/**
 * Redux action to get profile information.
 * Makes an API request to the SCIM endpoint and retrieves the user information.
 *
 * @param {boolean} updateProfileCompletion - Flag to determine whether profile completion should be updated or not.
 * @param {ProfileSchemaInterface[]} profileSchemas - Profile schemas.
 * @param {() => void} onSCIMDisabled - Callback to be fired if SCIM is disabled.
 * @param {(error: string) => void} onRequestError - Callback to be fired on request error.
 * @param {() => void} onRequestGenericError - Callback to be fired to handle generic error.
 * @param {(info: ProfileInfoInterface, schemas: ProfileSchema[]) => void} onProfileCompletionUpdate - Callback to be
 * fired to calculate the profile completion.
 * @return {(dispatch) => void}
 */
export declare const getProfileInformation: (updateProfileCompletion?: boolean, profileSchemas?: ProfileSchemaInterface[], onSCIMDisabled?: () => void, onRequestError?: (error: string) => void, onRequestGenericError?: () => void, onProfileCompletionUpdate?: (info: ProfileInfoInterface, schemas: ProfileSchemaInterface[]) => void) => (dispatch: any) => void;
