/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { AuthReducerStateInterface } from "../../models";
import { AuthenticateActions } from "../actions/types";
/**
 * Reducer to handle the state of authentication related actions.
 *
 * @param {AuthReducerStateInterface} state - Previous state.
 * @param {AuthenticateActions} action - Action type.
 * @returns The new state.
 */
export declare const authenticateReducer: (state: AuthReducerStateInterface, action: AuthenticateActions) => AuthReducerStateInterface | {
    displayName: any;
    emails: any;
    isAuth: boolean;
    loginInit: boolean;
    logoutInit: boolean;
    username: any;
    isAuthenticated: boolean;
};
