/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

import {
    AuthenticateSessionUtil,
    AuthenticateTokenKeys
} from "@wso2is/authentication";
import { TokenConstants } from "../constants";

/**
 * Utility class for authenticate operations.
 */
export class AuthenticateUtils {

    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    // eslint-disable-next-line @typescript-eslint/no-empty-function
    private constructor() { }

    /**
     * Checks if the logged in user has login scope.
     *
     * @return {boolean} True or false.
     */
    public static hasLoginPermission(): boolean {
        const scopes = AuthenticateSessionUtil.getSessionParameter(AuthenticateTokenKeys.SCOPE).split(" ");
        return scopes.includes(TokenConstants.LOGIN_SCOPE);
    }

    /**
     * Checks if the logged in user has a specific scope.
     *
     * @return {boolean} True or false.
     */
    public static hasScope(scope: string): boolean {
        const scopes = AuthenticateSessionUtil.getSessionParameter(AuthenticateTokenKeys.SCOPE).split(" ");
        return scopes.includes(scope);
    }
}
