/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import classNames from "classnames";
import React from "react";
import { Card, Popup } from "semantic-ui-react";
import { GenericIcon } from "../icon";
/**
 * Application template card component.
 *
 * @param {ApplicationTemplateCardPropsInterface} props - Props injected to the components.
 * @return {JSX.Element}
 * @constructor
 */
export const ApplicationTemplateCard = (props) => {
    const { className, description, disabled, name, id, inline, image, imageSize, onClick, selected, technologies, textAlign } = props;
    const classes = classNames("app-template-card", {
        ["with-image"]: image,
        disabled,
        inline,
        selected
    }, className);
    return (React.createElement(Card, { id: id, className: classes, onClick: onClick, link: false, as: "div" },
        image && (React.createElement(Card.Content, { className: "card-image-container" },
            React.createElement(GenericIcon, { className: "card-image", size: imageSize, icon: image, square: true, transparent: true }))),
        React.createElement(Card.Content, { className: "card-text-container", style: { textAlign } },
            React.createElement(Card.Header, null, name),
            React.createElement(Card.Description, null, description),
            technologies && (React.createElement("div", { className: "technologies" },
                React.createElement("div", { className: "title" }, "Technologies"),
                React.createElement("div", { className: "logos" }, technologies.map((technology, index) => (React.createElement(Popup, { key: index, trigger: (React.createElement("span", { className: "icon-wrapper" },
                        React.createElement(GenericIcon, { icon: technology.logo, size: "micro", spaced: "right", inline: true, transparent: true }))), position: "top center", content: technology.displayName, inverted: true })))))))));
};
/**
 * Default props for the application template card.
 */
ApplicationTemplateCard.defaultProps = {
    imageSize: "auto",
    inline: true,
    textAlign: "center"
};
//# sourceMappingURL=application-template-card.js.map