/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import classNames from "classnames";
import React from "react";
import { Card, Label } from "semantic-ui-react";
import { GenericIcon } from "../icon";
/**
 * Labeled card component.
 *
 * @param {LabeledCardPropsInterface} props - Props injected to the components.
 * @return {JSX.Element}
 * @constructor
 */
export const LabeledCard = (props) => {
    const { bottomMargin, className, disabled, id, inline, image, imageSize, label, onClick, onCloseClick, selected } = props;
    const wrapperClasses = classNames("labeled-card-wrapper", {
        ["with-bottom-margin"]: bottomMargin,
        inline
    }, className);
    const cardClasses = classNames("labeled-card", {
        ["with-image"]: image,
        disabled,
        selected
    });
    return (React.createElement("div", { className: wrapperClasses },
        React.createElement(Card, { id: id, as: "div", className: cardClasses, onClick: onClick, link: false },
            onCloseClick && (React.createElement(Label, { className: "close-button", color: "red", size: "mini", onClick: onCloseClick, floating: true, circular: true }, "x")),
            React.createElement(Card.Content, { className: "card-image-container" },
                React.createElement(GenericIcon, { className: "card-image", size: imageSize, icon: image, square: true, transparent: true }))),
        React.createElement("div", { className: "card-label" }, label)));
};
/**
 * Default props for the labeled card component.
 */
LabeledCard.defaultProps = {
    bottomMargin: true,
    imageSize: "mini",
    inline: true,
    onClick: () => null
};
//# sourceMappingURL=labeled-card.js.map