/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from "react";
import { Button, Icon, Modal } from "semantic-ui-react";
export const ModalComponent = (props) => {
    const { children, type, header, content, open, onClose, primaryAction, secondaryAction, onPrimaryActionClick, onSecondaryActionClick } = props, rest = __rest(props, ["children", "type", "header", "content", "open", "onClose", "primaryAction", "secondaryAction", "onPrimaryActionClick", "onSecondaryActionClick"]);
    const iconName = () => {
        if (type === "positive") {
            return (React.createElement("div", { className: "svg-box" },
                React.createElement("svg", { className: "circular positive-stroke" },
                    React.createElement("circle", { className: "path", cx: "75", cy: "75", r: "50", fill: "none", strokeWidth: "5", strokeMiterlimit: "10" })),
                React.createElement("svg", { className: "positive-icon positive-stroke" },
                    React.createElement("g", { transform: "matrix(0.79961,8.65821e-32,8.39584e-32,0.79961,-489.57,-205.679)" },
                        React.createElement("path", { className: "positive-icon__check", fill: "none", d: "M616.306,283.025L634.087,300.805L673.361,261.53" })))));
        }
        else if (type === "negative") {
            return (React.createElement("div", { className: "svg-box" },
                React.createElement("svg", { className: "circular negative-stroke" },
                    React.createElement("circle", { className: "path", cx: "75", cy: "75", r: "50", fill: "none", strokeWidth: "5", strokeMiterlimit: "10" })),
                React.createElement("svg", { className: "negative-icon negative-stroke" },
                    React.createElement("g", { transform: "matrix(0.79961,8.65821e-32,8.39584e-32,0.79961,-502.652,-204.518)" },
                        React.createElement("path", { className: "first-line", d: "M634.087,300.805L673.361,261.53", fill: "none" })),
                    React.createElement("g", { transform: "matrix(-1.28587e-16,-0.79961,0.79961,-1.28587e-16,-204.752,543.031)" },
                        React.createElement("path", { className: "second-line", d: "M634.087,300.805L673.361,261.53" })))));
        }
        else if (type === "warning") {
            return (React.createElement("div", { className: "svg-box" },
                React.createElement("svg", { className: "circular warning-stroke" },
                    React.createElement("circle", { className: "path", cx: "75", cy: "75", r: "50", fill: "none", strokeWidth: "5", strokeMiterlimit: "10" })),
                React.createElement("svg", { className: "warning-icon warning-stroke" },
                    React.createElement("g", { transform: "matrix(1,0,0,1,-615.516,-257.346)" },
                        React.createElement("g", { transform: "matrix(0.56541,-0.56541,0.56541,0.56541,93.7153,495.69)" },
                            React.createElement("path", { className: "line", d: "M634.087,300.805L673.361,261.53", fill: "none" })),
                        React.createElement("g", { transform: "matrix(2.27612,-2.46519e-32,0,2.27612,-792.339,-404.147)" },
                            React.createElement("circle", { className: "dot", cx: "621.52", cy: "316.126", r: "1.318" }))))));
        }
        else {
            return (React.createElement(Icon, { className: "modal-icon", name: "info circle", size: "huge", color: "blue" }));
        }
    };
    return (React.createElement(Modal, Object.assign({}, rest, { className: "custom-modal", open: open, onClose: onClose }),
        iconName(),
        React.createElement(Modal.Content, null,
            React.createElement("h3", { className: "modal-heading" }, header)),
        React.createElement("p", { className: "modal-description" }, content),
        children,
        React.createElement(Modal.Actions, null,
            React.createElement(Button, { className: `${type}-modal-link-button`, onClick: onSecondaryActionClick }, secondaryAction),
            React.createElement(Button, { className: `${type}-modal-primary-button`, onClick: () => onPrimaryActionClick() }, primaryAction))));
};
/**
 * Default proptypes for the settings section component.
 */
ModalComponent.defaultProps = {
    dimmer: "blurring",
    size: "tiny"
};
//# sourceMappingURL=modal.js.map