/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import classNames from "classnames";
import React from "react";
import { Divider, Header, Icon } from "semantic-ui-react";
import { GenericIcon } from "../icon";
/**
 * Page header component.
 *
 * @param {PageHeaderPropsInterface} props - Props injected to the component.
 * @return {JSX.Element}
 */
export const PageHeader = (props) => {
    const { backButton, bottomMargin, className, description, image, showBottomDivider, title, titleTextAlign } = props;
    const wrapperClasses = classNames("page-header-wrapper", {
        ["with-image"]: image,
    }, className);
    const innerClasses = classNames("page-header-inner", {
        ["with-image"]: image,
    });
    return ((title || description) && (React.createElement("div", { className: wrapperClasses },
        backButton && backButton.text && (React.createElement("div", { className: "back-button", onClick: backButton.onClick },
            React.createElement(Icon, { name: "arrow left" }),
            backButton.text)),
        React.createElement("div", { className: innerClasses },
            image && (React.createElement(GenericIcon, { icon: image, size: "tiny", transparent: true, spaced: "right" })),
            React.createElement(Header, { className: "page-header", as: "h1", textAlign: titleTextAlign },
                title && title,
                description && React.createElement(Header.Subheader, { className: "sub-header" }, description))),
        bottomMargin && React.createElement(Divider, { hidden: true }),
        showBottomDivider && React.createElement(Divider, null))));
};
PageHeader.defaultProps = {
    bottomMargin: true,
    showBottomDivider: false
};
//# sourceMappingURL=page-header.js.map