/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import classNames from "classnames";
import React from "react";
import { Dropdown, Pagination as SemanticPagination } from "semantic-ui-react";
/**
 * Pagination component.
 *
 * @param {PaginationPropsInterface} props - Props injected in to the component.
 * @return {JSX.Element}
 */
export const Pagination = (props) => {
    const { className, currentListSize, itemsPerPageDropdownLabel, itemsPerPageDropdownLowerLimit, itemsPerPageDropdownMultiple, itemsPerPageDropdownUpperLimit, onItemsPerPageDropdownChange, showItemsPerPageDropdown, showListSummary, totalListSize } = props, rest = __rest(props, ["className", "currentListSize", "itemsPerPageDropdownLabel", "itemsPerPageDropdownLowerLimit", "itemsPerPageDropdownMultiple", "itemsPerPageDropdownUpperLimit", "onItemsPerPageDropdownChange", "showItemsPerPageDropdown", "showListSummary", "totalListSize"]);
    const classes = classNames("pagination-bar", className);
    const generatePageCountDropdownOptions = () => {
        const options = [];
        for (let i = itemsPerPageDropdownLowerLimit; i <= itemsPerPageDropdownUpperLimit; i += itemsPerPageDropdownMultiple) {
            options.push({
                key: i,
                text: i,
                value: i
            });
        }
        return options;
    };
    return (React.createElement("div", { className: classes },
        showItemsPerPageDropdown && (React.createElement("label", null,
            itemsPerPageDropdownLabel,
            React.createElement(Dropdown, { className: "labeled horizontal right", compact: true, defaultValue: itemsPerPageDropdownLowerLimit, options: generatePageCountDropdownOptions(), onChange: onItemsPerPageDropdownChange, selection: true }))),
        React.createElement(SemanticPagination, Object.assign({ className: "list-pagination" }, rest))));
};
/**
 * Prop types for the Pagination component.
 */
Pagination.defaultProps = {
    defaultActivePage: 1,
    float: "right",
    itemsPerPageDropdownLabel: "Items per page",
    itemsPerPageDropdownLowerLimit: 10,
    itemsPerPageDropdownMultiple: 10,
    itemsPerPageDropdownUpperLimit: 50,
    showItemsPerPageDropdown: true
};
//# sourceMappingURL=pagination.js.map