import React, { PropsWithChildren } from "react";
import { ButtonProps } from "semantic-ui-react";
import { GenericIconSizes } from "../icon";
/**
 * Danger button component Prop types.
 */
interface IconButtonPropsInterface extends ButtonProps {
    customIcon?: any;
    customIconPosition?: "left" | "right";
    customIconSize?: GenericIconSizes;
}
/**
 * Icon button component.
 *
 * @param {IconButtonPropsInterface} props - Props injected to the component.
 * @return {JSX.Element}
 */
export declare const IconButton: React.FunctionComponent<PropsWithChildren<IconButtonPropsInterface>>;
export {};
