/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { FunctionComponent, MouseEvent } from "react";
import { CardProps } from "semantic-ui-react";
import { GenericIconSizes } from "../icon";
/**
 * Proptypes for the application template card component.
 */
interface ApplicationTemplateCardPropsInterface {
    /**
     * Additional classes.
     */
    className?: string;
    description: string;
    technologies?: TechnologyInterface[];
    disabled?: boolean;
    name: string;
    id?: string;
    image?: any;
    imageSize?: GenericIconSizes;
    onClick: (e: MouseEvent<HTMLAnchorElement>, data: CardProps) => void;
    selected?: boolean;
    textAlign?: "center" | "left" | "right";
    inline?: boolean;
}
interface TechnologyInterface {
    name: string;
    displayName: string;
    logo: any;
}
/**
 * Application template card component.
 *
 * @param {ApplicationTemplateCardPropsInterface} props - Props injected to the components.
 * @return {JSX.Element}
 * @constructor
 */
export declare const ApplicationTemplateCard: FunctionComponent<ApplicationTemplateCardPropsInterface>;
export {};
