/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as React from "react";
/**
 * Proptypes for the Icon component.
 */
export interface ThemeIconProps {
    bordered?: boolean;
    className?: string;
    colored?: boolean;
    defaultIcon?: boolean;
    floated?: string;
    icon: any;
    inline?: boolean;
    relaxed?: boolean | "very";
    rounded?: boolean;
    size?: ThemeIconSizes;
    spaced?: "left" | "right";
    style?: object;
    square?: boolean;
    transparent?: boolean;
    twoTone?: boolean;
}
export declare type ThemeIconSizes = "auto" | "nano" | "micro" | "mini" | "tiny" | "small" | "medium" | "large" | "big" | "huge" | "massive";
/**
 * Generic component to render icons.
 *
 * @param {React.PropsWithChildren<any>} props
 * @return {any}
 */
export declare const ThemeIcon: React.FunctionComponent<ThemeIconProps>;
