import React, { FunctionComponent } from "react";
/**
 *
 * Proptypes for the advanced search component
 */
interface AdvancedSearchProps {
    aligned?: "left" | "right" | "center";
    className?: string;
    clearButtonPopupLabel?: string;
    clearIcon?: any;
    defaultSearchStrategy: string;
    dropdownTriggerPopupLabel?: string;
    externalSearchQuery?: string;
    hintActionKeys?: string;
    hintLabel?: string;
    inputSize?: "mini" | "small" | "large" | "big" | "huge" | "massive";
    onExternalSearchQueryClear?: () => void;
    onSearchQuerySubmit: (processQuery: boolean, query: string) => void;
    placeholder?: string;
    resetSubmittedState?: () => void;
    searchOptionsHeader?: string;
    submitted?: boolean;
}
/**
 * Advanced search component.
 *
 * @param {React.PropsWithChildren<AdvancedSearchProps>} props - Props injected to the component.
 * @return {JSX.Element}
 */
export declare const AdvancedSearch: FunctionComponent<React.PropsWithChildren<AdvancedSearchProps>>;
export {};
