/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { FunctionComponent, MouseEvent, PropsWithChildren } from "react";
import { SemanticICONS } from "semantic-ui-react";
import { GenericIconSizes } from "../icon";
/**
 * Proptypes for the section component.
 */
export interface SectionProps {
    className?: string;
    contentPadding?: boolean;
    description?: string;
    header: string;
    icon?: any;
    iconMini?: any;
    iconFloated?: "left" | "right";
    iconStyle?: "twoTone" | "default" | "colored";
    iconSize?: GenericIconSizes;
    onPrimaryActionClick?: (e: MouseEvent<HTMLElement>) => void;
    onSecondaryActionClick?: (e: MouseEvent<HTMLElement>) => void;
    placeholder?: string;
    primaryAction?: any;
    primaryActionDisabled?: boolean;
    primaryActionIcon?: SemanticICONS;
    secondaryAction?: any;
    secondaryActionDisabled?: boolean;
    secondaryActionIcon?: SemanticICONS;
    showActionBar?: boolean;
    topActionBar?: React.ReactNode;
}
/**
 * Section component.
 *
 * @param {PropsWithChildren<SectionProps>} props - Props injected to the section component.
 * @return {JSX.Element}
 */
export declare const Section: FunctionComponent<PropsWithChildren<SectionProps>>;
