/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ChildRouteInterface, RouteInterface } from "@wso2is/core/models";
import React, { PropsWithChildren } from "react";
/**
 * Common side panel base component Prop types.
 */
export interface CommonSidePanelPropsInterface {
    caretIcon?: any;
    desktopContentTopSpacing?: number;
    footerHeight: number;
    headerHeight: number;
    icons: any;
    onSidePanelItemClick: (route: RouteInterface | ChildRouteInterface) => void;
    selected: RouteInterface | ChildRouteInterface;
    sidePanelItemHeight?: number;
    sidePanelPosition?: "absolute" | "fixed" | "inherit" | "initial" | "relative" | "static" | "sticky" | "unset";
    sidePanelTopMargin?: number | boolean;
    translationHook?: any;
}
/**
 * Side panel base component Prop types.
 */
interface SidePanelPropsInterface extends CommonSidePanelPropsInterface {
    bordered?: "left" | "right" | "top" | "bottom" | boolean;
    fluid?: boolean;
    mobileSidePanelVisibility: boolean;
    onSidePanelPusherClick: () => void;
    routes: RouteInterface[];
}
/**
 * Side panel base component.
 *
 * @param {SidePanelPropsInterface} props - Props injected to the component.
 * @return {React.ReactElement}
 */
export declare const SidePanel: React.FunctionComponent<PropsWithChildren<SidePanelPropsInterface>>;
export {};
