/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { FunctionComponent, ReactElement } from "react";
/**
 *Interface to contain props needed for treeview component
 */
interface TreeViewProps {
    data: TreeNode[];
    depth?: number;
    deleteElement?: ReactElement;
    getStyleClassCb?: (node: any, depth?: any) => {};
    isCheckable?: (node: TreeNode, depth: number) => {};
    isDeletable?: (node: TreeNode, depth: number) => {};
    isExpandable?: (node: TreeNode, depth: number) => {};
    keywordChildren?: string;
    keywordChildrenLoading?: string;
    keywordKey?: string;
    keywordLabel?: string;
    loadingElement?: ReactElement;
    noChildrenAvailableMessage?: string;
    onCheckToggleCb?: (arrayOfNodes: TreeNode[], depth: number) => void;
    onDeleteCb?: (node: TreeNode, updatedData: any, depth: number) => {};
    onExpandToggleCb?: (node: TreeNode, depth: number) => void;
    onUpdateCb?: (updatedData: any, depth: number) => void;
    transitionEnterTimeout?: number;
    transitionExitTimeout?: number;
}
/**
 * Interface to contain Tree node data
 */
interface TreeNode {
    id: string;
    name: string;
    isExpanded: boolean;
    isChecked: boolean;
    children?: TreeNode[];
}
/**
 * A Component which will return a tree view for a given set of node data.
 *
 * @param props Props to create a tree view component
 */
export declare const TreeView: FunctionComponent<TreeViewProps>;
export {};
