import { CompilerOptions } from "typescript";
import { ComponentNameResolver, PropFilter } from "react-docgen-typescript/lib/parser.js";
export default interface LoaderOptions {
    /** Avoid including docgen information for the prop or props specified. */
    skipPropsWithName?: string[] | string;
    /** Avoid including docgen information for props without documentation. */
    skipPropsWithoutDoc?: boolean;
    /**
     * If a string is returned, then the component will use that name. Else it will fallback to the default logic of parser.
     */
    componentNameResolver?: ComponentNameResolver;
    /**
     * Specify function to filter props.
     * If either skipPropsWithName or skipPropsWithoutDoc will be specified this will not be used.
     */
    propFilter?: PropFilter;
    /**
     * Specify the location of the tsconfig.json to use. Can not be used with
     * compilerOptions.
     **/
    tsconfigPath?: string;
    /** Specify TypeScript compiler options. Can not be used with tsconfigPath. */
    compilerOptions?: CompilerOptions;
    /**
     * Specify the docgen collection name to use. All docgen information will
     * be collected into this global object. Set to null to disable.
     *
     * @default STORYBOOK_REACT_CLASSES
     * @see https://github.com/gongreg/react-storybook-addon-docgen
     **/
    docgenCollectionName?: string | null;
    /**
     * Automatically set the component's display name. If you want to set display
     * names yourself or are using another plugin to do this, you should disable
     * this option.
     *
     * ```
     * class MyComponent extends React.Component {
     * ...
     * }
     *
     * MyComponent.displayName = "MyComponent";
     * ```
     *
     * @default true
     */
    setDisplayName?: boolean;
    /**
     * If set to true, string enums and unions will be converted to docgen enum format.
     * Useful if you use Storybook and want to generate knobs automatically using [addon-smart-knobs](https://github.com/storybookjs/addon-smart-knobs).
     * @see https://github.com/styleguidist/react-docgen-typescript#parseroptions
     * */
    shouldExtractLiteralValuesFromEnum?: boolean;
    /**
     * If set to true, defaultValue to props will be string.
     * @see https://github.com/styleguidist/react-docgen-typescript#parseroptions
     * */
    savePropValueAsString?: boolean;
    /**
     * Specifiy the name of the property for docgen info prop type.
     *
     * @default "type"
     */
    typePropName?: string;
}
