function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var React = require('react');
var React__default = _interopDefault(React);

var isFunction = function (obj) { return typeof obj === 'function'; };

var MDXContext = React__default.createContext({});
var withMDXComponents = function (Component) { return function (props) {
  var allComponents = useMDXComponents(props.components);
  return React__default.createElement( Component, Object.assign({}, props, { components: allComponents }));
}; };
var useMDXComponents = function (components) {
  var contextComponents = React__default.useContext(MDXContext);
  var allComponents = contextComponents;

  if (components) {
    allComponents = isFunction(components) ? components(contextComponents) : Object.assign({}, contextComponents,
      components);
  }

  return allComponents;
};
var MDXProvider = function (props) {
  var allComponents = useMDXComponents(props.components);
  return React__default.createElement( MDXContext.Provider, { value: allComponents },
      props.children
    );
};

function objectWithoutProperties (obj, exclude) { var target = {}; for (var k in obj) if (Object.prototype.hasOwnProperty.call(obj, k) && exclude.indexOf(k) === -1) target[k] = obj[k]; return target; }
var TYPE_PROP_NAME = 'mdxType';

var pre = function (ref) {
  var children = ref.children;
  var rest = objectWithoutProperties( ref, ["children"] );
  var props = rest;

  return React__default.createElement('pre', props, React__default.createElement('code', {
  children: children
}));
};

var wrapper = function (ref) {
  var children = ref.children;

  return React__default.createElement(React__default.Fragment, {}, children);
};

var DEFAULTS = {
  pre: pre,
  wrapper: wrapper
};
var MDXCreateElement = React.forwardRef(function (props, ref) {
  var mdxType = props.mdxType;
  var mdxComponents = props.mdxComponents;
  var originalType = props.originalType;
  var parentName = props.parentName;
  var rest = objectWithoutProperties( props, ["mdxType", "mdxComponents", "originalType", "parentName"] );
  var etc = rest;
  var components = useMDXComponents(mdxComponents);
  var type = mdxType;
  var Component = components[(parentName + "." + type)] || components[type] || DEFAULTS[type] || originalType;

  if (mdxComponents) {
    return React__default.createElement(Component, Object.assign({}, {ref: ref,
      mdxComponents: mdxComponents},
      etc));
  }

  return React__default.createElement(Component, Object.assign({}, {ref: ref},
    etc));
});
MDXCreateElement.displayName = 'MDXCreateElement';
function createElement (type, props) {
  var args = arguments;
  var mdxType = props && props.mdxType;

  if (typeof type === 'string' || mdxType) {
    var argsLength = args.length;
    var createElementArgArray = new Array(argsLength);
    createElementArgArray[0] = MDXCreateElement;
    var newProps = {};

    for (var key in props) {
      if (hasOwnProperty.call(props, key)) {
        newProps[key] = props[key];
      }
    }

    newProps.originalType = type;
    newProps[TYPE_PROP_NAME] = typeof type === 'string' ? type : mdxType;
    createElementArgArray[1] = newProps;

    for (var i = 2; i < argsLength; i++) {
      createElementArgArray[i] = args[i];
    }

    return React__default.createElement.apply(null, createElementArgArray);
  }

  return React__default.createElement.apply(null, args);
}

exports.MDXContext = MDXContext;
exports.MDXProvider = MDXProvider;
exports.useMDXComponents = useMDXComponents;
exports.withMDXComponents = withMDXComponents;
exports.mdx = createElement;
