// DO NOT EDIT THIS FILE
import { RequestHeaders } from "../RequestHeaders";
import { RequestRequestOptions } from "../RequestRequestOptions";
import { Url } from "../Url";

export interface Endpoints {
  "DELETE /app/installations/:installation_id": [
    AppsDeleteInstallationEndpoint,
    AppsDeleteInstallationRequestOptions
  ];
  "DELETE /applications/:client_id/grant": [
    AppsDeleteAuthorizationEndpoint,
    AppsDeleteAuthorizationRequestOptions
  ];
  "DELETE /applications/:client_id/grants/:access_token": [

      | AppsRevokeGrantForApplicationEndpoint
      | OauthAuthorizationsRevokeGrantForApplicationEndpoint,

      | AppsRevokeGrantForApplicationRequestOptions
      | OauthAuthorizationsRevokeGrantForApplicationRequestOptions
  ];
  "DELETE /applications/:client_id/token": [
    AppsDeleteTokenEndpoint,
    AppsDeleteTokenRequestOptions
  ];
  "DELETE /applications/:client_id/tokens/:access_token": [

      | AppsRevokeAuthorizationForApplicationEndpoint
      | OauthAuthorizationsRevokeAuthorizationForApplicationEndpoint,

      | AppsRevokeAuthorizationForApplicationRequestOptions
      | OauthAuthorizationsRevokeAuthorizationForApplicationRequestOptions
  ];
  "DELETE /applications/grants/:grant_id": [
    OauthAuthorizationsDeleteGrantEndpoint,
    OauthAuthorizationsDeleteGrantRequestOptions
  ];
  "DELETE /authorizations/:authorization_id": [
    OauthAuthorizationsDeleteAuthorizationEndpoint,
    OauthAuthorizationsDeleteAuthorizationRequestOptions
  ];
  "DELETE /gists/:gist_id": [GistsDeleteEndpoint, GistsDeleteRequestOptions];
  "DELETE /gists/:gist_id/comments/:comment_id": [
    GistsDeleteCommentEndpoint,
    GistsDeleteCommentRequestOptions
  ];
  "DELETE /gists/:gist_id/star": [
    GistsUnstarEndpoint,
    GistsUnstarRequestOptions
  ];
  "DELETE /installation/token": [
    AppsRevokeInstallationTokenEndpoint,
    AppsRevokeInstallationTokenRequestOptions
  ];
  "DELETE /notifications/threads/:thread_id/subscription": [
    ActivityDeleteThreadSubscriptionEndpoint,
    ActivityDeleteThreadSubscriptionRequestOptions
  ];
  "DELETE /orgs/:org/blocks/:username": [
    OrgsUnblockUserEndpoint,
    OrgsUnblockUserRequestOptions
  ];
  "DELETE /orgs/:org/credential-authorizations/:credential_id": [
    OrgsRemoveCredentialAuthorizationEndpoint,
    OrgsRemoveCredentialAuthorizationRequestOptions
  ];
  "DELETE /orgs/:org/hooks/:hook_id": [
    OrgsDeleteHookEndpoint,
    OrgsDeleteHookRequestOptions
  ];
  "DELETE /orgs/:org/interaction-limits": [
    InteractionsRemoveRestrictionsForOrgEndpoint,
    InteractionsRemoveRestrictionsForOrgRequestOptions
  ];
  "DELETE /orgs/:org/members/:username": [
    OrgsRemoveMemberEndpoint,
    OrgsRemoveMemberRequestOptions
  ];
  "DELETE /orgs/:org/memberships/:username": [
    OrgsRemoveMembershipEndpoint,
    OrgsRemoveMembershipRequestOptions
  ];
  "DELETE /orgs/:org/migrations/:migration_id/archive": [
    MigrationsDeleteArchiveForOrgEndpoint,
    MigrationsDeleteArchiveForOrgRequestOptions
  ];
  "DELETE /orgs/:org/migrations/:migration_id/repos/:repo_name/lock": [
    MigrationsUnlockRepoForOrgEndpoint,
    MigrationsUnlockRepoForOrgRequestOptions
  ];
  "DELETE /orgs/:org/outside_collaborators/:username": [
    OrgsRemoveOutsideCollaboratorEndpoint,
    OrgsRemoveOutsideCollaboratorRequestOptions
  ];
  "DELETE /orgs/:org/public_members/:username": [
    OrgsConcealMembershipEndpoint,
    OrgsConcealMembershipRequestOptions
  ];
  "DELETE /orgs/:org/teams/:team_slug": [
    TeamsDeleteInOrgEndpoint,
    TeamsDeleteInOrgRequestOptions
  ];
  "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number": [
    TeamsDeleteDiscussionInOrgEndpoint,
    TeamsDeleteDiscussionInOrgRequestOptions
  ];
  "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": [
    TeamsDeleteDiscussionCommentInOrgEndpoint,
    TeamsDeleteDiscussionCommentInOrgRequestOptions
  ];
  "DELETE /orgs/:org/teams/:team_slug/memberships/:username": [
    TeamsRemoveMembershipInOrgEndpoint,
    TeamsRemoveMembershipInOrgRequestOptions
  ];
  "DELETE /orgs/:org/teams/:team_slug/projects/:project_id": [
    TeamsRemoveProjectInOrgEndpoint,
    TeamsRemoveProjectInOrgRequestOptions
  ];
  "DELETE /orgs/:org/teams/:team_slug/repos/:owner/:repo": [
    TeamsRemoveRepoInOrgEndpoint,
    TeamsRemoveRepoInOrgRequestOptions
  ];
  "DELETE /projects/:project_id": [
    ProjectsDeleteEndpoint,
    ProjectsDeleteRequestOptions
  ];
  "DELETE /projects/:project_id/collaborators/:username": [
    ProjectsRemoveCollaboratorEndpoint,
    ProjectsRemoveCollaboratorRequestOptions
  ];
  "DELETE /projects/columns/:column_id": [
    ProjectsDeleteColumnEndpoint,
    ProjectsDeleteColumnRequestOptions
  ];
  "DELETE /projects/columns/cards/:card_id": [
    ProjectsDeleteCardEndpoint,
    ProjectsDeleteCardRequestOptions
  ];
  "DELETE /reactions/:reaction_id": [
    ReactionsDeleteEndpoint,
    ReactionsDeleteRequestOptions
  ];
  "DELETE /repos/:owner/:repo": [
    ReposDeleteEndpoint,
    ReposDeleteRequestOptions
  ];
  "DELETE /repos/:owner/:repo/automated-security-fixes": [
    ReposDisableAutomatedSecurityFixesEndpoint,
    ReposDisableAutomatedSecurityFixesRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection": [
    ReposRemoveBranchProtectionEndpoint,
    ReposRemoveBranchProtectionRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection/enforce_admins": [
    ReposRemoveProtectedBranchAdminEnforcementEndpoint,
    ReposRemoveProtectedBranchAdminEnforcementRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": [
    ReposRemoveProtectedBranchPullRequestReviewEnforcementEndpoint,
    ReposRemoveProtectedBranchPullRequestReviewEnforcementRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection/required_signatures": [
    ReposRemoveProtectedBranchRequiredSignaturesEndpoint,
    ReposRemoveProtectedBranchRequiredSignaturesRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection/required_status_checks": [
    ReposRemoveProtectedBranchRequiredStatusChecksEndpoint,
    ReposRemoveProtectedBranchRequiredStatusChecksRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": [
    ReposRemoveProtectedBranchRequiredStatusChecksContextsEndpoint,
    ReposRemoveProtectedBranchRequiredStatusChecksContextsRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions": [
    ReposRemoveProtectedBranchRestrictionsEndpoint,
    ReposRemoveProtectedBranchRestrictionsRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": [
    ReposRemoveProtectedBranchAppRestrictionsEndpoint,
    ReposRemoveProtectedBranchAppRestrictionsRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": [
    ReposRemoveProtectedBranchTeamRestrictionsEndpoint,
    ReposRemoveProtectedBranchTeamRestrictionsRequestOptions
  ];
  "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/users": [
    ReposRemoveProtectedBranchUserRestrictionsEndpoint,
    ReposRemoveProtectedBranchUserRestrictionsRequestOptions
  ];
  "DELETE /repos/:owner/:repo/collaborators/:username": [
    ReposRemoveCollaboratorEndpoint,
    ReposRemoveCollaboratorRequestOptions
  ];
  "DELETE /repos/:owner/:repo/comments/:comment_id": [
    ReposDeleteCommitCommentEndpoint,
    ReposDeleteCommitCommentRequestOptions
  ];
  "DELETE /repos/:owner/:repo/contents/:path": [
    ReposDeleteFileEndpoint,
    ReposDeleteFileRequestOptions
  ];
  "DELETE /repos/:owner/:repo/downloads/:download_id": [
    ReposDeleteDownloadEndpoint,
    ReposDeleteDownloadRequestOptions
  ];
  "DELETE /repos/:owner/:repo/git/refs/:ref": [
    GitDeleteRefEndpoint,
    GitDeleteRefRequestOptions
  ];
  "DELETE /repos/:owner/:repo/hooks/:hook_id": [
    ReposDeleteHookEndpoint,
    ReposDeleteHookRequestOptions
  ];
  "DELETE /repos/:owner/:repo/import": [
    MigrationsCancelImportEndpoint,
    MigrationsCancelImportRequestOptions
  ];
  "DELETE /repos/:owner/:repo/interaction-limits": [
    InteractionsRemoveRestrictionsForRepoEndpoint,
    InteractionsRemoveRestrictionsForRepoRequestOptions
  ];
  "DELETE /repos/:owner/:repo/invitations/:invitation_id": [
    ReposDeleteInvitationEndpoint,
    ReposDeleteInvitationRequestOptions
  ];
  "DELETE /repos/:owner/:repo/issues/:issue_number/assignees": [
    IssuesRemoveAssigneesEndpoint,
    IssuesRemoveAssigneesRequestOptions
  ];
  "DELETE /repos/:owner/:repo/issues/:issue_number/labels": [
    IssuesRemoveLabelsEndpoint,
    IssuesRemoveLabelsRequestOptions
  ];
  "DELETE /repos/:owner/:repo/issues/:issue_number/labels/:name": [
    IssuesRemoveLabelEndpoint,
    IssuesRemoveLabelRequestOptions
  ];
  "DELETE /repos/:owner/:repo/issues/:issue_number/lock": [
    IssuesUnlockEndpoint,
    IssuesUnlockRequestOptions
  ];
  "DELETE /repos/:owner/:repo/issues/comments/:comment_id": [
    IssuesDeleteCommentEndpoint,
    IssuesDeleteCommentRequestOptions
  ];
  "DELETE /repos/:owner/:repo/keys/:key_id": [
    ReposRemoveDeployKeyEndpoint,
    ReposRemoveDeployKeyRequestOptions
  ];
  "DELETE /repos/:owner/:repo/labels/:name": [
    IssuesDeleteLabelEndpoint,
    IssuesDeleteLabelRequestOptions
  ];
  "DELETE /repos/:owner/:repo/milestones/:milestone_number": [
    IssuesDeleteMilestoneEndpoint,
    IssuesDeleteMilestoneRequestOptions
  ];
  "DELETE /repos/:owner/:repo/pages": [
    ReposDisablePagesSiteEndpoint,
    ReposDisablePagesSiteRequestOptions
  ];
  "DELETE /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": [
    PullsDeleteReviewRequestEndpoint,
    PullsDeleteReviewRequestRequestOptions
  ];
  "DELETE /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": [
    PullsDeletePendingReviewEndpoint,
    PullsDeletePendingReviewRequestOptions
  ];
  "DELETE /repos/:owner/:repo/pulls/comments/:comment_id": [
    PullsDeleteCommentEndpoint,
    PullsDeleteCommentRequestOptions
  ];
  "DELETE /repos/:owner/:repo/releases/:release_id": [
    ReposDeleteReleaseEndpoint,
    ReposDeleteReleaseRequestOptions
  ];
  "DELETE /repos/:owner/:repo/releases/assets/:asset_id": [
    ReposDeleteReleaseAssetEndpoint,
    ReposDeleteReleaseAssetRequestOptions
  ];
  "DELETE /repos/:owner/:repo/subscription": [
    ActivityDeleteRepoSubscriptionEndpoint,
    ActivityDeleteRepoSubscriptionRequestOptions
  ];
  "DELETE /repos/:owner/:repo/vulnerability-alerts": [
    ReposDisableVulnerabilityAlertsEndpoint,
    ReposDisableVulnerabilityAlertsRequestOptions
  ];
  "DELETE /scim/v2/organizations/:org/Users/:scim_user_id": [
    ScimRemoveUserFromOrgEndpoint,
    ScimRemoveUserFromOrgRequestOptions
  ];
  "DELETE /teams/:team_id": [
    TeamsDeleteLegacyEndpoint | TeamsDeleteEndpoint,
    TeamsDeleteLegacyRequestOptions | TeamsDeleteRequestOptions
  ];
  "DELETE /teams/:team_id/discussions/:discussion_number": [
    TeamsDeleteDiscussionLegacyEndpoint | TeamsDeleteDiscussionEndpoint,

      | TeamsDeleteDiscussionLegacyRequestOptions
      | TeamsDeleteDiscussionRequestOptions
  ];
  "DELETE /teams/:team_id/discussions/:discussion_number/comments/:comment_number": [

      | TeamsDeleteDiscussionCommentLegacyEndpoint
      | TeamsDeleteDiscussionCommentEndpoint,

      | TeamsDeleteDiscussionCommentLegacyRequestOptions
      | TeamsDeleteDiscussionCommentRequestOptions
  ];
  "DELETE /teams/:team_id/members/:username": [
    TeamsRemoveMemberLegacyEndpoint,
    TeamsRemoveMemberLegacyRequestOptions
  ];
  "DELETE /teams/:team_id/memberships/:username": [
    TeamsRemoveMembershipLegacyEndpoint,
    TeamsRemoveMembershipLegacyRequestOptions
  ];
  "DELETE /teams/:team_id/projects/:project_id": [
    TeamsRemoveProjectLegacyEndpoint | TeamsRemoveProjectEndpoint,
    TeamsRemoveProjectLegacyRequestOptions | TeamsRemoveProjectRequestOptions
  ];
  "DELETE /teams/:team_id/repos/:owner/:repo": [
    TeamsRemoveRepoLegacyEndpoint | TeamsRemoveRepoEndpoint,
    TeamsRemoveRepoLegacyRequestOptions | TeamsRemoveRepoRequestOptions
  ];
  "DELETE /user/blocks/:username": [
    UsersUnblockEndpoint,
    UsersUnblockRequestOptions
  ];
  "DELETE /user/emails": [
    UsersDeleteEmailsEndpoint,
    UsersDeleteEmailsRequestOptions
  ];
  "DELETE /user/following/:username": [
    UsersUnfollowEndpoint,
    UsersUnfollowRequestOptions
  ];
  "DELETE /user/gpg_keys/:gpg_key_id": [
    UsersDeleteGpgKeyEndpoint,
    UsersDeleteGpgKeyRequestOptions
  ];
  "DELETE /user/installations/:installation_id/repositories/:repository_id": [
    AppsRemoveRepoFromInstallationEndpoint,
    AppsRemoveRepoFromInstallationRequestOptions
  ];
  "DELETE /user/keys/:key_id": [
    UsersDeletePublicKeyEndpoint,
    UsersDeletePublicKeyRequestOptions
  ];
  "DELETE /user/migrations/:migration_id/archive": [
    MigrationsDeleteArchiveForAuthenticatedUserEndpoint,
    MigrationsDeleteArchiveForAuthenticatedUserRequestOptions
  ];
  "DELETE /user/migrations/:migration_id/repos/:repo_name/lock": [
    MigrationsUnlockRepoForAuthenticatedUserEndpoint,
    MigrationsUnlockRepoForAuthenticatedUserRequestOptions
  ];
  "DELETE /user/repository_invitations/:invitation_id": [
    ReposDeclineInvitationEndpoint,
    ReposDeclineInvitationRequestOptions
  ];
  "DELETE /user/starred/:owner/:repo": [
    ActivityUnstarRepoEndpoint,
    ActivityUnstarRepoRequestOptions
  ];
  "DELETE /user/subscriptions/:owner/:repo": [
    ActivityStopWatchingRepoLegacyEndpoint,
    ActivityStopWatchingRepoLegacyRequestOptions
  ];
  "GET /app": [
    AppsGetAuthenticatedEndpoint,
    AppsGetAuthenticatedRequestOptions
  ];
  "GET /app/installations": [
    AppsListInstallationsEndpoint,
    AppsListInstallationsRequestOptions
  ];
  "GET /app/installations/:installation_id": [
    AppsGetInstallationEndpoint,
    AppsGetInstallationRequestOptions
  ];
  "GET /applications/:client_id/tokens/:access_token": [

      | AppsCheckAuthorizationEndpoint
      | OauthAuthorizationsCheckAuthorizationEndpoint,

      | AppsCheckAuthorizationRequestOptions
      | OauthAuthorizationsCheckAuthorizationRequestOptions
  ];
  "GET /applications/grants": [
    OauthAuthorizationsListGrantsEndpoint,
    OauthAuthorizationsListGrantsRequestOptions
  ];
  "GET /applications/grants/:grant_id": [
    OauthAuthorizationsGetGrantEndpoint,
    OauthAuthorizationsGetGrantRequestOptions
  ];
  "GET /apps/:app_slug": [AppsGetBySlugEndpoint, AppsGetBySlugRequestOptions];
  "GET /authorizations": [
    OauthAuthorizationsListAuthorizationsEndpoint,
    OauthAuthorizationsListAuthorizationsRequestOptions
  ];
  "GET /authorizations/:authorization_id": [
    OauthAuthorizationsGetAuthorizationEndpoint,
    OauthAuthorizationsGetAuthorizationRequestOptions
  ];
  "GET /codes_of_conduct": [
    CodesOfConductListConductCodesEndpoint,
    CodesOfConductListConductCodesRequestOptions
  ];
  "GET /codes_of_conduct/:key": [
    CodesOfConductGetConductCodeEndpoint,
    CodesOfConductGetConductCodeRequestOptions
  ];
  "GET /emojis": [EmojisGetEndpoint, EmojisGetRequestOptions];
  "GET /events": [
    ActivityListPublicEventsEndpoint,
    ActivityListPublicEventsRequestOptions
  ];
  "GET /feeds": [ActivityListFeedsEndpoint, ActivityListFeedsRequestOptions];
  "GET /gists": [GistsListEndpoint, GistsListRequestOptions];
  "GET /gists/:gist_id": [GistsGetEndpoint, GistsGetRequestOptions];
  "GET /gists/:gist_id/:sha": [
    GistsGetRevisionEndpoint,
    GistsGetRevisionRequestOptions
  ];
  "GET /gists/:gist_id/comments": [
    GistsListCommentsEndpoint,
    GistsListCommentsRequestOptions
  ];
  "GET /gists/:gist_id/comments/:comment_id": [
    GistsGetCommentEndpoint,
    GistsGetCommentRequestOptions
  ];
  "GET /gists/:gist_id/commits": [
    GistsListCommitsEndpoint,
    GistsListCommitsRequestOptions
  ];
  "GET /gists/:gist_id/forks": [
    GistsListForksEndpoint,
    GistsListForksRequestOptions
  ];
  "GET /gists/:gist_id/star": [
    GistsCheckIsStarredEndpoint,
    GistsCheckIsStarredRequestOptions
  ];
  "GET /gists/public": [GistsListPublicEndpoint, GistsListPublicRequestOptions];
  "GET /gists/starred": [
    GistsListStarredEndpoint,
    GistsListStarredRequestOptions
  ];
  "GET /gitignore/templates": [
    GitignoreListTemplatesEndpoint,
    GitignoreListTemplatesRequestOptions
  ];
  "GET /gitignore/templates/:name": [
    GitignoreGetTemplateEndpoint,
    GitignoreGetTemplateRequestOptions
  ];
  "GET /installation/repositories": [
    AppsListReposEndpoint,
    AppsListReposRequestOptions
  ];
  "GET /issues": [IssuesListEndpoint, IssuesListRequestOptions];
  "GET /legacy/issues/search/:owner/:repository/:state/:keyword": [
    SearchIssuesLegacyEndpoint,
    SearchIssuesLegacyRequestOptions
  ];
  "GET /legacy/repos/search/:keyword": [
    SearchReposLegacyEndpoint,
    SearchReposLegacyRequestOptions
  ];
  "GET /legacy/user/email/:email": [
    SearchEmailLegacyEndpoint,
    SearchEmailLegacyRequestOptions
  ];
  "GET /legacy/user/search/:keyword": [
    SearchUsersLegacyEndpoint,
    SearchUsersLegacyRequestOptions
  ];
  "GET /licenses": [
    LicensesListCommonlyUsedEndpoint | LicensesListEndpoint,
    LicensesListCommonlyUsedRequestOptions | LicensesListRequestOptions
  ];
  "GET /licenses/:license": [LicensesGetEndpoint, LicensesGetRequestOptions];
  "GET /marketplace_listing/accounts/:account_id": [
    AppsCheckAccountIsAssociatedWithAnyEndpoint,
    AppsCheckAccountIsAssociatedWithAnyRequestOptions
  ];
  "GET /marketplace_listing/plans": [
    AppsListPlansEndpoint,
    AppsListPlansRequestOptions
  ];
  "GET /marketplace_listing/plans/:plan_id/accounts": [
    AppsListAccountsUserOrOrgOnPlanEndpoint,
    AppsListAccountsUserOrOrgOnPlanRequestOptions
  ];
  "GET /marketplace_listing/stubbed/accounts/:account_id": [
    AppsCheckAccountIsAssociatedWithAnyStubbedEndpoint,
    AppsCheckAccountIsAssociatedWithAnyStubbedRequestOptions
  ];
  "GET /marketplace_listing/stubbed/plans": [
    AppsListPlansStubbedEndpoint,
    AppsListPlansStubbedRequestOptions
  ];
  "GET /marketplace_listing/stubbed/plans/:plan_id/accounts": [
    AppsListAccountsUserOrOrgOnPlanStubbedEndpoint,
    AppsListAccountsUserOrOrgOnPlanStubbedRequestOptions
  ];
  "GET /meta": [MetaGetEndpoint, MetaGetRequestOptions];
  "GET /networks/:owner/:repo/events": [
    ActivityListPublicEventsForRepoNetworkEndpoint,
    ActivityListPublicEventsForRepoNetworkRequestOptions
  ];
  "GET /notifications": [
    ActivityListNotificationsEndpoint,
    ActivityListNotificationsRequestOptions
  ];
  "GET /notifications/threads/:thread_id": [
    ActivityGetThreadEndpoint,
    ActivityGetThreadRequestOptions
  ];
  "GET /notifications/threads/:thread_id/subscription": [
    ActivityGetThreadSubscriptionEndpoint,
    ActivityGetThreadSubscriptionRequestOptions
  ];
  "GET /organizations": [OrgsListEndpoint, OrgsListRequestOptions];
  "GET /orgs/:org": [OrgsGetEndpoint, OrgsGetRequestOptions];
  "GET /orgs/:org/blocks": [
    OrgsListBlockedUsersEndpoint,
    OrgsListBlockedUsersRequestOptions
  ];
  "GET /orgs/:org/blocks/:username": [
    OrgsCheckBlockedUserEndpoint,
    OrgsCheckBlockedUserRequestOptions
  ];
  "GET /orgs/:org/credential-authorizations": [
    OrgsListCredentialAuthorizationsEndpoint,
    OrgsListCredentialAuthorizationsRequestOptions
  ];
  "GET /orgs/:org/events": [
    ActivityListPublicEventsForOrgEndpoint,
    ActivityListPublicEventsForOrgRequestOptions
  ];
  "GET /orgs/:org/hooks": [OrgsListHooksEndpoint, OrgsListHooksRequestOptions];
  "GET /orgs/:org/hooks/:hook_id": [
    OrgsGetHookEndpoint,
    OrgsGetHookRequestOptions
  ];
  "GET /orgs/:org/installation": [
    AppsGetOrgInstallationEndpoint | AppsFindOrgInstallationEndpoint,
    AppsGetOrgInstallationRequestOptions | AppsFindOrgInstallationRequestOptions
  ];
  "GET /orgs/:org/installations": [
    OrgsListInstallationsEndpoint,
    OrgsListInstallationsRequestOptions
  ];
  "GET /orgs/:org/interaction-limits": [
    InteractionsGetRestrictionsForOrgEndpoint,
    InteractionsGetRestrictionsForOrgRequestOptions
  ];
  "GET /orgs/:org/invitations": [
    OrgsListPendingInvitationsEndpoint,
    OrgsListPendingInvitationsRequestOptions
  ];
  "GET /orgs/:org/invitations/:invitation_id/teams": [
    OrgsListInvitationTeamsEndpoint,
    OrgsListInvitationTeamsRequestOptions
  ];
  "GET /orgs/:org/issues": [
    IssuesListForOrgEndpoint,
    IssuesListForOrgRequestOptions
  ];
  "GET /orgs/:org/members": [
    OrgsListMembersEndpoint,
    OrgsListMembersRequestOptions
  ];
  "GET /orgs/:org/members/:username": [
    OrgsCheckMembershipEndpoint,
    OrgsCheckMembershipRequestOptions
  ];
  "GET /orgs/:org/memberships/:username": [
    OrgsGetMembershipEndpoint,
    OrgsGetMembershipRequestOptions
  ];
  "GET /orgs/:org/migrations": [
    MigrationsListForOrgEndpoint,
    MigrationsListForOrgRequestOptions
  ];
  "GET /orgs/:org/migrations/:migration_id": [
    MigrationsGetStatusForOrgEndpoint,
    MigrationsGetStatusForOrgRequestOptions
  ];
  "GET /orgs/:org/migrations/:migration_id/archive": [
    MigrationsGetArchiveForOrgEndpoint,
    MigrationsGetArchiveForOrgRequestOptions
  ];
  "GET /orgs/:org/migrations/:migration_id/repositories": [
    MigrationsListReposForOrgEndpoint,
    MigrationsListReposForOrgRequestOptions
  ];
  "GET /orgs/:org/outside_collaborators": [
    OrgsListOutsideCollaboratorsEndpoint,
    OrgsListOutsideCollaboratorsRequestOptions
  ];
  "GET /orgs/:org/projects": [
    ProjectsListForOrgEndpoint,
    ProjectsListForOrgRequestOptions
  ];
  "GET /orgs/:org/public_members": [
    OrgsListPublicMembersEndpoint,
    OrgsListPublicMembersRequestOptions
  ];
  "GET /orgs/:org/public_members/:username": [
    OrgsCheckPublicMembershipEndpoint,
    OrgsCheckPublicMembershipRequestOptions
  ];
  "GET /orgs/:org/repos": [
    ReposListForOrgEndpoint,
    ReposListForOrgRequestOptions
  ];
  "GET /orgs/:org/team-sync/groups": [
    TeamsListIdPGroupsForOrgEndpoint,
    TeamsListIdPGroupsForOrgRequestOptions
  ];
  "GET /orgs/:org/teams": [TeamsListEndpoint, TeamsListRequestOptions];
  "GET /orgs/:org/teams/:team_slug": [
    TeamsGetByNameEndpoint,
    TeamsGetByNameRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/discussions": [
    TeamsListDiscussionsInOrgEndpoint,
    TeamsListDiscussionsInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number": [
    TeamsGetDiscussionInOrgEndpoint,
    TeamsGetDiscussionInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments": [
    TeamsListDiscussionCommentsInOrgEndpoint,
    TeamsListDiscussionCommentsInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": [
    TeamsGetDiscussionCommentInOrgEndpoint,
    TeamsGetDiscussionCommentInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions": [
    ReactionsListForTeamDiscussionCommentInOrgEndpoint,
    ReactionsListForTeamDiscussionCommentInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions": [
    ReactionsListForTeamDiscussionInOrgEndpoint,
    ReactionsListForTeamDiscussionInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/invitations": [
    TeamsListPendingInvitationsInOrgEndpoint,
    TeamsListPendingInvitationsInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/members": [
    TeamsListMembersInOrgEndpoint,
    TeamsListMembersInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/memberships/:username": [
    TeamsGetMembershipInOrgEndpoint,
    TeamsGetMembershipInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/projects": [
    TeamsListProjectsInOrgEndpoint,
    TeamsListProjectsInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/projects/:project_id": [
    TeamsReviewProjectInOrgEndpoint,
    TeamsReviewProjectInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/repos": [
    TeamsListReposInOrgEndpoint,
    TeamsListReposInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/repos/:owner/:repo": [
    TeamsCheckManagesRepoInOrgEndpoint,
    TeamsCheckManagesRepoInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/team-sync/group-mappings": [
    TeamsListIdPGroupsInOrgEndpoint,
    TeamsListIdPGroupsInOrgRequestOptions
  ];
  "GET /orgs/:org/teams/:team_slug/teams": [
    TeamsListChildInOrgEndpoint,
    TeamsListChildInOrgRequestOptions
  ];
  "GET /projects/:project_id": [ProjectsGetEndpoint, ProjectsGetRequestOptions];
  "GET /projects/:project_id/collaborators": [
    ProjectsListCollaboratorsEndpoint,
    ProjectsListCollaboratorsRequestOptions
  ];
  "GET /projects/:project_id/collaborators/:username/permission": [
    ProjectsReviewUserPermissionLevelEndpoint,
    ProjectsReviewUserPermissionLevelRequestOptions
  ];
  "GET /projects/:project_id/columns": [
    ProjectsListColumnsEndpoint,
    ProjectsListColumnsRequestOptions
  ];
  "GET /projects/columns/:column_id": [
    ProjectsGetColumnEndpoint,
    ProjectsGetColumnRequestOptions
  ];
  "GET /projects/columns/:column_id/cards": [
    ProjectsListCardsEndpoint,
    ProjectsListCardsRequestOptions
  ];
  "GET /projects/columns/cards/:card_id": [
    ProjectsGetCardEndpoint,
    ProjectsGetCardRequestOptions
  ];
  "GET /rate_limit": [RateLimitGetEndpoint, RateLimitGetRequestOptions];
  "GET /repos/:owner/:repo": [ReposGetEndpoint, ReposGetRequestOptions];
  "GET /repos/:owner/:repo/:archive_format/:ref": [
    ReposGetArchiveLinkEndpoint,
    ReposGetArchiveLinkRequestOptions
  ];
  "GET /repos/:owner/:repo/assignees": [
    IssuesListAssigneesEndpoint,
    IssuesListAssigneesRequestOptions
  ];
  "GET /repos/:owner/:repo/assignees/:assignee": [
    IssuesCheckAssigneeEndpoint,
    IssuesCheckAssigneeRequestOptions
  ];
  "GET /repos/:owner/:repo/branches": [
    ReposListBranchesEndpoint,
    ReposListBranchesRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch": [
    ReposGetBranchEndpoint,
    ReposGetBranchRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection": [
    ReposGetBranchProtectionEndpoint,
    ReposGetBranchProtectionRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection/enforce_admins": [
    ReposGetProtectedBranchAdminEnforcementEndpoint,
    ReposGetProtectedBranchAdminEnforcementRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": [
    ReposGetProtectedBranchPullRequestReviewEnforcementEndpoint,
    ReposGetProtectedBranchPullRequestReviewEnforcementRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection/required_signatures": [
    ReposGetProtectedBranchRequiredSignaturesEndpoint,
    ReposGetProtectedBranchRequiredSignaturesRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection/required_status_checks": [
    ReposGetProtectedBranchRequiredStatusChecksEndpoint,
    ReposGetProtectedBranchRequiredStatusChecksRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": [
    ReposListProtectedBranchRequiredStatusChecksContextsEndpoint,
    ReposListProtectedBranchRequiredStatusChecksContextsRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection/restrictions": [
    ReposGetProtectedBranchRestrictionsEndpoint,
    ReposGetProtectedBranchRestrictionsRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": [

      | ReposGetAppsWithAccessToProtectedBranchEndpoint
      | ReposListAppsWithAccessToProtectedBranchEndpoint,

      | ReposGetAppsWithAccessToProtectedBranchRequestOptions
      | ReposListAppsWithAccessToProtectedBranchRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": [

      | ReposGetTeamsWithAccessToProtectedBranchEndpoint
      | ReposListProtectedBranchTeamRestrictionsEndpoint
      | ReposListTeamsWithAccessToProtectedBranchEndpoint,

      | ReposGetTeamsWithAccessToProtectedBranchRequestOptions
      | ReposListProtectedBranchTeamRestrictionsRequestOptions
      | ReposListTeamsWithAccessToProtectedBranchRequestOptions
  ];
  "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/users": [

      | ReposGetUsersWithAccessToProtectedBranchEndpoint
      | ReposListProtectedBranchUserRestrictionsEndpoint
      | ReposListUsersWithAccessToProtectedBranchEndpoint,

      | ReposGetUsersWithAccessToProtectedBranchRequestOptions
      | ReposListProtectedBranchUserRestrictionsRequestOptions
      | ReposListUsersWithAccessToProtectedBranchRequestOptions
  ];
  "GET /repos/:owner/:repo/check-runs/:check_run_id": [
    ChecksGetEndpoint,
    ChecksGetRequestOptions
  ];
  "GET /repos/:owner/:repo/check-runs/:check_run_id/annotations": [
    ChecksListAnnotationsEndpoint,
    ChecksListAnnotationsRequestOptions
  ];
  "GET /repos/:owner/:repo/check-suites/:check_suite_id": [
    ChecksGetSuiteEndpoint,
    ChecksGetSuiteRequestOptions
  ];
  "GET /repos/:owner/:repo/check-suites/:check_suite_id/check-runs": [
    ChecksListForSuiteEndpoint,
    ChecksListForSuiteRequestOptions
  ];
  "GET /repos/:owner/:repo/collaborators": [
    ReposListCollaboratorsEndpoint,
    ReposListCollaboratorsRequestOptions
  ];
  "GET /repos/:owner/:repo/collaborators/:username": [
    ReposCheckCollaboratorEndpoint,
    ReposCheckCollaboratorRequestOptions
  ];
  "GET /repos/:owner/:repo/collaborators/:username/permission": [
    ReposGetCollaboratorPermissionLevelEndpoint,
    ReposGetCollaboratorPermissionLevelRequestOptions
  ];
  "GET /repos/:owner/:repo/comments": [
    ReposListCommitCommentsEndpoint,
    ReposListCommitCommentsRequestOptions
  ];
  "GET /repos/:owner/:repo/comments/:comment_id": [
    ReposGetCommitCommentEndpoint,
    ReposGetCommitCommentRequestOptions
  ];
  "GET /repos/:owner/:repo/comments/:comment_id/reactions": [
    ReactionsListForCommitCommentEndpoint,
    ReactionsListForCommitCommentRequestOptions
  ];
  "GET /repos/:owner/:repo/commits": [
    ReposListCommitsEndpoint,
    ReposListCommitsRequestOptions
  ];
  "GET /repos/:owner/:repo/commits/:commit_sha/branches-where-head": [
    ReposListBranchesForHeadCommitEndpoint,
    ReposListBranchesForHeadCommitRequestOptions
  ];
  "GET /repos/:owner/:repo/commits/:commit_sha/comments": [
    ReposListCommentsForCommitEndpoint,
    ReposListCommentsForCommitRequestOptions
  ];
  "GET /repos/:owner/:repo/commits/:commit_sha/pulls": [
    ReposListPullRequestsAssociatedWithCommitEndpoint,
    ReposListPullRequestsAssociatedWithCommitRequestOptions
  ];
  "GET /repos/:owner/:repo/commits/:ref": [
    ReposGetCommitEndpoint,
    ReposGetCommitRequestOptions
  ];
  "GET /repos/:owner/:repo/commits/:ref/check-runs": [
    ChecksListForRefEndpoint,
    ChecksListForRefRequestOptions
  ];
  "GET /repos/:owner/:repo/commits/:ref/check-suites": [
    ChecksListSuitesForRefEndpoint,
    ChecksListSuitesForRefRequestOptions
  ];
  "GET /repos/:owner/:repo/commits/:ref/status": [
    ReposGetCombinedStatusForRefEndpoint,
    ReposGetCombinedStatusForRefRequestOptions
  ];
  "GET /repos/:owner/:repo/commits/:ref/statuses": [
    ReposListStatusesForRefEndpoint,
    ReposListStatusesForRefRequestOptions
  ];
  "GET /repos/:owner/:repo/community/code_of_conduct": [
    CodesOfConductGetForRepoEndpoint,
    CodesOfConductGetForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/community/profile": [
    ReposRetrieveCommunityProfileMetricsEndpoint,
    ReposRetrieveCommunityProfileMetricsRequestOptions
  ];
  "GET /repos/:owner/:repo/compare/:base...:head": [
    ReposCompareCommitsEndpoint,
    ReposCompareCommitsRequestOptions
  ];
  "GET /repos/:owner/:repo/contents/:path": [
    ReposGetContentsEndpoint,
    ReposGetContentsRequestOptions
  ];
  "GET /repos/:owner/:repo/contributors": [
    ReposListContributorsEndpoint,
    ReposListContributorsRequestOptions
  ];
  "GET /repos/:owner/:repo/deployments": [
    ReposListDeploymentsEndpoint,
    ReposListDeploymentsRequestOptions
  ];
  "GET /repos/:owner/:repo/deployments/:deployment_id": [
    ReposGetDeploymentEndpoint,
    ReposGetDeploymentRequestOptions
  ];
  "GET /repos/:owner/:repo/deployments/:deployment_id/statuses": [
    ReposListDeploymentStatusesEndpoint,
    ReposListDeploymentStatusesRequestOptions
  ];
  "GET /repos/:owner/:repo/deployments/:deployment_id/statuses/:status_id": [
    ReposGetDeploymentStatusEndpoint,
    ReposGetDeploymentStatusRequestOptions
  ];
  "GET /repos/:owner/:repo/downloads": [
    ReposListDownloadsEndpoint,
    ReposListDownloadsRequestOptions
  ];
  "GET /repos/:owner/:repo/downloads/:download_id": [
    ReposGetDownloadEndpoint,
    ReposGetDownloadRequestOptions
  ];
  "GET /repos/:owner/:repo/events": [
    ActivityListRepoEventsEndpoint,
    ActivityListRepoEventsRequestOptions
  ];
  "GET /repos/:owner/:repo/forks": [
    ReposListForksEndpoint,
    ReposListForksRequestOptions
  ];
  "GET /repos/:owner/:repo/git/blobs/:file_sha": [
    GitGetBlobEndpoint,
    GitGetBlobRequestOptions
  ];
  "GET /repos/:owner/:repo/git/commits/:commit_sha": [
    GitGetCommitEndpoint,
    GitGetCommitRequestOptions
  ];
  "GET /repos/:owner/:repo/git/matching-refs/:ref": [
    GitListMatchingRefsEndpoint,
    GitListMatchingRefsRequestOptions
  ];
  "GET /repos/:owner/:repo/git/ref/:ref": [
    GitGetRefEndpoint,
    GitGetRefRequestOptions
  ];
  "GET /repos/:owner/:repo/git/tags/:tag_sha": [
    GitGetTagEndpoint,
    GitGetTagRequestOptions
  ];
  "GET /repos/:owner/:repo/git/trees/:tree_sha": [
    GitGetTreeEndpoint,
    GitGetTreeRequestOptions
  ];
  "GET /repos/:owner/:repo/hooks": [
    ReposListHooksEndpoint,
    ReposListHooksRequestOptions
  ];
  "GET /repos/:owner/:repo/hooks/:hook_id": [
    ReposGetHookEndpoint,
    ReposGetHookRequestOptions
  ];
  "GET /repos/:owner/:repo/import": [
    MigrationsGetImportProgressEndpoint,
    MigrationsGetImportProgressRequestOptions
  ];
  "GET /repos/:owner/:repo/import/authors": [
    MigrationsGetCommitAuthorsEndpoint,
    MigrationsGetCommitAuthorsRequestOptions
  ];
  "GET /repos/:owner/:repo/import/large_files": [
    MigrationsGetLargeFilesEndpoint,
    MigrationsGetLargeFilesRequestOptions
  ];
  "GET /repos/:owner/:repo/installation": [
    AppsGetRepoInstallationEndpoint | AppsFindRepoInstallationEndpoint,

      | AppsGetRepoInstallationRequestOptions
      | AppsFindRepoInstallationRequestOptions
  ];
  "GET /repos/:owner/:repo/interaction-limits": [
    InteractionsGetRestrictionsForRepoEndpoint,
    InteractionsGetRestrictionsForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/invitations": [
    ReposListInvitationsEndpoint,
    ReposListInvitationsRequestOptions
  ];
  "GET /repos/:owner/:repo/issues": [
    IssuesListForRepoEndpoint,
    IssuesListForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/:issue_number": [
    IssuesGetEndpoint,
    IssuesGetRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/:issue_number/comments": [
    IssuesListCommentsEndpoint,
    IssuesListCommentsRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/:issue_number/events": [
    IssuesListEventsEndpoint,
    IssuesListEventsRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/:issue_number/labels": [
    IssuesListLabelsOnIssueEndpoint,
    IssuesListLabelsOnIssueRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/:issue_number/reactions": [
    ReactionsListForIssueEndpoint,
    ReactionsListForIssueRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/:issue_number/timeline": [
    IssuesListEventsForTimelineEndpoint,
    IssuesListEventsForTimelineRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/comments": [
    IssuesListCommentsForRepoEndpoint,
    IssuesListCommentsForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/comments/:comment_id": [
    IssuesGetCommentEndpoint,
    IssuesGetCommentRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/comments/:comment_id/reactions": [
    ReactionsListForIssueCommentEndpoint,
    ReactionsListForIssueCommentRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/events": [
    IssuesListEventsForRepoEndpoint,
    IssuesListEventsForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/issues/events/:event_id": [
    IssuesGetEventEndpoint,
    IssuesGetEventRequestOptions
  ];
  "GET /repos/:owner/:repo/keys": [
    ReposListDeployKeysEndpoint,
    ReposListDeployKeysRequestOptions
  ];
  "GET /repos/:owner/:repo/keys/:key_id": [
    ReposGetDeployKeyEndpoint,
    ReposGetDeployKeyRequestOptions
  ];
  "GET /repos/:owner/:repo/labels": [
    IssuesListLabelsForRepoEndpoint,
    IssuesListLabelsForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/labels/:name": [
    IssuesGetLabelEndpoint,
    IssuesGetLabelRequestOptions
  ];
  "GET /repos/:owner/:repo/languages": [
    ReposListLanguagesEndpoint,
    ReposListLanguagesRequestOptions
  ];
  "GET /repos/:owner/:repo/license": [
    LicensesGetForRepoEndpoint,
    LicensesGetForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/milestones": [
    IssuesListMilestonesForRepoEndpoint,
    IssuesListMilestonesForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/milestones/:milestone_number": [
    IssuesGetMilestoneEndpoint,
    IssuesGetMilestoneRequestOptions
  ];
  "GET /repos/:owner/:repo/milestones/:milestone_number/labels": [
    IssuesListLabelsForMilestoneEndpoint,
    IssuesListLabelsForMilestoneRequestOptions
  ];
  "GET /repos/:owner/:repo/notifications": [
    ActivityListNotificationsForRepoEndpoint,
    ActivityListNotificationsForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/pages": [
    ReposGetPagesEndpoint,
    ReposGetPagesRequestOptions
  ];
  "GET /repos/:owner/:repo/pages/builds": [
    ReposListPagesBuildsEndpoint,
    ReposListPagesBuildsRequestOptions
  ];
  "GET /repos/:owner/:repo/pages/builds/:build_id": [
    ReposGetPagesBuildEndpoint,
    ReposGetPagesBuildRequestOptions
  ];
  "GET /repos/:owner/:repo/pages/builds/latest": [
    ReposGetLatestPagesBuildEndpoint,
    ReposGetLatestPagesBuildRequestOptions
  ];
  "GET /repos/:owner/:repo/projects": [
    ProjectsListForRepoEndpoint,
    ProjectsListForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls": [PullsListEndpoint, PullsListRequestOptions];
  "GET /repos/:owner/:repo/pulls/:pull_number": [
    PullsGetEndpoint,
    PullsGetRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/:pull_number/comments": [
    PullsListCommentsEndpoint,
    PullsListCommentsRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/:pull_number/commits": [
    PullsListCommitsEndpoint,
    PullsListCommitsRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/:pull_number/files": [
    PullsListFilesEndpoint,
    PullsListFilesRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/:pull_number/merge": [
    PullsCheckIfMergedEndpoint,
    PullsCheckIfMergedRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": [
    PullsListReviewRequestsEndpoint,
    PullsListReviewRequestsRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/:pull_number/reviews": [
    PullsListReviewsEndpoint,
    PullsListReviewsRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": [
    PullsGetReviewEndpoint,
    PullsGetReviewRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/comments": [
    PullsGetCommentsForReviewEndpoint,
    PullsGetCommentsForReviewRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/comments": [
    PullsListCommentsForRepoEndpoint,
    PullsListCommentsForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/comments/:comment_id": [
    PullsGetCommentEndpoint,
    PullsGetCommentRequestOptions
  ];
  "GET /repos/:owner/:repo/pulls/comments/:comment_id/reactions": [
    ReactionsListForPullRequestReviewCommentEndpoint,
    ReactionsListForPullRequestReviewCommentRequestOptions
  ];
  "GET /repos/:owner/:repo/readme": [
    ReposGetReadmeEndpoint,
    ReposGetReadmeRequestOptions
  ];
  "GET /repos/:owner/:repo/releases": [
    ReposListReleasesEndpoint,
    ReposListReleasesRequestOptions
  ];
  "GET /repos/:owner/:repo/releases/:release_id": [
    ReposGetReleaseEndpoint,
    ReposGetReleaseRequestOptions
  ];
  "GET /repos/:owner/:repo/releases/:release_id/assets": [
    ReposListAssetsForReleaseEndpoint,
    ReposListAssetsForReleaseRequestOptions
  ];
  "GET /repos/:owner/:repo/releases/assets/:asset_id": [
    ReposGetReleaseAssetEndpoint,
    ReposGetReleaseAssetRequestOptions
  ];
  "GET /repos/:owner/:repo/releases/latest": [
    ReposGetLatestReleaseEndpoint,
    ReposGetLatestReleaseRequestOptions
  ];
  "GET /repos/:owner/:repo/releases/tags/:tag": [
    ReposGetReleaseByTagEndpoint,
    ReposGetReleaseByTagRequestOptions
  ];
  "GET /repos/:owner/:repo/stargazers": [
    ActivityListStargazersForRepoEndpoint,
    ActivityListStargazersForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/stats/code_frequency": [
    ReposGetCodeFrequencyStatsEndpoint,
    ReposGetCodeFrequencyStatsRequestOptions
  ];
  "GET /repos/:owner/:repo/stats/commit_activity": [
    ReposGetCommitActivityStatsEndpoint,
    ReposGetCommitActivityStatsRequestOptions
  ];
  "GET /repos/:owner/:repo/stats/contributors": [
    ReposGetContributorsStatsEndpoint,
    ReposGetContributorsStatsRequestOptions
  ];
  "GET /repos/:owner/:repo/stats/participation": [
    ReposGetParticipationStatsEndpoint,
    ReposGetParticipationStatsRequestOptions
  ];
  "GET /repos/:owner/:repo/stats/punch_card": [
    ReposGetPunchCardStatsEndpoint,
    ReposGetPunchCardStatsRequestOptions
  ];
  "GET /repos/:owner/:repo/subscribers": [
    ActivityListWatchersForRepoEndpoint,
    ActivityListWatchersForRepoRequestOptions
  ];
  "GET /repos/:owner/:repo/subscription": [
    ActivityGetRepoSubscriptionEndpoint,
    ActivityGetRepoSubscriptionRequestOptions
  ];
  "GET /repos/:owner/:repo/tags": [
    ReposListTagsEndpoint,
    ReposListTagsRequestOptions
  ];
  "GET /repos/:owner/:repo/teams": [
    ReposListTeamsEndpoint,
    ReposListTeamsRequestOptions
  ];
  "GET /repos/:owner/:repo/topics": [
    ReposListTopicsEndpoint,
    ReposListTopicsRequestOptions
  ];
  "GET /repos/:owner/:repo/traffic/clones": [
    ReposGetClonesEndpoint,
    ReposGetClonesRequestOptions
  ];
  "GET /repos/:owner/:repo/traffic/popular/paths": [
    ReposGetTopPathsEndpoint,
    ReposGetTopPathsRequestOptions
  ];
  "GET /repos/:owner/:repo/traffic/popular/referrers": [
    ReposGetTopReferrersEndpoint,
    ReposGetTopReferrersRequestOptions
  ];
  "GET /repos/:owner/:repo/traffic/views": [
    ReposGetViewsEndpoint,
    ReposGetViewsRequestOptions
  ];
  "GET /repos/:owner/:repo/vulnerability-alerts": [
    ReposCheckVulnerabilityAlertsEndpoint,
    ReposCheckVulnerabilityAlertsRequestOptions
  ];
  "GET /repositories": [ReposListPublicEndpoint, ReposListPublicRequestOptions];
  "GET /scim/v2/organizations/:org/Users": [
    ScimListProvisionedIdentitiesEndpoint,
    ScimListProvisionedIdentitiesRequestOptions
  ];
  "GET /scim/v2/organizations/:org/Users/:scim_user_id": [
    ScimGetProvisioningDetailsForUserEndpoint,
    ScimGetProvisioningDetailsForUserRequestOptions
  ];
  "GET /search/code": [SearchCodeEndpoint, SearchCodeRequestOptions];
  "GET /search/commits": [SearchCommitsEndpoint, SearchCommitsRequestOptions];
  "GET /search/issues": [
    SearchIssuesAndPullRequestsEndpoint | SearchIssuesEndpoint,
    SearchIssuesAndPullRequestsRequestOptions | SearchIssuesRequestOptions
  ];
  "GET /search/labels": [SearchLabelsEndpoint, SearchLabelsRequestOptions];
  "GET /search/repositories": [SearchReposEndpoint, SearchReposRequestOptions];
  "GET /search/topics": [SearchTopicsEndpoint, SearchTopicsRequestOptions];
  "GET /search/users": [SearchUsersEndpoint, SearchUsersRequestOptions];
  "GET /teams/:team_id": [
    TeamsGetLegacyEndpoint | TeamsGetEndpoint,
    TeamsGetLegacyRequestOptions | TeamsGetRequestOptions
  ];
  "GET /teams/:team_id/discussions": [
    TeamsListDiscussionsLegacyEndpoint | TeamsListDiscussionsEndpoint,

      | TeamsListDiscussionsLegacyRequestOptions
      | TeamsListDiscussionsRequestOptions
  ];
  "GET /teams/:team_id/discussions/:discussion_number": [
    TeamsGetDiscussionLegacyEndpoint | TeamsGetDiscussionEndpoint,
    TeamsGetDiscussionLegacyRequestOptions | TeamsGetDiscussionRequestOptions
  ];
  "GET /teams/:team_id/discussions/:discussion_number/comments": [

      | TeamsListDiscussionCommentsLegacyEndpoint
      | TeamsListDiscussionCommentsEndpoint,

      | TeamsListDiscussionCommentsLegacyRequestOptions
      | TeamsListDiscussionCommentsRequestOptions
  ];
  "GET /teams/:team_id/discussions/:discussion_number/comments/:comment_number": [
    TeamsGetDiscussionCommentLegacyEndpoint | TeamsGetDiscussionCommentEndpoint,

      | TeamsGetDiscussionCommentLegacyRequestOptions
      | TeamsGetDiscussionCommentRequestOptions
  ];
  "GET /teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions": [

      | ReactionsListForTeamDiscussionCommentLegacyEndpoint
      | ReactionsListForTeamDiscussionCommentEndpoint,

      | ReactionsListForTeamDiscussionCommentLegacyRequestOptions
      | ReactionsListForTeamDiscussionCommentRequestOptions
  ];
  "GET /teams/:team_id/discussions/:discussion_number/reactions": [

      | ReactionsListForTeamDiscussionLegacyEndpoint
      | ReactionsListForTeamDiscussionEndpoint,

      | ReactionsListForTeamDiscussionLegacyRequestOptions
      | ReactionsListForTeamDiscussionRequestOptions
  ];
  "GET /teams/:team_id/invitations": [

      | TeamsListPendingInvitationsLegacyEndpoint
      | TeamsListPendingInvitationsEndpoint,

      | TeamsListPendingInvitationsLegacyRequestOptions
      | TeamsListPendingInvitationsRequestOptions
  ];
  "GET /teams/:team_id/members": [
    TeamsListMembersLegacyEndpoint | TeamsListMembersEndpoint,
    TeamsListMembersLegacyRequestOptions | TeamsListMembersRequestOptions
  ];
  "GET /teams/:team_id/members/:username": [
    TeamsGetMemberLegacyEndpoint | TeamsGetMemberEndpoint,
    TeamsGetMemberLegacyRequestOptions | TeamsGetMemberRequestOptions
  ];
  "GET /teams/:team_id/memberships/:username": [
    TeamsGetMembershipLegacyEndpoint | TeamsGetMembershipEndpoint,
    TeamsGetMembershipLegacyRequestOptions | TeamsGetMembershipRequestOptions
  ];
  "GET /teams/:team_id/projects": [
    TeamsListProjectsLegacyEndpoint | TeamsListProjectsEndpoint,
    TeamsListProjectsLegacyRequestOptions | TeamsListProjectsRequestOptions
  ];
  "GET /teams/:team_id/projects/:project_id": [
    TeamsReviewProjectLegacyEndpoint | TeamsReviewProjectEndpoint,
    TeamsReviewProjectLegacyRequestOptions | TeamsReviewProjectRequestOptions
  ];
  "GET /teams/:team_id/repos": [
    TeamsListReposLegacyEndpoint | TeamsListReposEndpoint,
    TeamsListReposLegacyRequestOptions | TeamsListReposRequestOptions
  ];
  "GET /teams/:team_id/repos/:owner/:repo": [
    TeamsCheckManagesRepoLegacyEndpoint | TeamsCheckManagesRepoEndpoint,

      | TeamsCheckManagesRepoLegacyRequestOptions
      | TeamsCheckManagesRepoRequestOptions
  ];
  "GET /teams/:team_id/team-sync/group-mappings": [
    TeamsListIdPGroupsForLegacyEndpoint | TeamsListIdPGroupsForEndpoint,

      | TeamsListIdPGroupsForLegacyRequestOptions
      | TeamsListIdPGroupsForRequestOptions
  ];
  "GET /teams/:team_id/teams": [
    TeamsListChildLegacyEndpoint | TeamsListChildEndpoint,
    TeamsListChildLegacyRequestOptions | TeamsListChildRequestOptions
  ];
  "GET /user": [
    UsersGetAuthenticatedEndpoint,
    UsersGetAuthenticatedRequestOptions
  ];
  "GET /user/:migration_id/repositories": [
    MigrationsListReposForUserEndpoint,
    MigrationsListReposForUserRequestOptions
  ];
  "GET /user/blocks": [
    UsersListBlockedEndpoint,
    UsersListBlockedRequestOptions
  ];
  "GET /user/blocks/:username": [
    UsersCheckBlockedEndpoint,
    UsersCheckBlockedRequestOptions
  ];
  "GET /user/emails": [UsersListEmailsEndpoint, UsersListEmailsRequestOptions];
  "GET /user/followers": [
    UsersListFollowersForAuthenticatedUserEndpoint,
    UsersListFollowersForAuthenticatedUserRequestOptions
  ];
  "GET /user/following": [
    UsersListFollowingForAuthenticatedUserEndpoint,
    UsersListFollowingForAuthenticatedUserRequestOptions
  ];
  "GET /user/following/:username": [
    UsersCheckFollowingEndpoint,
    UsersCheckFollowingRequestOptions
  ];
  "GET /user/gpg_keys": [
    UsersListGpgKeysEndpoint,
    UsersListGpgKeysRequestOptions
  ];
  "GET /user/gpg_keys/:gpg_key_id": [
    UsersGetGpgKeyEndpoint,
    UsersGetGpgKeyRequestOptions
  ];
  "GET /user/installations": [
    AppsListInstallationsForAuthenticatedUserEndpoint,
    AppsListInstallationsForAuthenticatedUserRequestOptions
  ];
  "GET /user/installations/:installation_id/repositories": [
    AppsListInstallationReposForAuthenticatedUserEndpoint,
    AppsListInstallationReposForAuthenticatedUserRequestOptions
  ];
  "GET /user/issues": [
    IssuesListForAuthenticatedUserEndpoint,
    IssuesListForAuthenticatedUserRequestOptions
  ];
  "GET /user/keys": [
    UsersListPublicKeysEndpoint,
    UsersListPublicKeysRequestOptions
  ];
  "GET /user/keys/:key_id": [
    UsersGetPublicKeyEndpoint,
    UsersGetPublicKeyRequestOptions
  ];
  "GET /user/marketplace_purchases": [
    AppsListMarketplacePurchasesForAuthenticatedUserEndpoint,
    AppsListMarketplacePurchasesForAuthenticatedUserRequestOptions
  ];
  "GET /user/marketplace_purchases/stubbed": [
    AppsListMarketplacePurchasesForAuthenticatedUserStubbedEndpoint,
    AppsListMarketplacePurchasesForAuthenticatedUserStubbedRequestOptions
  ];
  "GET /user/memberships/orgs": [
    OrgsListMembershipsEndpoint,
    OrgsListMembershipsRequestOptions
  ];
  "GET /user/memberships/orgs/:org": [
    OrgsGetMembershipForAuthenticatedUserEndpoint,
    OrgsGetMembershipForAuthenticatedUserRequestOptions
  ];
  "GET /user/migrations": [
    MigrationsListForAuthenticatedUserEndpoint,
    MigrationsListForAuthenticatedUserRequestOptions
  ];
  "GET /user/migrations/:migration_id": [
    MigrationsGetStatusForAuthenticatedUserEndpoint,
    MigrationsGetStatusForAuthenticatedUserRequestOptions
  ];
  "GET /user/migrations/:migration_id/archive": [
    MigrationsGetArchiveForAuthenticatedUserEndpoint,
    MigrationsGetArchiveForAuthenticatedUserRequestOptions
  ];
  "GET /user/orgs": [
    OrgsListForAuthenticatedUserEndpoint,
    OrgsListForAuthenticatedUserRequestOptions
  ];
  "GET /user/public_emails": [
    UsersListPublicEmailsEndpoint,
    UsersListPublicEmailsRequestOptions
  ];
  "GET /user/repos": [ReposListEndpoint, ReposListRequestOptions];
  "GET /user/repository_invitations": [
    ReposListInvitationsForAuthenticatedUserEndpoint,
    ReposListInvitationsForAuthenticatedUserRequestOptions
  ];
  "GET /user/starred": [
    ActivityListReposStarredByAuthenticatedUserEndpoint,
    ActivityListReposStarredByAuthenticatedUserRequestOptions
  ];
  "GET /user/starred/:owner/:repo": [
    ActivityCheckStarringRepoEndpoint,
    ActivityCheckStarringRepoRequestOptions
  ];
  "GET /user/subscriptions": [
    ActivityListWatchedReposForAuthenticatedUserEndpoint,
    ActivityListWatchedReposForAuthenticatedUserRequestOptions
  ];
  "GET /user/subscriptions/:owner/:repo": [
    ActivityCheckWatchingRepoLegacyEndpoint,
    ActivityCheckWatchingRepoLegacyRequestOptions
  ];
  "GET /user/teams": [
    TeamsListForAuthenticatedUserEndpoint,
    TeamsListForAuthenticatedUserRequestOptions
  ];
  "GET /users": [UsersListEndpoint, UsersListRequestOptions];
  "GET /users/:username": [
    UsersGetByUsernameEndpoint,
    UsersGetByUsernameRequestOptions
  ];
  "GET /users/:username/events": [
    ActivityListEventsForUserEndpoint,
    ActivityListEventsForUserRequestOptions
  ];
  "GET /users/:username/events/orgs/:org": [
    ActivityListEventsForOrgEndpoint,
    ActivityListEventsForOrgRequestOptions
  ];
  "GET /users/:username/events/public": [
    ActivityListPublicEventsForUserEndpoint,
    ActivityListPublicEventsForUserRequestOptions
  ];
  "GET /users/:username/followers": [
    UsersListFollowersForUserEndpoint,
    UsersListFollowersForUserRequestOptions
  ];
  "GET /users/:username/following": [
    UsersListFollowingForUserEndpoint,
    UsersListFollowingForUserRequestOptions
  ];
  "GET /users/:username/following/:target_user": [
    UsersCheckFollowingForUserEndpoint,
    UsersCheckFollowingForUserRequestOptions
  ];
  "GET /users/:username/gists": [
    GistsListPublicForUserEndpoint,
    GistsListPublicForUserRequestOptions
  ];
  "GET /users/:username/gpg_keys": [
    UsersListGpgKeysForUserEndpoint,
    UsersListGpgKeysForUserRequestOptions
  ];
  "GET /users/:username/hovercard": [
    UsersGetContextForUserEndpoint,
    UsersGetContextForUserRequestOptions
  ];
  "GET /users/:username/installation": [
    AppsGetUserInstallationEndpoint | AppsFindUserInstallationEndpoint,

      | AppsGetUserInstallationRequestOptions
      | AppsFindUserInstallationRequestOptions
  ];
  "GET /users/:username/keys": [
    UsersListPublicKeysForUserEndpoint,
    UsersListPublicKeysForUserRequestOptions
  ];
  "GET /users/:username/orgs": [
    OrgsListForUserEndpoint,
    OrgsListForUserRequestOptions
  ];
  "GET /users/:username/projects": [
    ProjectsListForUserEndpoint,
    ProjectsListForUserRequestOptions
  ];
  "GET /users/:username/received_events": [
    ActivityListReceivedEventsForUserEndpoint,
    ActivityListReceivedEventsForUserRequestOptions
  ];
  "GET /users/:username/received_events/public": [
    ActivityListReceivedPublicEventsForUserEndpoint,
    ActivityListReceivedPublicEventsForUserRequestOptions
  ];
  "GET /users/:username/repos": [
    ReposListForUserEndpoint,
    ReposListForUserRequestOptions
  ];
  "GET /users/:username/starred": [
    ActivityListReposStarredByUserEndpoint,
    ActivityListReposStarredByUserRequestOptions
  ];
  "GET /users/:username/subscriptions": [
    ActivityListReposWatchedByUserEndpoint,
    ActivityListReposWatchedByUserRequestOptions
  ];
  "PATCH /applications/:client_id/token": [
    AppsResetTokenEndpoint,
    AppsResetTokenRequestOptions
  ];
  "PATCH /authorizations/:authorization_id": [
    OauthAuthorizationsUpdateAuthorizationEndpoint,
    OauthAuthorizationsUpdateAuthorizationRequestOptions
  ];
  "PATCH /gists/:gist_id": [GistsUpdateEndpoint, GistsUpdateRequestOptions];
  "PATCH /gists/:gist_id/comments/:comment_id": [
    GistsUpdateCommentEndpoint,
    GistsUpdateCommentRequestOptions
  ];
  "PATCH /notifications/threads/:thread_id": [
    ActivityMarkThreadAsReadEndpoint,
    ActivityMarkThreadAsReadRequestOptions
  ];
  "PATCH /orgs/:org": [OrgsUpdateEndpoint, OrgsUpdateRequestOptions];
  "PATCH /orgs/:org/hooks/:hook_id": [
    OrgsUpdateHookEndpoint,
    OrgsUpdateHookRequestOptions
  ];
  "PATCH /orgs/:org/teams/:team_slug": [
    TeamsUpdateInOrgEndpoint,
    TeamsUpdateInOrgRequestOptions
  ];
  "PATCH /orgs/:org/teams/:team_slug/discussions/:discussion_number": [
    TeamsUpdateDiscussionInOrgEndpoint,
    TeamsUpdateDiscussionInOrgRequestOptions
  ];
  "PATCH /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": [
    TeamsUpdateDiscussionCommentInOrgEndpoint,
    TeamsUpdateDiscussionCommentInOrgRequestOptions
  ];
  "PATCH /orgs/:org/teams/:team_slug/team-sync/group-mappings": [
    TeamsCreateOrUpdateIdPGroupConnectionsInOrgEndpoint,
    TeamsCreateOrUpdateIdPGroupConnectionsInOrgRequestOptions
  ];
  "PATCH /projects/:project_id": [
    ProjectsUpdateEndpoint,
    ProjectsUpdateRequestOptions
  ];
  "PATCH /projects/columns/:column_id": [
    ProjectsUpdateColumnEndpoint,
    ProjectsUpdateColumnRequestOptions
  ];
  "PATCH /projects/columns/cards/:card_id": [
    ProjectsUpdateCardEndpoint,
    ProjectsUpdateCardRequestOptions
  ];
  "PATCH /repos/:owner/:repo": [ReposUpdateEndpoint, ReposUpdateRequestOptions];
  "PATCH /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": [
    ReposUpdateProtectedBranchPullRequestReviewEnforcementEndpoint,
    ReposUpdateProtectedBranchPullRequestReviewEnforcementRequestOptions
  ];
  "PATCH /repos/:owner/:repo/branches/:branch/protection/required_status_checks": [
    ReposUpdateProtectedBranchRequiredStatusChecksEndpoint,
    ReposUpdateProtectedBranchRequiredStatusChecksRequestOptions
  ];
  "PATCH /repos/:owner/:repo/check-runs/:check_run_id": [
    ChecksUpdateEndpoint,
    ChecksUpdateRequestOptions
  ];
  "PATCH /repos/:owner/:repo/check-suites/preferences": [
    ChecksSetSuitesPreferencesEndpoint,
    ChecksSetSuitesPreferencesRequestOptions
  ];
  "PATCH /repos/:owner/:repo/comments/:comment_id": [
    ReposUpdateCommitCommentEndpoint,
    ReposUpdateCommitCommentRequestOptions
  ];
  "PATCH /repos/:owner/:repo/git/refs/:ref": [
    GitUpdateRefEndpoint,
    GitUpdateRefRequestOptions
  ];
  "PATCH /repos/:owner/:repo/hooks/:hook_id": [
    ReposUpdateHookEndpoint,
    ReposUpdateHookRequestOptions
  ];
  "PATCH /repos/:owner/:repo/import": [
    MigrationsUpdateImportEndpoint,
    MigrationsUpdateImportRequestOptions
  ];
  "PATCH /repos/:owner/:repo/import/authors/:author_id": [
    MigrationsMapCommitAuthorEndpoint,
    MigrationsMapCommitAuthorRequestOptions
  ];
  "PATCH /repos/:owner/:repo/import/lfs": [
    MigrationsSetLfsPreferenceEndpoint,
    MigrationsSetLfsPreferenceRequestOptions
  ];
  "PATCH /repos/:owner/:repo/invitations/:invitation_id": [
    ReposUpdateInvitationEndpoint,
    ReposUpdateInvitationRequestOptions
  ];
  "PATCH /repos/:owner/:repo/issues/:issue_number": [
    IssuesUpdateEndpoint,
    IssuesUpdateRequestOptions
  ];
  "PATCH /repos/:owner/:repo/issues/comments/:comment_id": [
    IssuesUpdateCommentEndpoint,
    IssuesUpdateCommentRequestOptions
  ];
  "PATCH /repos/:owner/:repo/labels/:name": [
    IssuesUpdateLabelEndpoint,
    IssuesUpdateLabelRequestOptions
  ];
  "PATCH /repos/:owner/:repo/milestones/:milestone_number": [
    IssuesUpdateMilestoneEndpoint,
    IssuesUpdateMilestoneRequestOptions
  ];
  "PATCH /repos/:owner/:repo/pulls/:pull_number": [
    PullsUpdateEndpoint,
    PullsUpdateRequestOptions
  ];
  "PATCH /repos/:owner/:repo/pulls/comments/:comment_id": [
    PullsUpdateCommentEndpoint,
    PullsUpdateCommentRequestOptions
  ];
  "PATCH /repos/:owner/:repo/releases/:release_id": [
    ReposUpdateReleaseEndpoint,
    ReposUpdateReleaseRequestOptions
  ];
  "PATCH /repos/:owner/:repo/releases/assets/:asset_id": [
    ReposUpdateReleaseAssetEndpoint,
    ReposUpdateReleaseAssetRequestOptions
  ];
  "PATCH /scim/v2/organizations/:org/Users/:scim_user_id": [
    ScimUpdateUserAttributeEndpoint,
    ScimUpdateUserAttributeRequestOptions
  ];
  "PATCH /teams/:team_id": [
    TeamsUpdateLegacyEndpoint | TeamsUpdateEndpoint,
    TeamsUpdateLegacyRequestOptions | TeamsUpdateRequestOptions
  ];
  "PATCH /teams/:team_id/discussions/:discussion_number": [
    TeamsUpdateDiscussionLegacyEndpoint | TeamsUpdateDiscussionEndpoint,

      | TeamsUpdateDiscussionLegacyRequestOptions
      | TeamsUpdateDiscussionRequestOptions
  ];
  "PATCH /teams/:team_id/discussions/:discussion_number/comments/:comment_number": [

      | TeamsUpdateDiscussionCommentLegacyEndpoint
      | TeamsUpdateDiscussionCommentEndpoint,

      | TeamsUpdateDiscussionCommentLegacyRequestOptions
      | TeamsUpdateDiscussionCommentRequestOptions
  ];
  "PATCH /teams/:team_id/team-sync/group-mappings": [

      | TeamsCreateOrUpdateIdPGroupConnectionsLegacyEndpoint
      | TeamsCreateOrUpdateIdPGroupConnectionsEndpoint,

      | TeamsCreateOrUpdateIdPGroupConnectionsLegacyRequestOptions
      | TeamsCreateOrUpdateIdPGroupConnectionsRequestOptions
  ];
  "PATCH /user": [
    UsersUpdateAuthenticatedEndpoint,
    UsersUpdateAuthenticatedRequestOptions
  ];
  "PATCH /user/email/visibility": [
    UsersTogglePrimaryEmailVisibilityEndpoint,
    UsersTogglePrimaryEmailVisibilityRequestOptions
  ];
  "PATCH /user/memberships/orgs/:org": [
    OrgsUpdateMembershipEndpoint,
    OrgsUpdateMembershipRequestOptions
  ];
  "PATCH /user/repository_invitations/:invitation_id": [
    ReposAcceptInvitationEndpoint,
    ReposAcceptInvitationRequestOptions
  ];
  "POST /app-manifests/:code/conversions": [
    AppsCreateFromManifestEndpoint,
    AppsCreateFromManifestRequestOptions
  ];
  "POST /app/installations/:installation_id/access_tokens": [
    AppsCreateInstallationTokenEndpoint,
    AppsCreateInstallationTokenRequestOptions
  ];
  "POST /applications/:client_id/token": [
    AppsCheckTokenEndpoint,
    AppsCheckTokenRequestOptions
  ];
  "POST /applications/:client_id/tokens/:access_token": [

      | AppsResetAuthorizationEndpoint
      | OauthAuthorizationsResetAuthorizationEndpoint,

      | AppsResetAuthorizationRequestOptions
      | OauthAuthorizationsResetAuthorizationRequestOptions
  ];
  "POST /authorizations": [
    OauthAuthorizationsCreateAuthorizationEndpoint,
    OauthAuthorizationsCreateAuthorizationRequestOptions
  ];
  "POST /content_references/:content_reference_id/attachments": [
    AppsCreateContentAttachmentEndpoint,
    AppsCreateContentAttachmentRequestOptions
  ];
  "POST /gists": [GistsCreateEndpoint, GistsCreateRequestOptions];
  "POST /gists/:gist_id/comments": [
    GistsCreateCommentEndpoint,
    GistsCreateCommentRequestOptions
  ];
  "POST /gists/:gist_id/forks": [GistsForkEndpoint, GistsForkRequestOptions];
  "POST /markdown": [MarkdownRenderEndpoint, MarkdownRenderRequestOptions];
  "POST /markdown/raw": [
    MarkdownRenderRawEndpoint,
    MarkdownRenderRawRequestOptions
  ];
  "POST /orgs/:org/hooks": [
    OrgsCreateHookEndpoint,
    OrgsCreateHookRequestOptions
  ];
  "POST /orgs/:org/hooks/:hook_id/pings": [
    OrgsPingHookEndpoint,
    OrgsPingHookRequestOptions
  ];
  "POST /orgs/:org/invitations": [
    OrgsCreateInvitationEndpoint,
    OrgsCreateInvitationRequestOptions
  ];
  "POST /orgs/:org/migrations": [
    MigrationsStartForOrgEndpoint,
    MigrationsStartForOrgRequestOptions
  ];
  "POST /orgs/:org/projects": [
    ProjectsCreateForOrgEndpoint,
    ProjectsCreateForOrgRequestOptions
  ];
  "POST /orgs/:org/repos": [
    ReposCreateInOrgEndpoint,
    ReposCreateInOrgRequestOptions
  ];
  "POST /orgs/:org/teams": [TeamsCreateEndpoint, TeamsCreateRequestOptions];
  "POST /orgs/:org/teams/:team_slug/discussions": [
    TeamsCreateDiscussionInOrgEndpoint,
    TeamsCreateDiscussionInOrgRequestOptions
  ];
  "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments": [
    TeamsCreateDiscussionCommentInOrgEndpoint,
    TeamsCreateDiscussionCommentInOrgRequestOptions
  ];
  "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions": [
    ReactionsCreateForTeamDiscussionCommentInOrgEndpoint,
    ReactionsCreateForTeamDiscussionCommentInOrgRequestOptions
  ];
  "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions": [
    ReactionsCreateForTeamDiscussionInOrgEndpoint,
    ReactionsCreateForTeamDiscussionInOrgRequestOptions
  ];
  "POST /projects/:project_id/columns": [
    ProjectsCreateColumnEndpoint,
    ProjectsCreateColumnRequestOptions
  ];
  "POST /projects/columns/:column_id/cards": [
    ProjectsCreateCardEndpoint,
    ProjectsCreateCardRequestOptions
  ];
  "POST /projects/columns/:column_id/moves": [
    ProjectsMoveColumnEndpoint,
    ProjectsMoveColumnRequestOptions
  ];
  "POST /projects/columns/cards/:card_id/moves": [
    ProjectsMoveCardEndpoint,
    ProjectsMoveCardRequestOptions
  ];
  "POST /repos/:owner/:repo/branches/:branch/protection/enforce_admins": [
    ReposAddProtectedBranchAdminEnforcementEndpoint,
    ReposAddProtectedBranchAdminEnforcementRequestOptions
  ];
  "POST /repos/:owner/:repo/branches/:branch/protection/required_signatures": [
    ReposAddProtectedBranchRequiredSignaturesEndpoint,
    ReposAddProtectedBranchRequiredSignaturesRequestOptions
  ];
  "POST /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": [
    ReposAddProtectedBranchRequiredStatusChecksContextsEndpoint,
    ReposAddProtectedBranchRequiredStatusChecksContextsRequestOptions
  ];
  "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": [
    ReposAddProtectedBranchAppRestrictionsEndpoint,
    ReposAddProtectedBranchAppRestrictionsRequestOptions
  ];
  "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": [
    ReposAddProtectedBranchTeamRestrictionsEndpoint,
    ReposAddProtectedBranchTeamRestrictionsRequestOptions
  ];
  "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/users": [
    ReposAddProtectedBranchUserRestrictionsEndpoint,
    ReposAddProtectedBranchUserRestrictionsRequestOptions
  ];
  "POST /repos/:owner/:repo/check-runs": [
    ChecksCreateEndpoint,
    ChecksCreateRequestOptions
  ];
  "POST /repos/:owner/:repo/check-suites": [
    ChecksCreateSuiteEndpoint,
    ChecksCreateSuiteRequestOptions
  ];
  "POST /repos/:owner/:repo/check-suites/:check_suite_id/rerequest": [
    ChecksRerequestSuiteEndpoint,
    ChecksRerequestSuiteRequestOptions
  ];
  "POST /repos/:owner/:repo/comments/:comment_id/reactions": [
    ReactionsCreateForCommitCommentEndpoint,
    ReactionsCreateForCommitCommentRequestOptions
  ];
  "POST /repos/:owner/:repo/commits/:commit_sha/comments": [
    ReposCreateCommitCommentEndpoint,
    ReposCreateCommitCommentRequestOptions
  ];
  "POST /repos/:owner/:repo/deployments": [
    ReposCreateDeploymentEndpoint,
    ReposCreateDeploymentRequestOptions
  ];
  "POST /repos/:owner/:repo/deployments/:deployment_id/statuses": [
    ReposCreateDeploymentStatusEndpoint,
    ReposCreateDeploymentStatusRequestOptions
  ];
  "POST /repos/:owner/:repo/dispatches": [
    ReposCreateDispatchEventEndpoint,
    ReposCreateDispatchEventRequestOptions
  ];
  "POST /repos/:owner/:repo/forks": [
    ReposCreateForkEndpoint,
    ReposCreateForkRequestOptions
  ];
  "POST /repos/:owner/:repo/git/blobs": [
    GitCreateBlobEndpoint,
    GitCreateBlobRequestOptions
  ];
  "POST /repos/:owner/:repo/git/commits": [
    GitCreateCommitEndpoint,
    GitCreateCommitRequestOptions
  ];
  "POST /repos/:owner/:repo/git/refs": [
    GitCreateRefEndpoint,
    GitCreateRefRequestOptions
  ];
  "POST /repos/:owner/:repo/git/tags": [
    GitCreateTagEndpoint,
    GitCreateTagRequestOptions
  ];
  "POST /repos/:owner/:repo/git/trees": [
    GitCreateTreeEndpoint,
    GitCreateTreeRequestOptions
  ];
  "POST /repos/:owner/:repo/hooks": [
    ReposCreateHookEndpoint,
    ReposCreateHookRequestOptions
  ];
  "POST /repos/:owner/:repo/hooks/:hook_id/pings": [
    ReposPingHookEndpoint,
    ReposPingHookRequestOptions
  ];
  "POST /repos/:owner/:repo/hooks/:hook_id/tests": [
    ReposTestPushHookEndpoint,
    ReposTestPushHookRequestOptions
  ];
  "POST /repos/:owner/:repo/issues": [
    IssuesCreateEndpoint,
    IssuesCreateRequestOptions
  ];
  "POST /repos/:owner/:repo/issues/:issue_number/assignees": [
    IssuesAddAssigneesEndpoint,
    IssuesAddAssigneesRequestOptions
  ];
  "POST /repos/:owner/:repo/issues/:issue_number/comments": [
    IssuesCreateCommentEndpoint,
    IssuesCreateCommentRequestOptions
  ];
  "POST /repos/:owner/:repo/issues/:issue_number/labels": [
    IssuesAddLabelsEndpoint,
    IssuesAddLabelsRequestOptions
  ];
  "POST /repos/:owner/:repo/issues/:issue_number/reactions": [
    ReactionsCreateForIssueEndpoint,
    ReactionsCreateForIssueRequestOptions
  ];
  "POST /repos/:owner/:repo/issues/comments/:comment_id/reactions": [
    ReactionsCreateForIssueCommentEndpoint,
    ReactionsCreateForIssueCommentRequestOptions
  ];
  "POST /repos/:owner/:repo/keys": [
    ReposAddDeployKeyEndpoint,
    ReposAddDeployKeyRequestOptions
  ];
  "POST /repos/:owner/:repo/labels": [
    IssuesCreateLabelEndpoint,
    IssuesCreateLabelRequestOptions
  ];
  "POST /repos/:owner/:repo/merges": [
    ReposMergeEndpoint,
    ReposMergeRequestOptions
  ];
  "POST /repos/:owner/:repo/milestones": [
    IssuesCreateMilestoneEndpoint,
    IssuesCreateMilestoneRequestOptions
  ];
  "POST /repos/:owner/:repo/pages": [
    ReposEnablePagesSiteEndpoint,
    ReposEnablePagesSiteRequestOptions
  ];
  "POST /repos/:owner/:repo/pages/builds": [
    ReposRequestPageBuildEndpoint,
    ReposRequestPageBuildRequestOptions
  ];
  "POST /repos/:owner/:repo/projects": [
    ProjectsCreateForRepoEndpoint,
    ProjectsCreateForRepoRequestOptions
  ];
  "POST /repos/:owner/:repo/pulls": [
    PullsCreateEndpoint,
    PullsCreateRequestOptions
  ];
  "POST /repos/:owner/:repo/pulls/:pull_number/comments": [
    PullsCreateCommentEndpoint | PullsCreateCommentReplyEndpoint,
    PullsCreateCommentRequestOptions | PullsCreateCommentReplyRequestOptions
  ];
  "POST /repos/:owner/:repo/pulls/:pull_number/comments/:comment_id/replies": [
    PullsCreateReviewCommentReplyEndpoint,
    PullsCreateReviewCommentReplyRequestOptions
  ];
  "POST /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": [
    PullsCreateReviewRequestEndpoint,
    PullsCreateReviewRequestRequestOptions
  ];
  "POST /repos/:owner/:repo/pulls/:pull_number/reviews": [
    PullsCreateReviewEndpoint,
    PullsCreateReviewRequestOptions
  ];
  "POST /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/events": [
    PullsSubmitReviewEndpoint,
    PullsSubmitReviewRequestOptions
  ];
  "POST /repos/:owner/:repo/pulls/comments/:comment_id/reactions": [
    ReactionsCreateForPullRequestReviewCommentEndpoint,
    ReactionsCreateForPullRequestReviewCommentRequestOptions
  ];
  "POST /repos/:owner/:repo/releases": [
    ReposCreateReleaseEndpoint,
    ReposCreateReleaseRequestOptions
  ];
  "POST /repos/:owner/:repo/statuses/:sha": [
    ReposCreateStatusEndpoint,
    ReposCreateStatusRequestOptions
  ];
  "POST /repos/:owner/:repo/transfer": [
    ReposTransferEndpoint,
    ReposTransferRequestOptions
  ];
  "POST /repos/:template_owner/:template_repo/generate": [
    ReposCreateUsingTemplateEndpoint,
    ReposCreateUsingTemplateRequestOptions
  ];
  "POST /scim/v2/organizations/:org/Users": [
    ScimProvisionAndInviteUsersEndpoint | ScimProvisionInviteUsersEndpoint,

      | ScimProvisionAndInviteUsersRequestOptions
      | ScimProvisionInviteUsersRequestOptions
  ];
  "POST /teams/:team_id/discussions": [
    TeamsCreateDiscussionLegacyEndpoint | TeamsCreateDiscussionEndpoint,

      | TeamsCreateDiscussionLegacyRequestOptions
      | TeamsCreateDiscussionRequestOptions
  ];
  "POST /teams/:team_id/discussions/:discussion_number/comments": [

      | TeamsCreateDiscussionCommentLegacyEndpoint
      | TeamsCreateDiscussionCommentEndpoint,

      | TeamsCreateDiscussionCommentLegacyRequestOptions
      | TeamsCreateDiscussionCommentRequestOptions
  ];
  "POST /teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions": [

      | ReactionsCreateForTeamDiscussionCommentLegacyEndpoint
      | ReactionsCreateForTeamDiscussionCommentEndpoint,

      | ReactionsCreateForTeamDiscussionCommentLegacyRequestOptions
      | ReactionsCreateForTeamDiscussionCommentRequestOptions
  ];
  "POST /teams/:team_id/discussions/:discussion_number/reactions": [

      | ReactionsCreateForTeamDiscussionLegacyEndpoint
      | ReactionsCreateForTeamDiscussionEndpoint,

      | ReactionsCreateForTeamDiscussionLegacyRequestOptions
      | ReactionsCreateForTeamDiscussionRequestOptions
  ];
  "POST /user/emails": [UsersAddEmailsEndpoint, UsersAddEmailsRequestOptions];
  "POST /user/gpg_keys": [
    UsersCreateGpgKeyEndpoint,
    UsersCreateGpgKeyRequestOptions
  ];
  "POST /user/keys": [
    UsersCreatePublicKeyEndpoint,
    UsersCreatePublicKeyRequestOptions
  ];
  "POST /user/migrations": [
    MigrationsStartForAuthenticatedUserEndpoint,
    MigrationsStartForAuthenticatedUserRequestOptions
  ];
  "POST /user/projects": [
    ProjectsCreateForAuthenticatedUserEndpoint,
    ProjectsCreateForAuthenticatedUserRequestOptions
  ];
  "POST /user/repos": [
    ReposCreateForAuthenticatedUserEndpoint,
    ReposCreateForAuthenticatedUserRequestOptions
  ];
  "PUT /authorizations/clients/:client_id": [
    OauthAuthorizationsGetOrCreateAuthorizationForAppEndpoint,
    OauthAuthorizationsGetOrCreateAuthorizationForAppRequestOptions
  ];
  "PUT /authorizations/clients/:client_id/:fingerprint": [

      | OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintEndpoint
      | OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintEndpoint,

      | OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintRequestOptions
      | OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintRequestOptions
  ];
  "PUT /gists/:gist_id/star": [GistsStarEndpoint, GistsStarRequestOptions];
  "PUT /notifications": [
    ActivityMarkAsReadEndpoint,
    ActivityMarkAsReadRequestOptions
  ];
  "PUT /notifications/threads/:thread_id/subscription": [
    ActivitySetThreadSubscriptionEndpoint,
    ActivitySetThreadSubscriptionRequestOptions
  ];
  "PUT /orgs/:org/blocks/:username": [
    OrgsBlockUserEndpoint,
    OrgsBlockUserRequestOptions
  ];
  "PUT /orgs/:org/interaction-limits": [
    InteractionsAddOrUpdateRestrictionsForOrgEndpoint,
    InteractionsAddOrUpdateRestrictionsForOrgRequestOptions
  ];
  "PUT /orgs/:org/memberships/:username": [
    OrgsAddOrUpdateMembershipEndpoint,
    OrgsAddOrUpdateMembershipRequestOptions
  ];
  "PUT /orgs/:org/outside_collaborators/:username": [
    OrgsConvertMemberToOutsideCollaboratorEndpoint,
    OrgsConvertMemberToOutsideCollaboratorRequestOptions
  ];
  "PUT /orgs/:org/public_members/:username": [
    OrgsPublicizeMembershipEndpoint,
    OrgsPublicizeMembershipRequestOptions
  ];
  "PUT /orgs/:org/teams/:team_slug/memberships/:username": [
    TeamsAddOrUpdateMembershipInOrgEndpoint,
    TeamsAddOrUpdateMembershipInOrgRequestOptions
  ];
  "PUT /orgs/:org/teams/:team_slug/projects/:project_id": [
    TeamsAddOrUpdateProjectInOrgEndpoint,
    TeamsAddOrUpdateProjectInOrgRequestOptions
  ];
  "PUT /orgs/:org/teams/:team_slug/repos/:owner/:repo": [
    TeamsAddOrUpdateRepoInOrgEndpoint,
    TeamsAddOrUpdateRepoInOrgRequestOptions
  ];
  "PUT /projects/:project_id/collaborators/:username": [
    ProjectsAddCollaboratorEndpoint,
    ProjectsAddCollaboratorRequestOptions
  ];
  "PUT /repos/:owner/:repo/automated-security-fixes": [
    ReposEnableAutomatedSecurityFixesEndpoint,
    ReposEnableAutomatedSecurityFixesRequestOptions
  ];
  "PUT /repos/:owner/:repo/branches/:branch/protection": [
    ReposUpdateBranchProtectionEndpoint,
    ReposUpdateBranchProtectionRequestOptions
  ];
  "PUT /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": [
    ReposReplaceProtectedBranchRequiredStatusChecksContextsEndpoint,
    ReposReplaceProtectedBranchRequiredStatusChecksContextsRequestOptions
  ];
  "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": [
    ReposReplaceProtectedBranchAppRestrictionsEndpoint,
    ReposReplaceProtectedBranchAppRestrictionsRequestOptions
  ];
  "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": [
    ReposReplaceProtectedBranchTeamRestrictionsEndpoint,
    ReposReplaceProtectedBranchTeamRestrictionsRequestOptions
  ];
  "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/users": [
    ReposReplaceProtectedBranchUserRestrictionsEndpoint,
    ReposReplaceProtectedBranchUserRestrictionsRequestOptions
  ];
  "PUT /repos/:owner/:repo/collaborators/:username": [
    ReposAddCollaboratorEndpoint,
    ReposAddCollaboratorRequestOptions
  ];
  "PUT /repos/:owner/:repo/contents/:path": [

      | ReposCreateOrUpdateFileEndpoint
      | ReposCreateFileEndpoint
      | ReposUpdateFileEndpoint,

      | ReposCreateOrUpdateFileRequestOptions
      | ReposCreateFileRequestOptions
      | ReposUpdateFileRequestOptions
  ];
  "PUT /repos/:owner/:repo/import": [
    MigrationsStartImportEndpoint,
    MigrationsStartImportRequestOptions
  ];
  "PUT /repos/:owner/:repo/interaction-limits": [
    InteractionsAddOrUpdateRestrictionsForRepoEndpoint,
    InteractionsAddOrUpdateRestrictionsForRepoRequestOptions
  ];
  "PUT /repos/:owner/:repo/issues/:issue_number/labels": [
    IssuesReplaceLabelsEndpoint,
    IssuesReplaceLabelsRequestOptions
  ];
  "PUT /repos/:owner/:repo/issues/:issue_number/lock": [
    IssuesLockEndpoint,
    IssuesLockRequestOptions
  ];
  "PUT /repos/:owner/:repo/notifications": [
    ActivityMarkNotificationsAsReadForRepoEndpoint,
    ActivityMarkNotificationsAsReadForRepoRequestOptions
  ];
  "PUT /repos/:owner/:repo/pages": [
    ReposUpdateInformationAboutPagesSiteEndpoint,
    ReposUpdateInformationAboutPagesSiteRequestOptions
  ];
  "PUT /repos/:owner/:repo/pulls/:pull_number/merge": [
    PullsMergeEndpoint,
    PullsMergeRequestOptions
  ];
  "PUT /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": [
    PullsUpdateReviewEndpoint,
    PullsUpdateReviewRequestOptions
  ];
  "PUT /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/dismissals": [
    PullsDismissReviewEndpoint,
    PullsDismissReviewRequestOptions
  ];
  "PUT /repos/:owner/:repo/pulls/:pull_number/update-branch": [
    PullsUpdateBranchEndpoint,
    PullsUpdateBranchRequestOptions
  ];
  "PUT /repos/:owner/:repo/subscription": [
    ActivitySetRepoSubscriptionEndpoint,
    ActivitySetRepoSubscriptionRequestOptions
  ];
  "PUT /repos/:owner/:repo/topics": [
    ReposReplaceTopicsEndpoint,
    ReposReplaceTopicsRequestOptions
  ];
  "PUT /repos/:owner/:repo/vulnerability-alerts": [
    ReposEnableVulnerabilityAlertsEndpoint,
    ReposEnableVulnerabilityAlertsRequestOptions
  ];
  "PUT /scim/v2/organizations/:org/Users/:scim_user_id": [

      | ScimReplaceProvisionedUserInformationEndpoint
      | ScimUpdateProvisionedOrgMembershipEndpoint,

      | ScimReplaceProvisionedUserInformationRequestOptions
      | ScimUpdateProvisionedOrgMembershipRequestOptions
  ];
  "PUT /teams/:team_id/members/:username": [
    TeamsAddMemberLegacyEndpoint | TeamsAddMemberEndpoint,
    TeamsAddMemberLegacyRequestOptions | TeamsAddMemberRequestOptions
  ];
  "PUT /teams/:team_id/memberships/:username": [

      | TeamsAddOrUpdateMembershipLegacyEndpoint
      | TeamsAddOrUpdateMembershipEndpoint,

      | TeamsAddOrUpdateMembershipLegacyRequestOptions
      | TeamsAddOrUpdateMembershipRequestOptions
  ];
  "PUT /teams/:team_id/projects/:project_id": [
    TeamsAddOrUpdateProjectLegacyEndpoint | TeamsAddOrUpdateProjectEndpoint,

      | TeamsAddOrUpdateProjectLegacyRequestOptions
      | TeamsAddOrUpdateProjectRequestOptions
  ];
  "PUT /teams/:team_id/repos/:owner/:repo": [
    TeamsAddOrUpdateRepoLegacyEndpoint | TeamsAddOrUpdateRepoEndpoint,

      | TeamsAddOrUpdateRepoLegacyRequestOptions
      | TeamsAddOrUpdateRepoRequestOptions
  ];
  "PUT /user/blocks/:username": [UsersBlockEndpoint, UsersBlockRequestOptions];
  "PUT /user/following/:username": [
    UsersFollowEndpoint,
    UsersFollowRequestOptions
  ];
  "PUT /user/installations/:installation_id/repositories/:repository_id": [
    AppsAddRepoToInstallationEndpoint,
    AppsAddRepoToInstallationRequestOptions
  ];
  "PUT /user/starred/:owner/:repo": [
    ActivityStarRepoEndpoint,
    ActivityStarRepoRequestOptions
  ];
  "PUT /user/subscriptions/:owner/:repo": [
    ActivityWatchRepoLegacyEndpoint,
    ActivityWatchRepoLegacyRequestOptions
  ];
}

type AppsGetAuthenticatedEndpoint = {};
type AppsGetAuthenticatedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCreateFromManifestEndpoint = {
  /**
   * code parameter
   */
  code: string;
};
type AppsCreateFromManifestRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListInstallationsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListInstallationsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetInstallationEndpoint = {
  /**
   * installation_id parameter
   */
  installation_id: number;
};
type AppsGetInstallationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsDeleteInstallationEndpoint = {
  /**
   * installation_id parameter
   */
  installation_id: number;
};
type AppsDeleteInstallationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCreateInstallationTokenEndpoint = {
  /**
   * installation_id parameter
   */
  installation_id: number;
  /**
   * The `id`s of the repositories that the installation token can access. Providing repository `id`s restricts the access of an installation token to specific repositories. You can use the "[List repositories](https://developer.github.com/v3/apps/installations/#list-repositories)" endpoint to get the `id` of all repositories that an installation can access. For example, you can select specific repositories when creating an installation token to restrict the number of repositories that can be cloned using the token.
   */
  repository_ids?: number[];
  /**
   * The permissions granted to the access token. The permissions object includes the permission names and their access type. For a complete list of permissions and allowable values, see "[GitHub App permissions](https://developer.github.com/apps/building-github-apps/creating-github-apps-using-url-parameters/#github-app-permissions)."
   */
  permissions?: AppsCreateInstallationTokenParamsPermissions;
};
type AppsCreateInstallationTokenRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsListGrantsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OauthAuthorizationsListGrantsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsGetGrantEndpoint = {
  /**
   * grant_id parameter
   */
  grant_id: number;
};
type OauthAuthorizationsGetGrantRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsDeleteGrantEndpoint = {
  /**
   * grant_id parameter
   */
  grant_id: number;
};
type OauthAuthorizationsDeleteGrantRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsDeleteAuthorizationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The OAuth access token used to authenticate to the GitHub API.
   */
  access_token?: string;
};
type AppsDeleteAuthorizationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsRevokeGrantForApplicationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};
type AppsRevokeGrantForApplicationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsRevokeGrantForApplicationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};
type OauthAuthorizationsRevokeGrantForApplicationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCheckTokenEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The OAuth access token used to authenticate to the GitHub API.
   */
  access_token?: string;
};
type AppsCheckTokenRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsResetTokenEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The OAuth access token used to authenticate to the GitHub API.
   */
  access_token?: string;
};
type AppsResetTokenRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsDeleteTokenEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The OAuth access token used to authenticate to the GitHub API.
   */
  access_token?: string;
};
type AppsDeleteTokenRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCheckAuthorizationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};
type AppsCheckAuthorizationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsCheckAuthorizationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};
type OauthAuthorizationsCheckAuthorizationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsResetAuthorizationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};
type AppsResetAuthorizationRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsResetAuthorizationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};
type OauthAuthorizationsResetAuthorizationRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsRevokeAuthorizationForApplicationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};
type AppsRevokeAuthorizationForApplicationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsRevokeAuthorizationForApplicationEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * access_token parameter
   */
  access_token: string;
};
type OauthAuthorizationsRevokeAuthorizationForApplicationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetBySlugEndpoint = {
  /**
   * app_slug parameter
   */
  app_slug: string;
};
type AppsGetBySlugRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsListAuthorizationsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OauthAuthorizationsListAuthorizationsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsCreateAuthorizationEndpoint = {
  /**
   * A list of scopes that this authorization is in.
   */
  scopes?: string[];
  /**
   * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
   */
  note: string;
  /**
   * A URL to remind you what app the OAuth token is for.
   */
  note_url?: string;
  /**
   * The 20 character OAuth app client key for which to create the token.
   */
  client_id?: string;
  /**
   * The 40 character OAuth app client secret for which to create the token.
   */
  client_secret?: string;
  /**
   * A unique string to distinguish an authorization from others created for the same client ID and user.
   */
  fingerprint?: string;
};
type OauthAuthorizationsCreateAuthorizationRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * The 40 character OAuth app client secret associated with the client ID specified in the URL.
   */
  client_secret: string;
  /**
   * A list of scopes that this authorization is in.
   */
  scopes?: string[];
  /**
   * A note to remind you what the OAuth token is for.
   */
  note?: string;
  /**
   * A URL to remind you what app the OAuth token is for.
   */
  note_url?: string;
  /**
   * A unique string to distinguish an authorization from others created for the same client and user. If provided, this API is functionally equivalent to [Get-or-create an authorization for a specific app and fingerprint](https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint).
   */
  fingerprint?: string;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * fingerprint parameter
   */
  fingerprint: string;
  /**
   * The 40 character OAuth app client secret associated with the client ID specified in the URL.
   */
  client_secret: string;
  /**
   * A list of scopes that this authorization is in.
   */
  scopes?: string[];
  /**
   * A note to remind you what the OAuth token is for.
   */
  note?: string;
  /**
   * A URL to remind you what app the OAuth token is for.
   */
  note_url?: string;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintEndpoint = {
  /**
   * client_id parameter
   */
  client_id: string;
  /**
   * fingerprint parameter
   */
  fingerprint: string;
  /**
   * The 40 character OAuth app client secret associated with the client ID specified in the URL.
   */
  client_secret: string;
  /**
   * A list of scopes that this authorization is in.
   */
  scopes?: string[];
  /**
   * A note to remind you what the OAuth token is for.
   */
  note?: string;
  /**
   * A URL to remind you what app the OAuth token is for.
   */
  note_url?: string;
};
type OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsGetAuthorizationEndpoint = {
  /**
   * authorization_id parameter
   */
  authorization_id: number;
};
type OauthAuthorizationsGetAuthorizationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsUpdateAuthorizationEndpoint = {
  /**
   * authorization_id parameter
   */
  authorization_id: number;
  /**
   * Replaces the authorization scopes with these.
   */
  scopes?: string[];
  /**
   * A list of scopes to add to this authorization.
   */
  add_scopes?: string[];
  /**
   * A list of scopes to remove from this authorization.
   */
  remove_scopes?: string[];
  /**
   * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
   */
  note?: string;
  /**
   * A URL to remind you what app the OAuth token is for.
   */
  note_url?: string;
  /**
   * A unique string to distinguish an authorization from others created for the same client ID and user.
   */
  fingerprint?: string;
};
type OauthAuthorizationsUpdateAuthorizationRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OauthAuthorizationsDeleteAuthorizationEndpoint = {
  /**
   * authorization_id parameter
   */
  authorization_id: number;
};
type OauthAuthorizationsDeleteAuthorizationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type CodesOfConductListConductCodesEndpoint = {};
type CodesOfConductListConductCodesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type CodesOfConductGetConductCodeEndpoint = {
  /**
   * key parameter
   */
  key: string;
};
type CodesOfConductGetConductCodeRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCreateContentAttachmentEndpoint = {
  /**
   * content_reference_id parameter
   */
  content_reference_id: number;
  /**
   * The title of the content attachment displayed in the body or comment of an issue or pull request.
   */
  title: string;
  /**
   * The body text of the content attachment displayed in the body or comment of an issue or pull request. This parameter supports markdown.
   */
  body: string;
};
type AppsCreateContentAttachmentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type EmojisGetEndpoint = {};
type EmojisGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListPublicEventsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListPublicEventsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListFeedsEndpoint = {};
type ActivityListFeedsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListEndpoint = {
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type GistsListRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsCreateEndpoint = {
  /**
   * The filenames and content of each file in the gist. The keys in the `files` object represent the filename and have the type `string`.
   */
  files: GistsCreateParamsFiles;
  /**
   * A descriptive name for this gist.
   */
  description?: string;
  /**
   * When `true`, the gist will be public and available for anyone to see.
   */
  public?: boolean;
};
type GistsCreateRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListPublicEndpoint = {
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type GistsListPublicRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListStarredEndpoint = {
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type GistsListStarredRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsGetEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};
type GistsGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsUpdateEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * A descriptive name for this gist.
   */
  description?: string;
  /**
   * The filenames and content that make up this gist.
   */
  files?: GistsUpdateParamsFiles;
};
type GistsUpdateRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsDeleteEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};
type GistsDeleteRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListCommentsEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type GistsListCommentsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsCreateCommentEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * The comment text.
   */
  body: string;
};
type GistsCreateCommentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsGetCommentEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};
type GistsGetCommentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsUpdateCommentEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The comment text.
   */
  body: string;
};
type GistsUpdateCommentRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsDeleteCommentEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};
type GistsDeleteCommentRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListCommitsEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type GistsListCommitsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsForkEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};
type GistsForkRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListForksEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type GistsListForksRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsStarEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};
type GistsStarRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsUnstarEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};
type GistsUnstarRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsCheckIsStarredEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
};
type GistsCheckIsStarredRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsGetRevisionEndpoint = {
  /**
   * gist_id parameter
   */
  gist_id: string;
  /**
   * sha parameter
   */
  sha: string;
};
type GistsGetRevisionRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitignoreListTemplatesEndpoint = {};
type GitignoreListTemplatesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitignoreGetTemplateEndpoint = {
  /**
   * name parameter
   */
  name: string;
};
type GitignoreGetTemplateRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListReposEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListReposRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsRevokeInstallationTokenEndpoint = {};
type AppsRevokeInstallationTokenRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListEndpoint = {
  /**
   * Indicates which sorts of issues to return. Can be one of:
   * \* `assigned`: Issues assigned to you
   * \* `created`: Issues created by you
   * \* `mentioned`: Issues mentioning you
   * \* `subscribed`: Issues you're subscribed to updates for
   * \* `all`: All issues the authenticated user can see, regardless of participation or creation
   */
  filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
  /**
   * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * A list of comma separated label names. Example: `bug,ui,@high`
   */
  labels?: string;
  /**
   * What to sort results by. Can be either `created`, `updated`, `comments`.
   */
  sort?: "created" | "updated" | "comments";
  /**
   * The direction of the sort. Can be either `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchIssuesLegacyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repository parameter
   */
  repository: string;
  /**
   * Indicates the state of the issues to return. Can be either `open` or `closed`.
   */
  state: "open" | "closed";
  /**
   * The search term.
   */
  keyword: string;
};
type SearchIssuesLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchReposLegacyEndpoint = {
  /**
   * The search term.
   */
  keyword: string;
  /**
   * Filter results by language.
   */
  language?: string;
  /**
   * The page number to fetch.
   */
  start_page?: string;
  /**
   * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
   */
  sort?: "stars" | "forks" | "updated";
  /**
   * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
   */
  order?: "asc" | "desc";
};
type SearchReposLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchEmailLegacyEndpoint = {
  /**
   * The email address.
   */
  email: string;
};
type SearchEmailLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchUsersLegacyEndpoint = {
  /**
   * The search term.
   */
  keyword: string;
  /**
   * The page number to fetch.
   */
  start_page?: string;
  /**
   * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
   */
  sort?: "stars" | "forks" | "updated";
  /**
   * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
   */
  order?: "asc" | "desc";
};
type SearchUsersLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type LicensesListCommonlyUsedEndpoint = {};
type LicensesListCommonlyUsedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type LicensesListEndpoint = {};
type LicensesListRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type LicensesGetEndpoint = {
  /**
   * license parameter
   */
  license: string;
};
type LicensesGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MarkdownRenderEndpoint = {
  /**
   * The Markdown text to render in HTML. Markdown content must be 400 KB or less.
   */
  text: string;
  /**
   * The rendering mode. Can be either:
   * \* `markdown` to render a document in plain Markdown, just like README.md files are rendered.
   * \* `gfm` to render a document in [GitHub Flavored Markdown](https://github.github.com/gfm/), which creates links for user mentions as well as references to SHA-1 hashes, issues, and pull requests.
   */
  mode?: "markdown" | "gfm";
  /**
   * The repository context to use when creating references in `gfm` mode. Omit this parameter when using `markdown` mode.
   */
  context?: string;
};
type MarkdownRenderRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MarkdownRenderRawEndpoint = {
  /**
   * data parameter
   */
  data: string;
};
type MarkdownRenderRawRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCheckAccountIsAssociatedWithAnyEndpoint = {
  /**
   * account_id parameter
   */
  account_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsCheckAccountIsAssociatedWithAnyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListPlansEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListPlansRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListAccountsUserOrOrgOnPlanEndpoint = {
  /**
   * plan_id parameter
   */
  plan_id: number;
  /**
   * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
   */
  sort?: "created" | "updated";
  /**
   * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListAccountsUserOrOrgOnPlanRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsCheckAccountIsAssociatedWithAnyStubbedEndpoint = {
  /**
   * account_id parameter
   */
  account_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsCheckAccountIsAssociatedWithAnyStubbedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListPlansStubbedEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListPlansStubbedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListAccountsUserOrOrgOnPlanStubbedEndpoint = {
  /**
   * plan_id parameter
   */
  plan_id: number;
  /**
   * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
   */
  sort?: "created" | "updated";
  /**
   * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListAccountsUserOrOrgOnPlanStubbedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MetaGetEndpoint = {};
type MetaGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListPublicEventsForRepoNetworkEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListPublicEventsForRepoNetworkRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListNotificationsEndpoint = {
  /**
   * If `true`, show notifications marked as read.
   */
  all?: boolean;
  /**
   * If `true`, only shows notifications in which the user is directly participating or mentioned.
   */
  participating?: boolean;
  /**
   * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  before?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListNotificationsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityMarkAsReadEndpoint = {
  /**
   * Describes the last point that notifications were checked. Anything updated since this time will not be updated. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
   */
  last_read_at?: string;
};
type ActivityMarkAsReadRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityGetThreadEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
};
type ActivityGetThreadRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityMarkThreadAsReadEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
};
type ActivityMarkThreadAsReadRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityGetThreadSubscriptionEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
};
type ActivityGetThreadSubscriptionRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivitySetThreadSubscriptionEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
  /**
   * Unsubscribes and subscribes you to a conversation. Set `ignored` to `true` to block all notifications from this thread.
   */
  ignored?: boolean;
};
type ActivitySetThreadSubscriptionRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityDeleteThreadSubscriptionEndpoint = {
  /**
   * thread_id parameter
   */
  thread_id: number;
};
type ActivityDeleteThreadSubscriptionRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListEndpoint = {
  /**
   * The integer ID of the last Organization that you've seen.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsGetEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type OrgsGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsUpdateEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Billing email address. This address is not publicized.
   */
  billing_email?: string;
  /**
   * The company name.
   */
  company?: string;
  /**
   * The publicly visible email address.
   */
  email?: string;
  /**
   * The location.
   */
  location?: string;
  /**
   * The shorthand name of the company.
   */
  name?: string;
  /**
   * The description of the company.
   */
  description?: string;
  /**
   * Toggles whether an organization can use organization projects.
   */
  has_organization_projects?: boolean;
  /**
   * Toggles whether repositories that belong to the organization can use repository projects.
   */
  has_repository_projects?: boolean;
  /**
   * Default permission level members have for organization repositories:
   * \* `read` - can pull, but not push to or administer this repository.
   * \* `write` - can pull and push, but not administer this repository.
   * \* `admin` - can pull, push, and administer this repository.
   * \* `none` - no permissions granted by default.
   */
  default_repository_permission?: "read" | "write" | "admin" | "none";
  /**
   * Toggles the ability of non-admin organization members to create repositories. Can be one of:
   * \* `true` - all organization members can create repositories.
   * \* `false` - only organization owners can create repositories.
   * Default: `true`
   * **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
   */
  members_can_create_repositories?: boolean;
  /**
   * Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud. Can be one of:
   * \* `true` - all organization members can create internal repositories.
   * \* `false` - only organization owners can create internal repositories.
   * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
   */
  members_can_create_internal_repositories?: boolean;
  /**
   * Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:
   * \* `true` - all organization members can create private repositories.
   * \* `false` - only organization owners can create private repositories.
   * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
   */
  members_can_create_private_repositories?: boolean;
  /**
   * Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:
   * \* `true` - all organization members can create public repositories.
   * \* `false` - only organization owners can create public repositories.
   * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
   */
  members_can_create_public_repositories?: boolean;
  /**
   * Specifies which types of repositories non-admin organization members can create. Can be one of:
   * \* `all` - all organization members can create public and private repositories.
   * \* `private` - members can create private repositories. This option is only available to repositories that are part of an organization on GitHub Enterprise Cloud.
   * \* `none` - only admin members can create repositories.
   * **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See [this note](https://developer.github.com/v3/orgs/#members_can_create_repositories) for details.
   */
  members_allowed_repository_creation_type?: "all" | "private" | "none";
};
type OrgsUpdateRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListBlockedUsersEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type OrgsListBlockedUsersRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsCheckBlockedUserEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsCheckBlockedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsBlockUserEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsBlockUserRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsUnblockUserEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsUnblockUserRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListCredentialAuthorizationsEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type OrgsListCredentialAuthorizationsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsRemoveCredentialAuthorizationEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * credential_id parameter
   */
  credential_id: number;
};
type OrgsRemoveCredentialAuthorizationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListPublicEventsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListPublicEventsForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListHooksEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListHooksRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsCreateHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Must be passed as "web".
   */
  name: string;
  /**
   * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#create-hook-config-params).
   */
  config: OrgsCreateHookParamsConfig;
  /**
   * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
   */
  events?: string[];
  /**
   * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
   */
  active?: boolean;
};
type OrgsCreateHookRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsGetHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};
type OrgsGetHookRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsUpdateHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
  /**
   * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#update-hook-config-params).
   */
  config?: OrgsUpdateHookParamsConfig;
  /**
   * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
   */
  events?: string[];
  /**
   * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
   */
  active?: boolean;
};
type OrgsUpdateHookRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsDeleteHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};
type OrgsDeleteHookRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsPingHookEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};
type OrgsPingHookRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetOrgInstallationEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type AppsGetOrgInstallationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsFindOrgInstallationEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type AppsFindOrgInstallationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListInstallationsEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListInstallationsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsGetRestrictionsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type InteractionsGetRestrictionsForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsAddOrUpdateRestrictionsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Specifies the group of GitHub users who can comment, open issues, or create pull requests in public repositories for the given organization. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
   */
  limit: "existing_users" | "contributors_only" | "collaborators_only";
};
type InteractionsAddOrUpdateRestrictionsForOrgRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsRemoveRestrictionsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type InteractionsRemoveRestrictionsForOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListPendingInvitationsEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListPendingInvitationsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsCreateInvitationEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
   */
  invitee_id?: number;
  /**
   * **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
   */
  email?: string;
  /**
   * Specify role for new member. Can be one of:
   * \* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.
   * \* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.
   * \* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
   */
  role?: "admin" | "direct_member" | "billing_manager";
  /**
   * Specify IDs for the teams you want to invite new members to.
   */
  team_ids?: number[];
};
type OrgsCreateInvitationRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListInvitationTeamsEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * invitation_id parameter
   */
  invitation_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListInvitationTeamsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Indicates which sorts of issues to return. Can be one of:
   * \* `assigned`: Issues assigned to you
   * \* `created`: Issues created by you
   * \* `mentioned`: Issues mentioning you
   * \* `subscribed`: Issues you're subscribed to updates for
   * \* `all`: All issues the authenticated user can see, regardless of participation or creation
   */
  filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
  /**
   * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * A list of comma separated label names. Example: `bug,ui,@high`
   */
  labels?: string;
  /**
   * What to sort results by. Can be either `created`, `updated`, `comments`.
   */
  sort?: "created" | "updated" | "comments";
  /**
   * The direction of the sort. Can be either `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListMembersEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Filter members returned in the list. Can be one of:
   * \* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.
   * \* `all` - All members the authenticated user can see.
   */
  filter?: "2fa_disabled" | "all";
  /**
   * Filter members returned by their role. Can be one of:
   * \* `all` - All members of the organization, regardless of role.
   * \* `admin` - Organization owners.
   * \* `member` - Non-owner organization members.
   */
  role?: "all" | "admin" | "member";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListMembersRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsCheckMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsCheckMembershipRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsRemoveMemberEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsRemoveMemberRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsGetMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsGetMembershipRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsAddOrUpdateMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
  /**
   * The role to give the user in the organization. Can be one of:
   * \* `admin` - The user will become an owner of the organization.
   * \* `member` - The user will become a non-owner member of the organization.
   */
  role?: "admin" | "member";
};
type OrgsAddOrUpdateMembershipRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsRemoveMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsRemoveMembershipRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsStartForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * A list of arrays indicating which repositories should be migrated.
   */
  repositories: string[];
  /**
   * Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
   */
  lock_repositories?: boolean;
  /**
   * Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
   */
  exclude_attachments?: boolean;
};
type MigrationsStartForOrgRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsListForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type MigrationsListForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetStatusForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
};
type MigrationsGetStatusForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetArchiveForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
};
type MigrationsGetArchiveForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsDeleteArchiveForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
};
type MigrationsDeleteArchiveForOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsUnlockRepoForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
  /**
   * repo_name parameter
   */
  repo_name: string;
};
type MigrationsUnlockRepoForOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsListReposForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * migration_id parameter
   */
  migration_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type MigrationsListReposForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListOutsideCollaboratorsEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Filter the list of outside collaborators. Can be one of:
   * \* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.
   * \* `all`: All outside collaborators.
   */
  filter?: "2fa_disabled" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListOutsideCollaboratorsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsRemoveOutsideCollaboratorEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsRemoveOutsideCollaboratorRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsConvertMemberToOutsideCollaboratorEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsConvertMemberToOutsideCollaboratorRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ProjectsListForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsCreateForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * The name of the project.
   */
  name: string;
  /**
   * The description of the project.
   */
  body?: string;
};
type ProjectsCreateForOrgRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListPublicMembersEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListPublicMembersRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsCheckPublicMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsCheckPublicMembershipRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsPublicizeMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsPublicizeMembershipRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsConcealMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * username parameter
   */
  username: string;
};
type OrgsConcealMembershipRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Specifies the types of repositories you want returned. Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`, `internal`. Default: `all`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `type` can also be `internal`.
   */
  type?:
    | "all"
    | "public"
    | "private"
    | "forks"
    | "sources"
    | "member"
    | "internal";
  /**
   * Can be one of `created`, `updated`, `pushed`, `full_name`.
   */
  sort?: "created" | "updated" | "pushed" | "full_name";
  /**
   * Can be one of `asc` or `desc`. Default: when using `full_name`: `asc`, otherwise `desc`
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * The name of the repository.
   */
  name: string;
  /**
   * A short description of the repository.
   */
  description?: string;
  /**
   * A URL with more information about the repository.
   */
  homepage?: string;
  /**
   * Either `true` to create a private repository or `false` to create a public one. Creating private repositories requires a paid GitHub account.
   */
  private?: boolean;
  /**
   * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://help.github.com/github/creating-cloning-and-archiving-repositories/creating-an-internal-repository)" in the GitHub Help documentation.
   * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
   */
  visibility?: "public" | "private" | "visibility" | "internal";
  /**
   * Either `true` to enable issues for this repository or `false` to disable them.
   */
  has_issues?: boolean;
  /**
   * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
   */
  has_projects?: boolean;
  /**
   * Either `true` to enable the wiki for this repository or `false` to disable it.
   */
  has_wiki?: boolean;
  /**
   * Either `true` to make this repo available as a template repository or `false` to prevent it.
   */
  is_template?: boolean;
  /**
   * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
   */
  team_id?: number;
  /**
   * Pass `true` to create an initial commit with empty README.
   */
  auto_init?: boolean;
  /**
   * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
   */
  gitignore_template?: string;
  /**
   * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
   */
  license_template?: string;
  /**
   * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
   */
  allow_squash_merge?: boolean;
  /**
   * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
   */
  allow_merge_commit?: boolean;
  /**
   * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
   */
  allow_rebase_merge?: boolean;
  /**
   * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
   */
  delete_branch_on_merge?: boolean;
};
type ReposCreateInOrgRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListIdPGroupsForOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListIdPGroupsForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * The name of the team.
   */
  name: string;
  /**
   * The description of the team.
   */
  description?: string;
  /**
   * List GitHub IDs for organization members who will become team maintainers.
   */
  maintainers?: string[];
  /**
   * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
   */
  repo_names?: string[];
  /**
   * The level of privacy this team should have. The options are:
   * **For a non-nested team:**
   * \* `secret` - only visible to organization owners and members of this team.
   * \* `closed` - visible to all members of this organization.
   * Default: `secret`
   * **For a parent or child team:**
   * \* `closed` - visible to all members of this organization.
   * Default for child team: `closed`
   */
  privacy?: "secret" | "closed";
  /**
   * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
   * \* `push` - team members can pull and push, but not administer newly-added repositories.
   * \* `admin` - team members can pull, push and administer newly-added repositories.
   */
  permission?: "pull" | "push" | "admin";
  /**
   * The ID of a team to set as the parent team.
   */
  parent_team_id?: number;
};
type TeamsCreateRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetByNameEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
};
type TeamsGetByNameRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * The name of the team.
   */
  name: string;
  /**
   * The description of the team.
   */
  description?: string;
  /**
   * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:
   * **For a non-nested team:**
   * \* `secret` - only visible to organization owners and members of this team.
   * \* `closed` - visible to all members of this organization.
   * **For a parent or child team:**
   * \* `closed` - visible to all members of this organization.
   */
  privacy?: "secret" | "closed";
  /**
   * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
   * \* `push` - team members can pull and push, but not administer newly-added repositories.
   * \* `admin` - team members can pull, push and administer newly-added repositories.
   */
  permission?: "pull" | "push" | "admin";
  /**
   * The ID of a team to set as the parent team.
   */
  parent_team_id?: number;
};
type TeamsUpdateInOrgRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsDeleteInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
};
type TeamsDeleteInOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListDiscussionsInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * The discussion post's title.
   */
  title: string;
  /**
   * The discussion post's body text.
   */
  body: string;
  /**
   * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
   */
  private?: boolean;
};
type TeamsCreateDiscussionInOrgRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};
type TeamsGetDiscussionInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion post's title.
   */
  title?: string;
  /**
   * The discussion post's body text.
   */
  body?: string;
};
type TeamsUpdateDiscussionInOrgRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsDeleteDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};
type TeamsDeleteDiscussionInOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionCommentsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListDiscussionCommentsInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};
type TeamsCreateDiscussionCommentInOrgRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};
type TeamsGetDiscussionCommentInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};
type TeamsUpdateDiscussionCommentInOrgRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsDeleteDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};
type TeamsDeleteDiscussionCommentInOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForTeamDiscussionCommentInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionCommentInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForTeamDiscussionCommentInOrgRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForTeamDiscussionInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForTeamDiscussionInOrgRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListPendingInvitationsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListPendingInvitationsInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListMembersInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Filters members returned by their role in the team. Can be one of:
   * \* `member` - normal members of the team.
   * \* `maintainer` - team maintainers.
   * \* `all` - all members of the team.
   */
  role?: "member" | "maintainer" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListMembersInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetMembershipInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * username parameter
   */
  username: string;
};
type TeamsGetMembershipInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateMembershipInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * username parameter
   */
  username: string;
  /**
   * The role that this user should have in the team. Can be one of:
   * \* `member` - a normal member of the team.
   * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
   */
  role?: "member" | "maintainer";
};
type TeamsAddOrUpdateMembershipInOrgRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsRemoveMembershipInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * username parameter
   */
  username: string;
};
type TeamsRemoveMembershipInOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListProjectsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListProjectsInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsReviewProjectInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * project_id parameter
   */
  project_id: number;
};
type TeamsReviewProjectInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateProjectInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * The permission to grant to the team for this project. Can be one of:
   * \* `read` - team members can read, but not write to or administer this project.
   * \* `write` - team members can read and write, but not administer this project.
   * \* `admin` - team members can read, write and administer this project.
   * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
   */
  permission?: "read" | "write" | "admin";
};
type TeamsAddOrUpdateProjectInOrgRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsRemoveProjectInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * project_id parameter
   */
  project_id: number;
};
type TeamsRemoveProjectInOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListReposInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListReposInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCheckManagesRepoInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type TeamsCheckManagesRepoInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateRepoInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The permission to grant the team on this repository. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer this repository.
   * \* `push` - team members can pull and push, but not administer this repository.
   * \* `admin` - team members can pull, push and administer this repository.
   *
   * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
   */
  permission?: "pull" | "push" | "admin";
};
type TeamsAddOrUpdateRepoInOrgRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsRemoveRepoInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type TeamsRemoveRepoInOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListIdPGroupsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
};
type TeamsListIdPGroupsInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateOrUpdateIdPGroupConnectionsInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
   */
  groups: TeamsCreateOrUpdateIdPGroupConnectionsInOrgParamsGroups[];
};
type TeamsCreateOrUpdateIdPGroupConnectionsInOrgRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListChildInOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * team_slug parameter
   */
  team_slug: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListChildInOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsGetCardEndpoint = {
  /**
   * card_id parameter
   */
  card_id: number;
};
type ProjectsGetCardRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsUpdateCardEndpoint = {
  /**
   * card_id parameter
   */
  card_id: number;
  /**
   * The card's note content. Only valid for cards without another type of content, so this cannot be specified if the card already has a `content_id` and `content_type`.
   */
  note?: string;
  /**
   * Use `true` to archive a project card. Specify `false` if you need to restore a previously archived project card.
   */
  archived?: boolean;
};
type ProjectsUpdateCardRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsDeleteCardEndpoint = {
  /**
   * card_id parameter
   */
  card_id: number;
};
type ProjectsDeleteCardRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsMoveCardEndpoint = {
  /**
   * card_id parameter
   */
  card_id: number;
  /**
   * Can be one of `top`, `bottom`, or `after:<card_id>`, where `<card_id>` is the `id` value of a card in the same column, or in the new column specified by `column_id`.
   */
  position: string;
  /**
   * The `id` value of a column in the same project.
   */
  column_id?: number;
};
type ProjectsMoveCardRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsGetColumnEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
};
type ProjectsGetColumnRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsUpdateColumnEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
  /**
   * The new name of the column.
   */
  name: string;
};
type ProjectsUpdateColumnRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsDeleteColumnEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
};
type ProjectsDeleteColumnRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListCardsEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
  /**
   * Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
   */
  archived_state?: "all" | "archived" | "not_archived";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ProjectsListCardsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsCreateCardEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
  /**
   * The card's note content. Only valid for cards without another type of content, so you must omit when specifying `content_id` and `content_type`.
   */
  note?: string;
  /**
   * The issue or pull request id you want to associate with this card. You can use the [List issues for a repository](https://developer.github.com/v3/issues/#list-issues-for-a-repository) and [List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests) endpoints to find this id.
   * **Note:** Depending on whether you use the issue id or pull request id, you will need to specify `Issue` or `PullRequest` as the `content_type`.
   */
  content_id?: number;
  /**
   * **Required if you provide `content_id`**. The type of content you want to associate with this card. Use `Issue` when `content_id` is an issue id and use `PullRequest` when `content_id` is a pull request id.
   */
  content_type?: string;
};
type ProjectsCreateCardRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsMoveColumnEndpoint = {
  /**
   * column_id parameter
   */
  column_id: number;
  /**
   * Can be one of `first`, `last`, or `after:<column_id>`, where `<column_id>` is the `id` value of a column in the same project.
   */
  position: string;
};
type ProjectsMoveColumnRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsGetEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ProjectsGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsUpdateEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * The name of the project.
   */
  name?: string;
  /**
   * The description of the project.
   */
  body?: string;
  /**
   * State of the project. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * The permission level that determines whether all members of the project's organization can see and/or make changes to the project. Setting `organization_permission` is only available for organization projects. If an organization member belongs to a team with a higher level of access or is a collaborator with a higher level of access, their permission level is not lowered by `organization_permission`. For information on changing access for a team or collaborator, see [Add or update team project](https://developer.github.com/v3/teams/#add-or-update-team-project) or [Add user as a collaborator](https://developer.github.com/v3/projects/collaborators/#add-user-as-a-collaborator).
   *
   * **Note:** Updating a project's `organization_permission` requires `admin` access to the project.
   *
   * Can be one of:
   * \* `read` - Organization members can read, but not write to or administer this project.
   * \* `write` - Organization members can read and write, but not administer this project.
   * \* `admin` - Organization members can read, write and administer this project.
   * \* `none` - Organization members can only see this project if it is public.
   */
  organization_permission?: string;
  /**
   * Sets the visibility of a project board. Setting `private` is only available for organization and user projects. **Note:** Updating a project's visibility requires `admin` access to the project.
   *
   * Can be one of:
   * \* `false` - Anyone can see the project.
   * \* `true` - Only the user can view a project board created on a user account. Organization members with the appropriate `organization_permission` can see project boards in an organization account.
   */
  private?: boolean;
};
type ProjectsUpdateRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsDeleteEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
};
type ProjectsDeleteRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListCollaboratorsEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * Filters the collaborators by their affiliation. Can be one of:
   * \* `outside`: Outside collaborators of a project that are not a member of the project's organization.
   * \* `direct`: Collaborators with permissions to a project, regardless of organization membership status.
   * \* `all`: All collaborators the authenticated user can see.
   */
  affiliation?: "outside" | "direct" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ProjectsListCollaboratorsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsAddCollaboratorEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * username parameter
   */
  username: string;
  /**
   * The permission to grant the collaborator. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)." Can be one of:
   * \* `read` - can read, but not write to or administer this project.
   * \* `write` - can read and write, but not administer this project.
   * \* `admin` - can read, write and administer this project.
   */
  permission?: "read" | "write" | "admin";
};
type ProjectsAddCollaboratorRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsRemoveCollaboratorEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * username parameter
   */
  username: string;
};
type ProjectsRemoveCollaboratorRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsReviewUserPermissionLevelEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * username parameter
   */
  username: string;
};
type ProjectsReviewUserPermissionLevelRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListColumnsEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ProjectsListColumnsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsCreateColumnEndpoint = {
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * The name of the column.
   */
  name: string;
};
type ProjectsCreateColumnRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type RateLimitGetEndpoint = {};
type RateLimitGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsDeleteEndpoint = {
  /**
   * reaction_id parameter
   */
  reaction_id: number;
};
type ReactionsDeleteRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the repository.
   */
  name?: string;
  /**
   * A short description of the repository.
   */
  description?: string;
  /**
   * A URL with more information about the repository.
   */
  homepage?: string;
  /**
   * Either `true` to make the repository private or `false` to make it public. Creating private repositories requires a paid GitHub account. Default: `false`.
   * **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private. **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.
   */
  private?: boolean;
  /**
   * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `visibility` can also be `internal`. The `visibility` parameter overrides the `private` parameter when you use both along with the `nebula-preview` preview header.
   */
  visibility?: "public" | "private" | "visibility" | "internal";
  /**
   * Either `true` to enable issues for this repository or `false` to disable them.
   */
  has_issues?: boolean;
  /**
   * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
   */
  has_projects?: boolean;
  /**
   * Either `true` to enable the wiki for this repository or `false` to disable it.
   */
  has_wiki?: boolean;
  /**
   * Either `true` to make this repo available as a template repository or `false` to prevent it.
   */
  is_template?: boolean;
  /**
   * Updates the default branch for this repository.
   */
  default_branch?: string;
  /**
   * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
   */
  allow_squash_merge?: boolean;
  /**
   * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
   */
  allow_merge_commit?: boolean;
  /**
   * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
   */
  allow_rebase_merge?: boolean;
  /**
   * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
   */
  delete_branch_on_merge?: boolean;
  /**
   * `true` to archive this repository. **Note**: You cannot unarchive repositories through the API.
   */
  archived?: boolean;
};
type ReposUpdateRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposDeleteRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListAssigneesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListAssigneesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesCheckAssigneeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * assignee parameter
   */
  assignee: string;
};
type IssuesCheckAssigneeRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposEnableAutomatedSecurityFixesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposEnableAutomatedSecurityFixesRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDisableAutomatedSecurityFixesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposDisableAutomatedSecurityFixesRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListBranchesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Setting to `true` returns only protected branches. When set to `false`, only unprotected branches are returned. Omitting this parameter returns all branches.
   */
  protected?: boolean;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListBranchesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetBranchRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetBranchProtectionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetBranchProtectionRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateBranchProtectionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * Require status checks to pass before merging. Set to `null` to disable.
   */
  required_status_checks: ReposUpdateBranchProtectionParamsRequiredStatusChecks | null;
  /**
   * Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.
   */
  enforce_admins: boolean | null;
  /**
   * Require at least one approving review on a pull request, before merging. Set to `null` to disable.
   */
  required_pull_request_reviews: ReposUpdateBranchProtectionParamsRequiredPullRequestReviews | null;
  /**
   * Restrict who can push to the protected branch. User, app, and team `restrictions` are only available for organization-owned repositories. Set to `null` to disable.
   */
  restrictions: ReposUpdateBranchProtectionParamsRestrictions | null;
  /**
   * Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see "[Requiring a linear commit history](https://help.github.com/github/administering-a-repository/requiring-a-linear-commit-history)" in the GitHub Help documentation.
   */
  required_linear_history?: boolean;
  /**
   * Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation."
   */
  allow_force_pushes?: boolean | null;
  /**
   * Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation.
   */
  allow_deletions?: boolean;
};
type ReposUpdateBranchProtectionRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveBranchProtectionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposRemoveBranchProtectionRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchAdminEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetProtectedBranchAdminEnforcementRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchAdminEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposAddProtectedBranchAdminEnforcementRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchAdminEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposRemoveProtectedBranchAdminEnforcementRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchPullRequestReviewEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetProtectedBranchPullRequestReviewEnforcementRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateProtectedBranchPullRequestReviewEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
   */
  dismissal_restrictions?: ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions;
  /**
   * Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
   */
  dismiss_stale_reviews?: boolean;
  /**
   * Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) have reviewed.
   */
  require_code_owner_reviews?: boolean;
  /**
   * Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6.
   */
  required_approving_review_count?: number;
};
type ReposUpdateProtectedBranchPullRequestReviewEnforcementRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchPullRequestReviewEnforcementEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposRemoveProtectedBranchPullRequestReviewEnforcementRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchRequiredSignaturesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetProtectedBranchRequiredSignaturesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchRequiredSignaturesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposAddProtectedBranchRequiredSignaturesRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchRequiredSignaturesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposRemoveProtectedBranchRequiredSignaturesRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchRequiredStatusChecksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetProtectedBranchRequiredStatusChecksRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateProtectedBranchRequiredStatusChecksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * Require branches to be up to date before merging.
   */
  strict?: boolean;
  /**
   * The list of status checks to require in order to merge into this branch
   */
  contexts?: string[];
};
type ReposUpdateProtectedBranchRequiredStatusChecksRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchRequiredStatusChecksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposRemoveProtectedBranchRequiredStatusChecksRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListProtectedBranchRequiredStatusChecksContextsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposListProtectedBranchRequiredStatusChecksContextsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceProtectedBranchRequiredStatusChecksContextsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * contexts parameter
   */
  contexts: string[];
};
type ReposReplaceProtectedBranchRequiredStatusChecksContextsRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchRequiredStatusChecksContextsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * contexts parameter
   */
  contexts: string[];
};
type ReposAddProtectedBranchRequiredStatusChecksContextsRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchRequiredStatusChecksContextsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * contexts parameter
   */
  contexts: string[];
};
type ReposRemoveProtectedBranchRequiredStatusChecksContextsRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetProtectedBranchRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetProtectedBranchRestrictionsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposRemoveProtectedBranchRestrictionsRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetAppsWithAccessToProtectedBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetAppsWithAccessToProtectedBranchRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListAppsWithAccessToProtectedBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposListAppsWithAccessToProtectedBranchRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceProtectedBranchAppRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * apps parameter
   */
  apps: string[];
};
type ReposReplaceProtectedBranchAppRestrictionsRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchAppRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * apps parameter
   */
  apps: string[];
};
type ReposAddProtectedBranchAppRestrictionsRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchAppRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * apps parameter
   */
  apps: string[];
};
type ReposRemoveProtectedBranchAppRestrictionsRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetTeamsWithAccessToProtectedBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetTeamsWithAccessToProtectedBranchRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListProtectedBranchTeamRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposListProtectedBranchTeamRestrictionsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListTeamsWithAccessToProtectedBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposListTeamsWithAccessToProtectedBranchRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceProtectedBranchTeamRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * teams parameter
   */
  teams: string[];
};
type ReposReplaceProtectedBranchTeamRestrictionsRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchTeamRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * teams parameter
   */
  teams: string[];
};
type ReposAddProtectedBranchTeamRestrictionsRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchTeamRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * teams parameter
   */
  teams: string[];
};
type ReposRemoveProtectedBranchTeamRestrictionsRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetUsersWithAccessToProtectedBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposGetUsersWithAccessToProtectedBranchRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListProtectedBranchUserRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposListProtectedBranchUserRestrictionsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListUsersWithAccessToProtectedBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
};
type ReposListUsersWithAccessToProtectedBranchRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceProtectedBranchUserRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * users parameter
   */
  users: string[];
};
type ReposReplaceProtectedBranchUserRestrictionsRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddProtectedBranchUserRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * users parameter
   */
  users: string[];
};
type ReposAddProtectedBranchUserRestrictionsRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveProtectedBranchUserRestrictionsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * branch parameter
   */
  branch: string;
  /**
   * users parameter
   */
  users: string[];
};
type ReposRemoveProtectedBranchUserRestrictionsRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksCreateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the check. For example, "code-coverage".
   */
  name: string;
  /**
   * The SHA of the commit.
   */
  head_sha: string;
  /**
   * The URL of the integrator's site that has the full details of the check.
   */
  details_url?: string;
  /**
   * A reference for the run on the integrator's system.
   */
  external_id?: string;
  /**
   * The current status. Can be one of `queued`, `in_progress`, or `completed`.
   */
  status?: "queued" | "in_progress" | "completed";
  /**
   * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  started_at?: string;
  /**
   * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`. When the conclusion is `action_required`, additional details should be provided on the site specified by `details_url`.
   * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`.
   */
  conclusion?:
    | "success"
    | "failure"
    | "neutral"
    | "cancelled"
    | "timed_out"
    | "action_required";
  /**
   * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  completed_at?: string;
  /**
   * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object) description.
   */
  output?: ChecksCreateParamsOutput;
  /**
   * Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://developer.github.com/v3/activity/events/types/#checkrunevent) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)." To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
   */
  actions?: ChecksCreateParamsActions[];
};
type ChecksCreateRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksUpdateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_run_id parameter
   */
  check_run_id: number;
  /**
   * The name of the check. For example, "code-coverage".
   */
  name?: string;
  /**
   * The URL of the integrator's site that has the full details of the check.
   */
  details_url?: string;
  /**
   * A reference for the run on the integrator's system.
   */
  external_id?: string;
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  started_at?: string;
  /**
   * The current status. Can be one of `queued`, `in_progress`, or `completed`.
   */
  status?: "queued" | "in_progress" | "completed";
  /**
   * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`.
   * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`.
   */
  conclusion?:
    | "success"
    | "failure"
    | "neutral"
    | "cancelled"
    | "timed_out"
    | "action_required";
  /**
   * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  completed_at?: string;
  /**
   * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object-1) description.
   */
  output?: ChecksUpdateParamsOutput;
  /**
   * Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
   */
  actions?: ChecksUpdateParamsActions[];
};
type ChecksUpdateRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksGetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_run_id parameter
   */
  check_run_id: number;
};
type ChecksGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksListAnnotationsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_run_id parameter
   */
  check_run_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ChecksListAnnotationsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksCreateSuiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The sha of the head commit.
   */
  head_sha: string;
};
type ChecksCreateSuiteRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksSetSuitesPreferencesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default. See the [`auto_trigger_checks` object](https://developer.github.com/v3/checks/suites/#auto_trigger_checks-object) description for details.
   */
  auto_trigger_checks?: ChecksSetSuitesPreferencesParamsAutoTriggerChecks[];
};
type ChecksSetSuitesPreferencesRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksGetSuiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_suite_id parameter
   */
  check_suite_id: number;
};
type ChecksGetSuiteRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksListForSuiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_suite_id parameter
   */
  check_suite_id: number;
  /**
   * Returns check runs with the specified `name`.
   */
  check_name?: string;
  /**
   * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
   */
  status?: "queued" | "in_progress" | "completed";
  /**
   * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
   */
  filter?: "latest" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ChecksListForSuiteRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksRerequestSuiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * check_suite_id parameter
   */
  check_suite_id: number;
};
type ChecksRerequestSuiteRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListCollaboratorsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Filter collaborators returned by their affiliation. Can be one of:
   * \* `outside`: All outside collaborators of an organization-owned repository.
   * \* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.
   * \* `all`: All collaborators the authenticated user can see.
   */
  affiliation?: "outside" | "direct" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListCollaboratorsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCheckCollaboratorEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * username parameter
   */
  username: string;
};
type ReposCheckCollaboratorRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddCollaboratorEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * username parameter
   */
  username: string;
  /**
   * The permission to grant the collaborator. **Only valid on organization-owned repositories.** Can be one of:
   * \* `pull` - can pull, but not push to or administer this repository.
   * \* `push` - can pull and push, but not administer this repository.
   * \* `admin` - can pull, push and administer this repository.
   */
  permission?: "pull" | "push" | "admin";
};
type ReposAddCollaboratorRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveCollaboratorEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * username parameter
   */
  username: string;
};
type ReposRemoveCollaboratorRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCollaboratorPermissionLevelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * username parameter
   */
  username: string;
};
type ReposGetCollaboratorPermissionLevelRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListCommitCommentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListCommitCommentsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};
type ReposGetCommitCommentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The contents of the comment
   */
  body: string;
};
type ReposUpdateCommitCommentRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};
type ReposDeleteCommitCommentRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a commit comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForCommitCommentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the commit comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForCommitCommentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListCommitsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * SHA or branch to start listing commits from. Default: the repository’s default branch (usually `master`).
   */
  sha?: string;
  /**
   * Only commits containing this file path will be returned.
   */
  path?: string;
  /**
   * GitHub login or email address by which to filter by commit author.
   */
  author?: string;
  /**
   * Only commits after this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Only commits before this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  until?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListCommitsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListBranchesForHeadCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
};
type ReposListBranchesForHeadCommitRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListCommentsForCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListCommentsForCommitRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateCommitCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
  /**
   * The contents of the comment.
   */
  body: string;
  /**
   * Relative path of the file to comment on.
   */
  path?: string;
  /**
   * Line index in the diff to comment on.
   */
  position?: number;
  /**
   * **Deprecated**. Use **position** parameter instead. Line number in the file to comment on.
   */
  line?: number;
};
type ReposCreateCommitCommentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListPullRequestsAssociatedWithCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListPullRequestsAssociatedWithCommitRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
};
type ReposGetCommitRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksListForRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * Returns check runs with the specified `name`.
   */
  check_name?: string;
  /**
   * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
   */
  status?: "queued" | "in_progress" | "completed";
  /**
   * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
   */
  filter?: "latest" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ChecksListForRefRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ChecksListSuitesForRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * Filters check suites by GitHub App `id`.
   */
  app_id?: number;
  /**
   * Filters checks suites by the name of the [check run](https://developer.github.com/v3/checks/runs/).
   */
  check_name?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ChecksListSuitesForRefRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCombinedStatusForRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
};
type ReposGetCombinedStatusForRefRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListStatusesForRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListStatusesForRefRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type CodesOfConductGetForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type CodesOfConductGetForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRetrieveCommunityProfileMetricsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposRetrieveCommunityProfileMetricsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCompareCommitsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * base parameter
   */
  base: string;
  /**
   * head parameter
   */
  head: string;
};
type ReposCompareCommitsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetContentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * path parameter
   */
  path: string;
  /**
   * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
   */
  ref?: string;
};
type ReposGetContentsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateOrUpdateFileEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * path parameter
   */
  path: string;
  /**
   * The commit message.
   */
  message: string;
  /**
   * The new file content, using Base64 encoding.
   */
  content: string;
  /**
   * **Required if you are updating a file**. The blob SHA of the file being replaced.
   */
  sha?: string;
  /**
   * The branch name. Default: the repository’s default branch (usually `master`)
   */
  branch?: string;
  /**
   * The person that committed the file. Default: the authenticated user.
   */
  committer?: ReposCreateOrUpdateFileParamsCommitter;
  /**
   * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
   */
  author?: ReposCreateOrUpdateFileParamsAuthor;
};
type ReposCreateOrUpdateFileRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateFileEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * path parameter
   */
  path: string;
  /**
   * The commit message.
   */
  message: string;
  /**
   * The new file content, using Base64 encoding.
   */
  content: string;
  /**
   * **Required if you are updating a file**. The blob SHA of the file being replaced.
   */
  sha?: string;
  /**
   * The branch name. Default: the repository’s default branch (usually `master`)
   */
  branch?: string;
  /**
   * The person that committed the file. Default: the authenticated user.
   */
  committer?: ReposCreateFileParamsCommitter;
  /**
   * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
   */
  author?: ReposCreateFileParamsAuthor;
};
type ReposCreateFileRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateFileEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * path parameter
   */
  path: string;
  /**
   * The commit message.
   */
  message: string;
  /**
   * The new file content, using Base64 encoding.
   */
  content: string;
  /**
   * **Required if you are updating a file**. The blob SHA of the file being replaced.
   */
  sha?: string;
  /**
   * The branch name. Default: the repository’s default branch (usually `master`)
   */
  branch?: string;
  /**
   * The person that committed the file. Default: the authenticated user.
   */
  committer?: ReposUpdateFileParamsCommitter;
  /**
   * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
   */
  author?: ReposUpdateFileParamsAuthor;
};
type ReposUpdateFileRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteFileEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * path parameter
   */
  path: string;
  /**
   * The commit message.
   */
  message: string;
  /**
   * The blob SHA of the file being replaced.
   */
  sha: string;
  /**
   * The branch name. Default: the repository’s default branch (usually `master`)
   */
  branch?: string;
  /**
   * object containing information about the committer.
   */
  committer?: ReposDeleteFileParamsCommitter;
  /**
   * object containing information about the author.
   */
  author?: ReposDeleteFileParamsAuthor;
};
type ReposDeleteFileRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListContributorsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Set to `1` or `true` to include anonymous contributors in results.
   */
  anon?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListContributorsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListDeploymentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The SHA recorded at creation time.
   */
  sha?: string;
  /**
   * The name of the ref. This can be a branch, tag, or SHA.
   */
  ref?: string;
  /**
   * The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
   */
  task?: string;
  /**
   * The name of the environment that was deployed to (e.g., `staging` or `production`).
   */
  environment?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListDeploymentsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateDeploymentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The ref to deploy. This can be a branch, tag, or SHA.
   */
  ref: string;
  /**
   * Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).
   */
  task?: string;
  /**
   * Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.
   */
  auto_merge?: boolean;
  /**
   * The [status](https://developer.github.com/v3/repos/statuses/) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.
   */
  required_contexts?: string[];
  /**
   * JSON payload with extra information about the deployment.
   */
  payload?: string;
  /**
   * Name for the target deployment environment (e.g., `production`, `staging`, `qa`).
   */
  environment?: string;
  /**
   * Short description of the deployment.
   */
  description?: string;
  /**
   * Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  transient_environment?: boolean;
  /**
   * Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  production_environment?: boolean;
};
type ReposCreateDeploymentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetDeploymentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * deployment_id parameter
   */
  deployment_id: number;
};
type ReposGetDeploymentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListDeploymentStatusesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * deployment_id parameter
   */
  deployment_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListDeploymentStatusesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateDeploymentStatusEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * deployment_id parameter
   */
  deployment_id: number;
  /**
   * The state of the status. Can be one of `error`, `failure`, `inactive`, `in_progress`, `queued` `pending`, or `success`. **Note:** To use the `inactive` state, you must provide the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. To use the `in_progress` and `queued` states, you must provide the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
   */
  state:
    | "error"
    | "failure"
    | "inactive"
    | "in_progress"
    | "queued"
    | "pending"
    | "success";
  /**
   * The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.
   */
  target_url?: string;
  /**
   * The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `""`
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  log_url?: string;
  /**
   * A short description of the status. The maximum description length is 140 characters.
   */
  description?: string;
  /**
   * Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. **Note:** This parameter requires you to use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
   */
  environment?: "production" | "staging" | "qa";
  /**
   * Sets the URL for accessing your environment. Default: `""`
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  environment_url?: string;
  /**
   * Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`
   * **Note:** To add an `inactive` status to `production` environments, you must use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
   * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
   */
  auto_inactive?: boolean;
};
type ReposCreateDeploymentStatusRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetDeploymentStatusEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * deployment_id parameter
   */
  deployment_id: number;
  /**
   * status_id parameter
   */
  status_id: number;
};
type ReposGetDeploymentStatusRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateDispatchEventEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * **Required:** A custom webhook event name.
   */
  event_type?: string;
  /**
   * JSON payload with extra information about the webhook event that your action or worklow may use.
   */
  client_payload?: ReposCreateDispatchEventParamsClientPayload;
};
type ReposCreateDispatchEventRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListDownloadsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListDownloadsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetDownloadEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * download_id parameter
   */
  download_id: number;
};
type ReposGetDownloadRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteDownloadEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * download_id parameter
   */
  download_id: number;
};
type ReposDeleteDownloadRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListRepoEventsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListRepoEventsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListForksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The sort order. Can be either `newest`, `oldest`, or `stargazers`.
   */
  sort?: "newest" | "oldest" | "stargazers";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListForksRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateForkEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Optional parameter to specify the organization name if forking into an organization.
   */
  organization?: string;
};
type ReposCreateForkRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateBlobEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The new blob's content.
   */
  content: string;
  /**
   * The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
   */
  encoding?: string;
};
type GitCreateBlobRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetBlobEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * file_sha parameter
   */
  file_sha: string;
};
type GitGetBlobRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The commit message
   */
  message: string;
  /**
   * The SHA of the tree object this commit points to
   */
  tree: string;
  /**
   * The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
   */
  parents: string[];
  /**
   * Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
   */
  author?: GitCreateCommitParamsAuthor;
  /**
   * Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
   */
  committer?: GitCreateCommitParamsCommitter;
  /**
   * The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
   */
  signature?: string;
};
type GitCreateCommitRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetCommitEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * commit_sha parameter
   */
  commit_sha: string;
};
type GitGetCommitRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitListMatchingRefsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type GitListMatchingRefsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
};
type GitGetRefRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
   */
  ref: string;
  /**
   * The SHA1 value for this reference.
   */
  sha: string;
};
type GitCreateRefRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitUpdateRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
  /**
   * The SHA1 value to set this reference to
   */
  sha: string;
  /**
   * Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
   */
  force?: boolean;
};
type GitUpdateRefRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitDeleteRefEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * ref parameter
   */
  ref: string;
};
type GitDeleteRefRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateTagEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The tag's name. This is typically a version (e.g., "v0.0.1").
   */
  tag: string;
  /**
   * The tag message.
   */
  message: string;
  /**
   * The SHA of the git object this is tagging.
   */
  object: string;
  /**
   * The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
   */
  type: "commit" | "tree" | "blob";
  /**
   * An object with information about the individual creating the tag.
   */
  tagger?: GitCreateTagParamsTagger;
};
type GitCreateTagRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetTagEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * tag_sha parameter
   */
  tag_sha: string;
};
type GitGetTagRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitCreateTreeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
   */
  tree: GitCreateTreeParamsTree[];
  /**
   * The SHA1 of the tree you want to update with new data. If you don't set this, the commit will be created on top of everything; however, it will only contain your change, the rest of your files will show up as deleted.
   */
  base_tree?: string;
};
type GitCreateTreeRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GitGetTreeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * tree_sha parameter
   */
  tree_sha: string;
  /**
   * recursive parameter
   */
  recursive?: "1";
};
type GitGetTreeRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListHooksEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListHooksRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.
   */
  name?: string;
  /**
   * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
   */
  config: ReposCreateHookParamsConfig;
  /**
   * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
   */
  events?: string[];
  /**
   * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
   */
  active?: boolean;
};
type ReposCreateHookRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};
type ReposGetHookRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
  /**
   * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
   */
  config?: ReposUpdateHookParamsConfig;
  /**
   * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for. This replaces the entire array of events.
   */
  events?: string[];
  /**
   * Determines a list of events to be added to the list of events that the Hook triggers for.
   */
  add_events?: string[];
  /**
   * Determines a list of events to be removed from the list of events that the Hook triggers for.
   */
  remove_events?: string[];
  /**
   * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
   */
  active?: boolean;
};
type ReposUpdateHookRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};
type ReposDeleteHookRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposPingHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};
type ReposPingHookRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposTestPushHookEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * hook_id parameter
   */
  hook_id: number;
};
type ReposTestPushHookRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsStartImportEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The URL of the originating repository.
   */
  vcs_url: string;
  /**
   * The originating VCS type. Can be one of `subversion`, `git`, `mercurial`, or `tfvc`. Please be aware that without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
   */
  vcs?: "subversion" | "git" | "mercurial" | "tfvc";
  /**
   * If authentication is required, the username to provide to `vcs_url`.
   */
  vcs_username?: string;
  /**
   * If authentication is required, the password to provide to `vcs_url`.
   */
  vcs_password?: string;
  /**
   * For a tfvc import, the name of the project that is being imported.
   */
  tfvc_project?: string;
};
type MigrationsStartImportRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetImportProgressEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type MigrationsGetImportProgressRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsUpdateImportEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The username to provide to the originating repository.
   */
  vcs_username?: string;
  /**
   * The password to provide to the originating repository.
   */
  vcs_password?: string;
};
type MigrationsUpdateImportRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsCancelImportEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type MigrationsCancelImportRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetCommitAuthorsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Only authors found after this id are returned. Provide the highest author ID you've seen so far. New authors may be added to the list at any point while the importer is performing the `raw` step.
   */
  since?: string;
};
type MigrationsGetCommitAuthorsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsMapCommitAuthorEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * author_id parameter
   */
  author_id: number;
  /**
   * The new Git author email.
   */
  email?: string;
  /**
   * The new Git author name.
   */
  name?: string;
};
type MigrationsMapCommitAuthorRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetLargeFilesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type MigrationsGetLargeFilesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsSetLfsPreferenceEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Can be one of `opt_in` (large files will be stored using Git LFS) or `opt_out` (large files will be removed during the import).
   */
  use_lfs: "opt_in" | "opt_out";
};
type MigrationsSetLfsPreferenceRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetRepoInstallationEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type AppsGetRepoInstallationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsFindRepoInstallationEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type AppsFindRepoInstallationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsGetRestrictionsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type InteractionsGetRestrictionsForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsAddOrUpdateRestrictionsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Specifies the group of GitHub users who can comment, open issues, or create pull requests for the given repository. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
   */
  limit: "existing_users" | "contributors_only" | "collaborators_only";
};
type InteractionsAddOrUpdateRestrictionsForRepoRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type InteractionsRemoveRestrictionsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type InteractionsRemoveRestrictionsForRepoRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListInvitationsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListInvitationsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteInvitationEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * invitation_id parameter
   */
  invitation_id: number;
};
type ReposDeleteInvitationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateInvitationEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * invitation_id parameter
   */
  invitation_id: number;
  /**
   * The permissions that the associated user will have on the repository. Valid values are `read`, `write`, and `admin`.
   */
  permissions?: "read" | "write" | "admin";
};
type ReposUpdateInvitationRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
   */
  milestone?: string;
  /**
   * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
   */
  assignee?: string;
  /**
   * The user that created the issue.
   */
  creator?: string;
  /**
   * A user that's mentioned in the issue.
   */
  mentioned?: string;
  /**
   * A list of comma separated label names. Example: `bug,ui,@high`
   */
  labels?: string;
  /**
   * What to sort results by. Can be either `created`, `updated`, `comments`.
   */
  sort?: "created" | "updated" | "comments";
  /**
   * The direction of the sort. Can be either `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesCreateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The title of the issue.
   */
  title: string;
  /**
   * The contents of the issue.
   */
  body?: string;
  /**
   * Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_
   */
  assignee?: string;
  /**
   * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
   */
  milestone?: number;
  /**
   * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
   */
  labels?: string[];
  /**
   * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
   */
  assignees?: string[];
};
type IssuesCreateRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListCommentsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Either `created` or `updated`.
   */
  sort?: "created" | "updated";
  /**
   * Either `asc` or `desc`. Ignored without the `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
};
type IssuesListCommentsForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesGetCommentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesUpdateCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The contents of the comment.
   */
  body: string;
};
type IssuesUpdateCommentRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesDeleteCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};
type IssuesDeleteCommentRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForIssueCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForIssueCommentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForIssueCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForIssueCommentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListEventsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListEventsForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetEventEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * event_id parameter
   */
  event_id: number;
};
type IssuesGetEventRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
};
type IssuesGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesUpdateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The title of the issue.
   */
  title?: string;
  /**
   * The contents of the issue.
   */
  body?: string;
  /**
   * Login for the user that this issue should be assigned to. **This field is deprecated.**
   */
  assignee?: string;
  /**
   * State of the issue. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
   */
  milestone?: number | null;
  /**
   * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
   */
  labels?: string[];
  /**
   * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
   */
  assignees?: string[];
};
type IssuesUpdateRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesAddAssigneesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
   */
  assignees?: string[];
};
type IssuesAddAssigneesRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesRemoveAssigneesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
   */
  assignees?: string[];
};
type IssuesRemoveAssigneesRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListCommentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListCommentsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesCreateCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The contents of the comment.
   */
  body: string;
};
type IssuesCreateCommentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListEventsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListEventsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListLabelsOnIssueEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListLabelsOnIssueRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesAddLabelsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
   */
  labels: string[];
};
type IssuesAddLabelsRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesReplaceLabelsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
   */
  labels?: string[];
};
type IssuesReplaceLabelsRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesRemoveLabelsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
};
type IssuesRemoveLabelsRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesRemoveLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * name parameter
   */
  name: string;
};
type IssuesRemoveLabelRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesLockEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:
   * \* `off-topic`
   * \* `too heated`
   * \* `resolved`
   * \* `spam`
   */
  lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";
};
type IssuesLockRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesUnlockEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
};
type IssuesUnlockRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForIssueEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForIssueRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForIssueEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForIssueRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListEventsForTimelineEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * issue_number parameter
   */
  issue_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListEventsForTimelineRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListDeployKeysEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListDeployKeysRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAddDeployKeyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * A name for the key.
   */
  title?: string;
  /**
   * The contents of the key.
   */
  key: string;
  /**
   * If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.
   *
   * Deploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see "[Repository permission levels for an organization](https://help.github.com/articles/repository-permission-levels-for-an-organization/)" and "[Permission levels for a user account repository](https://help.github.com/articles/permission-levels-for-a-user-account-repository/)."
   */
  read_only?: boolean;
};
type ReposAddDeployKeyRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetDeployKeyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * key_id parameter
   */
  key_id: number;
};
type ReposGetDeployKeyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRemoveDeployKeyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * key_id parameter
   */
  key_id: number;
};
type ReposRemoveDeployKeyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListLabelsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListLabelsForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesCreateLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
   */
  name: string;
  /**
   * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
   */
  color: string;
  /**
   * A short description of the label.
   */
  description?: string;
};
type IssuesCreateLabelRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * name parameter
   */
  name: string;
};
type IssuesGetLabelRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesUpdateLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * name parameter
   */
  name: string;
  /**
   * The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
   */
  new_name?: string;
  /**
   * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
   */
  color?: string;
  /**
   * A short description of the label.
   */
  description?: string;
};
type IssuesUpdateLabelRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesDeleteLabelEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * name parameter
   */
  name: string;
};
type IssuesDeleteLabelRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListLanguagesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposListLanguagesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type LicensesGetForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type LicensesGetForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposMergeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the base branch that the head will be merged into.
   */
  base: string;
  /**
   * The head to merge. This can be a branch name or a commit SHA1.
   */
  head: string;
  /**
   * Commit message to use for the merge commit. If omitted, a default message will be used.
   */
  commit_message?: string;
};
type ReposMergeRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListMilestonesForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The state of the milestone. Either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * What to sort results by. Either `due_on` or `completeness`.
   */
  sort?: "due_on" | "completeness";
  /**
   * The direction of the sort. Either `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListMilestonesForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesCreateMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The title of the milestone.
   */
  title: string;
  /**
   * The state of the milestone. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * A description of the milestone.
   */
  description?: string;
  /**
   * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  due_on?: string;
};
type IssuesCreateMilestoneRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesGetMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * milestone_number parameter
   */
  milestone_number: number;
};
type IssuesGetMilestoneRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesUpdateMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * milestone_number parameter
   */
  milestone_number: number;
  /**
   * The title of the milestone.
   */
  title?: string;
  /**
   * The state of the milestone. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * A description of the milestone.
   */
  description?: string;
  /**
   * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  due_on?: string;
};
type IssuesUpdateMilestoneRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesDeleteMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * milestone_number parameter
   */
  milestone_number: number;
};
type IssuesDeleteMilestoneRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListLabelsForMilestoneEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * milestone_number parameter
   */
  milestone_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListLabelsForMilestoneRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListNotificationsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * If `true`, show notifications marked as read.
   */
  all?: boolean;
  /**
   * If `true`, only shows notifications in which the user is directly participating or mentioned.
   */
  participating?: boolean;
  /**
   * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  before?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListNotificationsForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityMarkNotificationsAsReadForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Describes the last point that notifications were checked. Anything updated since this time will not be updated. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
   */
  last_read_at?: string;
};
type ActivityMarkNotificationsAsReadForRepoRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetPagesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetPagesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposEnablePagesSiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * source parameter
   */
  source?: ReposEnablePagesSiteParamsSource;
};
type ReposEnablePagesSiteRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDisablePagesSiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposDisablePagesSiteRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateInformationAboutPagesSiteEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://help.github.com/articles/using-a-custom-domain-with-github-pages/)."
   */
  cname?: string;
  /**
   * Update the source for the repository. Must include the branch name, and may optionally specify the subdirectory `/docs`. Possible values are `"gh-pages"`, `"master"`, and `"master /docs"`.
   */
  source?: '"gh-pages"' | '"master"' | '"master /docs"';
};
type ReposUpdateInformationAboutPagesSiteRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposRequestPageBuildEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposRequestPageBuildRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListPagesBuildsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListPagesBuildsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetLatestPagesBuildEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetLatestPagesBuildRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetPagesBuildEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * build_id parameter
   */
  build_id: number;
};
type ReposGetPagesBuildRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ProjectsListForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsCreateForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the project.
   */
  name: string;
  /**
   * The description of the project.
   */
  body?: string;
};
type ProjectsCreateForRepoRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Either `open`, `closed`, or `all` to filter by state.
   */
  state?: "open" | "closed" | "all";
  /**
   * Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
   */
  head?: string;
  /**
   * Filter pulls by base branch name. Example: `gh-pages`.
   */
  base?: string;
  /**
   * What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
   */
  sort?: "created" | "updated" | "popularity" | "long-running";
  /**
   * The direction of the sort. Can be either `asc` or `desc`. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type PullsListRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The title of the new pull request.
   */
  title: string;
  /**
   * The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
   */
  head: string;
  /**
   * The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
   */
  base: string;
  /**
   * The contents of the pull request.
   */
  body?: string;
  /**
   * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
   */
  maintainer_can_modify?: boolean;
  /**
   * Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://help.github.com/en/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.
   */
  draft?: boolean;
};
type PullsCreateRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListCommentsForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Can be either `created` or `updated` comments.
   */
  sort?: "created" | "updated";
  /**
   * Can be either `asc` or `desc`. Ignored without `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type PullsListCommentsForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsGetCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};
type PullsGetCommentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsUpdateCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The text of the reply to the review comment.
   */
  body: string;
};
type PullsUpdateCommentRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsDeleteCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
};
type PullsDeleteCommentRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForPullRequestReviewCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForPullRequestReviewCommentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForPullRequestReviewCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the pull request review comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForPullRequestReviewCommentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsGetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
};
type PullsGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsUpdateEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * The title of the pull request.
   */
  title?: string;
  /**
   * The contents of the pull request.
   */
  body?: string;
  /**
   * State of this Pull Request. Either `open` or `closed`.
   */
  state?: "open" | "closed";
  /**
   * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
   */
  base?: string;
  /**
   * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
   */
  maintainer_can_modify?: boolean;
};
type PullsUpdateRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListCommentsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Can be either `created` or `updated` comments.
   */
  sort?: "created" | "updated";
  /**
   * Can be either `asc` or `desc`. Ignored without `sort` parameter.
   */
  direction?: "asc" | "desc";
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type PullsListCommentsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateCommentEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * The text of the review comment.
   */
  body: string;
  /**
   * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
   */
  commit_id: string;
  /**
   * The relative path to the file that necessitates a comment.
   */
  path: string;
  /**
   * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
   */
  position?: number;
  /**
   * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
   */
  side?: "LEFT" | "RIGHT";
  /**
   * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
   */
  line?: number;
  /**
   * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
   */
  start_line?: number;
  /**
   * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
   */
  start_side?: "LEFT" | "RIGHT" | "side";
};
type PullsCreateCommentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateCommentReplyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * The text of the review comment.
   */
  body: string;
  /**
   * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
   */
  commit_id: string;
  /**
   * The relative path to the file that necessitates a comment.
   */
  path: string;
  /**
   * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
   */
  position?: number;
  /**
   * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
   */
  side?: "LEFT" | "RIGHT";
  /**
   * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
   */
  line?: number;
  /**
   * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
   */
  start_line?: number;
  /**
   * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
   */
  start_side?: "LEFT" | "RIGHT" | "side";
};
type PullsCreateCommentReplyRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateReviewCommentReplyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * comment_id parameter
   */
  comment_id: number;
  /**
   * The text of the review comment.
   */
  body: string;
};
type PullsCreateReviewCommentReplyRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListCommitsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type PullsListCommitsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListFilesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type PullsListFilesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCheckIfMergedEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
};
type PullsCheckIfMergedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsMergeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Title for the automatic commit message.
   */
  commit_title?: string;
  /**
   * Extra detail to append to automatic commit message.
   */
  commit_message?: string;
  /**
   * SHA that pull request head must match to allow merge.
   */
  sha?: string;
  /**
   * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
   */
  merge_method?: "merge" | "squash" | "rebase";
};
type PullsMergeRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListReviewRequestsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type PullsListReviewRequestsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateReviewRequestEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * An array of user `login`s that will be requested.
   */
  reviewers?: string[];
  /**
   * An array of team `slug`s that will be requested.
   */
  team_reviewers?: string[];
};
type PullsCreateReviewRequestRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsDeleteReviewRequestEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * An array of user `login`s that will be removed.
   */
  reviewers?: string[];
  /**
   * An array of team `slug`s that will be removed.
   */
  team_reviewers?: string[];
};
type PullsDeleteReviewRequestRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsListReviewsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type PullsListReviewsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsCreateReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
   */
  commit_id?: string;
  /**
   * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
   */
  body?: string;
  /**
   * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review) when you are ready.
   */
  event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
  /**
   * Use the following table to specify the location, destination, and contents of the draft review comment.
   */
  comments?: PullsCreateReviewParamsComments[];
};
type PullsCreateReviewRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsGetReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
};
type PullsGetReviewRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsDeletePendingReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
};
type PullsDeletePendingReviewRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsUpdateReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
  /**
   * The body text of the pull request review.
   */
  body: string;
};
type PullsUpdateReviewRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsGetCommentsForReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type PullsGetCommentsForReviewRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsDismissReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
  /**
   * The message for the pull request review dismissal
   */
  message: string;
};
type PullsDismissReviewRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsSubmitReviewEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * review_id parameter
   */
  review_id: number;
  /**
   * The body text of the pull request review
   */
  body?: string;
  /**
   * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
   */
  event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
};
type PullsSubmitReviewRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type PullsUpdateBranchEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * pull_number parameter
   */
  pull_number: number;
  /**
   * The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the "[List commits on a repository](https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository)" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
   */
  expected_head_sha?: string;
};
type PullsUpdateBranchRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetReadmeEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
   */
  ref?: string;
};
type ReposGetReadmeRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListReleasesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListReleasesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The name of the tag.
   */
  tag_name: string;
  /**
   * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
   */
  target_commitish?: string;
  /**
   * The name of the release.
   */
  name?: string;
  /**
   * Text describing the contents of the tag.
   */
  body?: string;
  /**
   * `true` to create a draft (unpublished) release, `false` to create a published one.
   */
  draft?: boolean;
  /**
   * `true` to identify the release as a prerelease. `false` to identify the release as a full release.
   */
  prerelease?: boolean;
};
type ReposCreateReleaseRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetReleaseAssetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * asset_id parameter
   */
  asset_id: number;
};
type ReposGetReleaseAssetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateReleaseAssetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * asset_id parameter
   */
  asset_id: number;
  /**
   * The file name of the asset.
   */
  name?: string;
  /**
   * An alternate short description of the asset. Used in place of the filename.
   */
  label?: string;
};
type ReposUpdateReleaseAssetRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteReleaseAssetEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * asset_id parameter
   */
  asset_id: number;
};
type ReposDeleteReleaseAssetRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetLatestReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetLatestReleaseRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetReleaseByTagEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * tag parameter
   */
  tag: string;
};
type ReposGetReleaseByTagRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * release_id parameter
   */
  release_id: number;
};
type ReposGetReleaseRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposUpdateReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * release_id parameter
   */
  release_id: number;
  /**
   * The name of the tag.
   */
  tag_name?: string;
  /**
   * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
   */
  target_commitish?: string;
  /**
   * The name of the release.
   */
  name?: string;
  /**
   * Text describing the contents of the tag.
   */
  body?: string;
  /**
   * `true` makes the release a draft, and `false` publishes the release.
   */
  draft?: boolean;
  /**
   * `true` to identify the release as a prerelease, `false` to identify the release as a full release.
   */
  prerelease?: boolean;
};
type ReposUpdateReleaseRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeleteReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * release_id parameter
   */
  release_id: number;
};
type ReposDeleteReleaseRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListAssetsForReleaseEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * release_id parameter
   */
  release_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListAssetsForReleaseRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListStargazersForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListStargazersForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCodeFrequencyStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetCodeFrequencyStatsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetCommitActivityStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetCommitActivityStatsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetContributorsStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetContributorsStatsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetParticipationStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetParticipationStatsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetPunchCardStatsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetPunchCardStatsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateStatusEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * sha parameter
   */
  sha: string;
  /**
   * The state of the status. Can be one of `error`, `failure`, `pending`, or `success`.
   */
  state: "error" | "failure" | "pending" | "success";
  /**
   * The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.
   * For example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:
   * `http://ci.example.com/user/repo/build/sha`
   */
  target_url?: string;
  /**
   * A short description of the status.
   */
  description?: string;
  /**
   * A string label to differentiate this status from the status of other systems.
   */
  context?: string;
};
type ReposCreateStatusRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListWatchersForRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListWatchersForRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityGetRepoSubscriptionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ActivityGetRepoSubscriptionRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivitySetRepoSubscriptionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Determines if notifications should be received from this repository.
   */
  subscribed?: boolean;
  /**
   * Determines if all notifications should be blocked from this repository.
   */
  ignored?: boolean;
};
type ActivitySetRepoSubscriptionRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityDeleteRepoSubscriptionEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ActivityDeleteRepoSubscriptionRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListTagsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListTagsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListTeamsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListTeamsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListTopicsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposListTopicsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposReplaceTopicsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * An array of topics to add to the repository. Pass one or more topics to _replace_ the set of existing topics. Send an empty array (`[]`) to clear all topics from the repository. **Note:** Topic `names` cannot contain uppercase letters.
   */
  names: string[];
};
type ReposReplaceTopicsRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetClonesEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Must be one of: `day`, `week`.
   */
  per?: "day" | "week";
};
type ReposGetClonesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetTopPathsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetTopPathsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetTopReferrersEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposGetTopReferrersRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetViewsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * Must be one of: `day`, `week`.
   */
  per?: "day" | "week";
};
type ReposGetViewsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposTransferEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * **Required:** The username or organization name the repository will be transferred to.
   */
  new_owner?: string;
  /**
   * ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
   */
  team_ids?: number[];
};
type ReposTransferRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCheckVulnerabilityAlertsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposCheckVulnerabilityAlertsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposEnableVulnerabilityAlertsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposEnableVulnerabilityAlertsRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDisableVulnerabilityAlertsEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ReposDisableVulnerabilityAlertsRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposGetArchiveLinkEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * archive_format parameter
   */
  archive_format: string;
  /**
   * ref parameter
   */
  ref: string;
};
type ReposGetArchiveLinkRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateUsingTemplateEndpoint = {
  /**
   * template_owner parameter
   */
  template_owner: string;
  /**
   * template_repo parameter
   */
  template_repo: string;
  /**
   * The organization or person who will own the new repository. To create a new repository in an organization, the authenticated user must be a member of the specified organization.
   */
  owner?: string;
  /**
   * The name of the new repository.
   */
  name: string;
  /**
   * A short description of the new repository.
   */
  description?: string;
  /**
   * Either `true` to create a new private repository or `false` to create a new public one.
   */
  private?: boolean;
};
type ReposCreateUsingTemplateRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListPublicEndpoint = {
  /**
   * The integer ID of the last Repository that you've seen.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListPublicRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimListProvisionedIdentitiesEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * Used for pagination: the index of the first result to return.
   */
  startIndex?: number;
  /**
   * Used for pagination: the number of results to return.
   */
  count?: number;
  /**
   * Filters results using the equals query parameter operator (`eq`). You can filter results that are equal to `id`, `userName`, `emails`, and `external_id`. For example, to search for an identity with the `userName` Octocat, you would use this query: `?filter=userName%20eq%20\"Octocat\"`.
   */
  filter?: string;
};
type ScimListProvisionedIdentitiesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimProvisionAndInviteUsersEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type ScimProvisionAndInviteUsersRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimProvisionInviteUsersEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type ScimProvisionInviteUsersRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimGetProvisioningDetailsForUserEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * scim_user_id parameter
   */
  scim_user_id: number;
};
type ScimGetProvisioningDetailsForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimReplaceProvisionedUserInformationEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * scim_user_id parameter
   */
  scim_user_id: number;
};
type ScimReplaceProvisionedUserInformationRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimUpdateProvisionedOrgMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * scim_user_id parameter
   */
  scim_user_id: number;
};
type ScimUpdateProvisionedOrgMembershipRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimUpdateUserAttributeEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * scim_user_id parameter
   */
  scim_user_id: number;
};
type ScimUpdateUserAttributeRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ScimRemoveUserFromOrgEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * scim_user_id parameter
   */
  scim_user_id: number;
};
type ScimRemoveUserFromOrgRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchCodeEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching code](https://help.github.com/articles/searching-code/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "indexed";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type SearchCodeRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchCommitsEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching commits](https://help.github.com/articles/searching-commits/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query by `author-date` or `committer-date`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "author-date" | "committer-date";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type SearchCommitsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchIssuesAndPullRequestsEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?:
    | "comments"
    | "reactions"
    | "reactions-+1"
    | "reactions--1"
    | "reactions-smile"
    | "reactions-thinking_face"
    | "reactions-heart"
    | "reactions-tada"
    | "interactions"
    | "created"
    | "updated";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type SearchIssuesAndPullRequestsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchIssuesEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?:
    | "comments"
    | "reactions"
    | "reactions-+1"
    | "reactions--1"
    | "reactions-smile"
    | "reactions-thinking_face"
    | "reactions-heart"
    | "reactions-tada"
    | "interactions"
    | "created"
    | "updated";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type SearchIssuesRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchLabelsEndpoint = {
  /**
   * The id of the repository.
   */
  repository_id: number;
  /**
   * The search keywords. This endpoint does not accept qualifiers in the query. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query).
   */
  q: string;
  /**
   * Sorts the results of your query by when the label was `created` or `updated`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "created" | "updated";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
};
type SearchLabelsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchReposEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching for repositories](https://help.github.com/articles/searching-for-repositories/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query by number of `stars`, `forks`, or `help-wanted-issues` or how recently the items were `updated`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "stars" | "forks" | "help-wanted-issues" | "updated";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type SearchReposRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchTopicsEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query).
   */
  q: string;
};
type SearchTopicsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type SearchUsersEndpoint = {
  /**
   * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching users](https://help.github.com/articles/searching-users/)" for a detailed list of qualifiers.
   */
  q: string;
  /**
   * Sorts the results of your query by number of `followers` or `repositories`, or when the person `joined` GitHub. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
   */
  sort?: "followers" | "repositories" | "joined";
  /**
   * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
   */
  order?: "desc" | "asc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type SearchUsersRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
};
type TeamsGetLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
};
type TeamsGetRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * The name of the team.
   */
  name: string;
  /**
   * The description of the team.
   */
  description?: string;
  /**
   * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
   * **For a non-nested team:**
   * \* `secret` - only visible to organization owners and members of this team.
   * \* `closed` - visible to all members of this organization.
   * **For a parent or child team:**
   * \* `closed` - visible to all members of this organization.
   */
  privacy?: "secret" | "closed";
  /**
   * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
   * \* `push` - team members can pull and push, but not administer newly-added repositories.
   * \* `admin` - team members can pull, push and administer newly-added repositories.
   */
  permission?: "pull" | "push" | "admin";
  /**
   * The ID of a team to set as the parent team.
   */
  parent_team_id?: number;
};
type TeamsUpdateLegacyRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * The name of the team.
   */
  name: string;
  /**
   * The description of the team.
   */
  description?: string;
  /**
   * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
   * **For a non-nested team:**
   * \* `secret` - only visible to organization owners and members of this team.
   * \* `closed` - visible to all members of this organization.
   * **For a parent or child team:**
   * \* `closed` - visible to all members of this organization.
   */
  privacy?: "secret" | "closed";
  /**
   * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
   * \* `push` - team members can pull and push, but not administer newly-added repositories.
   * \* `admin` - team members can pull, push and administer newly-added repositories.
   */
  permission?: "pull" | "push" | "admin";
  /**
   * The ID of a team to set as the parent team.
   */
  parent_team_id?: number;
};
type TeamsUpdateRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsDeleteLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
};
type TeamsDeleteLegacyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsDeleteEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
};
type TeamsDeleteRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListDiscussionsLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionsEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListDiscussionsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * The discussion post's title.
   */
  title: string;
  /**
   * The discussion post's body text.
   */
  body: string;
  /**
   * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
   */
  private?: boolean;
};
type TeamsCreateDiscussionLegacyRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * The discussion post's title.
   */
  title: string;
  /**
   * The discussion post's body text.
   */
  body: string;
  /**
   * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
   */
  private?: boolean;
};
type TeamsCreateDiscussionRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};
type TeamsGetDiscussionLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};
type TeamsGetDiscussionRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion post's title.
   */
  title?: string;
  /**
   * The discussion post's body text.
   */
  body?: string;
};
type TeamsUpdateDiscussionLegacyRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion post's title.
   */
  title?: string;
  /**
   * The discussion post's body text.
   */
  body?: string;
};
type TeamsUpdateDiscussionRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsDeleteDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};
type TeamsDeleteDiscussionLegacyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsDeleteDiscussionEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
};
type TeamsDeleteDiscussionRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionCommentsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListDiscussionCommentsLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListDiscussionCommentsEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListDiscussionCommentsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};
type TeamsCreateDiscussionCommentLegacyRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateDiscussionCommentEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};
type TeamsCreateDiscussionCommentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};
type TeamsGetDiscussionCommentLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetDiscussionCommentEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};
type TeamsGetDiscussionCommentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};
type TeamsUpdateDiscussionCommentLegacyRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsUpdateDiscussionCommentEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The discussion comment's body text.
   */
  body: string;
};
type TeamsUpdateDiscussionCommentRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsDeleteDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};
type TeamsDeleteDiscussionCommentLegacyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsDeleteDiscussionCommentEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
};
type TeamsDeleteDiscussionCommentRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForTeamDiscussionCommentLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionCommentEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForTeamDiscussionCommentRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionCommentLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForTeamDiscussionCommentLegacyRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionCommentEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * comment_number parameter
   */
  comment_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForTeamDiscussionCommentRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForTeamDiscussionLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsListForTeamDiscussionEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
   */
  content?:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReactionsListForTeamDiscussionRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForTeamDiscussionLegacyRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReactionsCreateForTeamDiscussionEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * discussion_number parameter
   */
  discussion_number: number;
  /**
   * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
   */
  content:
    | "+1"
    | "-1"
    | "laugh"
    | "confused"
    | "heart"
    | "hooray"
    | "rocket"
    | "eyes";
};
type ReactionsCreateForTeamDiscussionRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListPendingInvitationsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListPendingInvitationsLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListPendingInvitationsEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListPendingInvitationsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListMembersLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Filters members returned by their role in the team. Can be one of:
   * \* `member` - normal members of the team.
   * \* `maintainer` - team maintainers.
   * \* `all` - all members of the team.
   */
  role?: "member" | "maintainer" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListMembersLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListMembersEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Filters members returned by their role in the team. Can be one of:
   * \* `member` - normal members of the team.
   * \* `maintainer` - team maintainers.
   * \* `all` - all members of the team.
   */
  role?: "member" | "maintainer" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListMembersRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetMemberLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};
type TeamsGetMemberLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetMemberEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};
type TeamsGetMemberRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddMemberLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};
type TeamsAddMemberLegacyRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddMemberEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};
type TeamsAddMemberRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsRemoveMemberLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};
type TeamsRemoveMemberLegacyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetMembershipLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};
type TeamsGetMembershipLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsGetMembershipEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};
type TeamsGetMembershipRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateMembershipLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
  /**
   * The role that this user should have in the team. Can be one of:
   * \* `member` - a normal member of the team.
   * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
   */
  role?: "member" | "maintainer";
};
type TeamsAddOrUpdateMembershipLegacyRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateMembershipEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
  /**
   * The role that this user should have in the team. Can be one of:
   * \* `member` - a normal member of the team.
   * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
   */
  role?: "member" | "maintainer";
};
type TeamsAddOrUpdateMembershipRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsRemoveMembershipLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * username parameter
   */
  username: string;
};
type TeamsRemoveMembershipLegacyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListProjectsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListProjectsLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListProjectsEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListProjectsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsReviewProjectLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * project_id parameter
   */
  project_id: number;
};
type TeamsReviewProjectLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsReviewProjectEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * project_id parameter
   */
  project_id: number;
};
type TeamsReviewProjectRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateProjectLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * The permission to grant to the team for this project. Can be one of:
   * \* `read` - team members can read, but not write to or administer this project.
   * \* `write` - team members can read and write, but not administer this project.
   * \* `admin` - team members can read, write and administer this project.
   * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
   */
  permission?: "read" | "write" | "admin";
};
type TeamsAddOrUpdateProjectLegacyRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateProjectEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * project_id parameter
   */
  project_id: number;
  /**
   * The permission to grant to the team for this project. Can be one of:
   * \* `read` - team members can read, but not write to or administer this project.
   * \* `write` - team members can read and write, but not administer this project.
   * \* `admin` - team members can read, write and administer this project.
   * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
   */
  permission?: "read" | "write" | "admin";
};
type TeamsAddOrUpdateProjectRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsRemoveProjectLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * project_id parameter
   */
  project_id: number;
};
type TeamsRemoveProjectLegacyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsRemoveProjectEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * project_id parameter
   */
  project_id: number;
};
type TeamsRemoveProjectRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListReposLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListReposLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListReposEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListReposRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCheckManagesRepoLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type TeamsCheckManagesRepoLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCheckManagesRepoEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type TeamsCheckManagesRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateRepoLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The permission to grant the team on this repository. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer this repository.
   * \* `push` - team members can pull and push, but not administer this repository.
   * \* `admin` - team members can pull, push and administer this repository.
   *
   * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
   */
  permission?: "pull" | "push" | "admin";
};
type TeamsAddOrUpdateRepoLegacyRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsAddOrUpdateRepoEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
  /**
   * The permission to grant the team on this repository. Can be one of:
   * \* `pull` - team members can pull, but not push to or administer this repository.
   * \* `push` - team members can pull and push, but not administer this repository.
   * \* `admin` - team members can pull, push and administer this repository.
   *
   * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
   */
  permission?: "pull" | "push" | "admin";
};
type TeamsAddOrUpdateRepoRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsRemoveRepoLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type TeamsRemoveRepoLegacyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsRemoveRepoEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type TeamsRemoveRepoRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListIdPGroupsForLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
};
type TeamsListIdPGroupsForLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListIdPGroupsForEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
};
type TeamsListIdPGroupsForRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateOrUpdateIdPGroupConnectionsLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
   */
  groups: TeamsCreateOrUpdateIdPGroupConnectionsLegacyParamsGroups[];
};
type TeamsCreateOrUpdateIdPGroupConnectionsLegacyRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsCreateOrUpdateIdPGroupConnectionsEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
   */
  groups: TeamsCreateOrUpdateIdPGroupConnectionsParamsGroups[];
};
type TeamsCreateOrUpdateIdPGroupConnectionsRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListChildLegacyEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListChildLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListChildEndpoint = {
  /**
   * team_id parameter
   */
  team_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListChildRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersGetAuthenticatedEndpoint = {};
type UsersGetAuthenticatedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersUpdateAuthenticatedEndpoint = {
  /**
   * The new name of the user.
   */
  name?: string;
  /**
   * The publicly visible email address of the user.
   */
  email?: string;
  /**
   * The new blog URL of the user.
   */
  blog?: string;
  /**
   * The new company of the user.
   */
  company?: string;
  /**
   * The new location of the user.
   */
  location?: string;
  /**
   * The new hiring availability of the user.
   */
  hireable?: boolean;
  /**
   * The new short biography of the user.
   */
  bio?: string;
};
type UsersUpdateAuthenticatedRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListBlockedEndpoint = {};
type UsersListBlockedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersCheckBlockedEndpoint = {
  /**
   * username parameter
   */
  username: string;
};
type UsersCheckBlockedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersBlockEndpoint = {
  /**
   * username parameter
   */
  username: string;
};
type UsersBlockRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersUnblockEndpoint = {
  /**
   * username parameter
   */
  username: string;
};
type UsersUnblockRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersTogglePrimaryEmailVisibilityEndpoint = {
  /**
   * Specify the _primary_ email address that needs a visibility change.
   */
  email: string;
  /**
   * Use `public` to enable an authenticated user to view the specified email address, or use `private` so this primary email address cannot be seen publicly.
   */
  visibility: string;
};
type UsersTogglePrimaryEmailVisibilityRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListEmailsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListEmailsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersAddEmailsEndpoint = {
  /**
   * Adds one or more email addresses to your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
   */
  emails: string[];
};
type UsersAddEmailsRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersDeleteEmailsEndpoint = {
  /**
   * Deletes one or more email addresses from your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
   */
  emails: string[];
};
type UsersDeleteEmailsRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListFollowersForAuthenticatedUserEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListFollowersForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListFollowingForAuthenticatedUserEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListFollowingForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersCheckFollowingEndpoint = {
  /**
   * username parameter
   */
  username: string;
};
type UsersCheckFollowingRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersFollowEndpoint = {
  /**
   * username parameter
   */
  username: string;
};
type UsersFollowRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersUnfollowEndpoint = {
  /**
   * username parameter
   */
  username: string;
};
type UsersUnfollowRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListGpgKeysEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListGpgKeysRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersCreateGpgKeyEndpoint = {
  /**
   * Your GPG key, generated in ASCII-armored format. See "[Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/)" for help creating a GPG key.
   */
  armored_public_key?: string;
};
type UsersCreateGpgKeyRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersGetGpgKeyEndpoint = {
  /**
   * gpg_key_id parameter
   */
  gpg_key_id: number;
};
type UsersGetGpgKeyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersDeleteGpgKeyEndpoint = {
  /**
   * gpg_key_id parameter
   */
  gpg_key_id: number;
};
type UsersDeleteGpgKeyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListInstallationsForAuthenticatedUserEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListInstallationsForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListInstallationReposForAuthenticatedUserEndpoint = {
  /**
   * installation_id parameter
   */
  installation_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListInstallationReposForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsAddRepoToInstallationEndpoint = {
  /**
   * installation_id parameter
   */
  installation_id: number;
  /**
   * repository_id parameter
   */
  repository_id: number;
};
type AppsAddRepoToInstallationRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsRemoveRepoFromInstallationEndpoint = {
  /**
   * installation_id parameter
   */
  installation_id: number;
  /**
   * repository_id parameter
   */
  repository_id: number;
};
type AppsRemoveRepoFromInstallationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type IssuesListForAuthenticatedUserEndpoint = {
  /**
   * Indicates which sorts of issues to return. Can be one of:
   * \* `assigned`: Issues assigned to you
   * \* `created`: Issues created by you
   * \* `mentioned`: Issues mentioning you
   * \* `subscribed`: Issues you're subscribed to updates for
   * \* `all`: All issues the authenticated user can see, regardless of participation or creation
   */
  filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
  /**
   * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * A list of comma separated label names. Example: `bug,ui,@high`
   */
  labels?: string;
  /**
   * What to sort results by. Can be either `created`, `updated`, `comments`.
   */
  sort?: "created" | "updated" | "comments";
  /**
   * The direction of the sort. Can be either `asc` or `desc`.
   */
  direction?: "asc" | "desc";
  /**
   * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type IssuesListForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListPublicKeysEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListPublicKeysRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersCreatePublicKeyEndpoint = {
  /**
   * A descriptive name for the new key. Use a name that will help you recognize this key in your GitHub account. For example, if you're using a personal Mac, you might call this key "Personal MacBook Air".
   */
  title?: string;
  /**
   * The public SSH key to add to your GitHub account. See "[Generating a new SSH key](https://help.github.com/articles/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent/)" for guidance on how to create a public SSH key.
   */
  key?: string;
};
type UsersCreatePublicKeyRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersGetPublicKeyEndpoint = {
  /**
   * key_id parameter
   */
  key_id: number;
};
type UsersGetPublicKeyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersDeletePublicKeyEndpoint = {
  /**
   * key_id parameter
   */
  key_id: number;
};
type UsersDeletePublicKeyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListMarketplacePurchasesForAuthenticatedUserEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListMarketplacePurchasesForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsListMarketplacePurchasesForAuthenticatedUserStubbedEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type AppsListMarketplacePurchasesForAuthenticatedUserStubbedRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListMembershipsEndpoint = {
  /**
   * Indicates the state of the memberships to return. Can be either `active` or `pending`. If not specified, the API returns both active and pending memberships.
   */
  state?: "active" | "pending";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListMembershipsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsGetMembershipForAuthenticatedUserEndpoint = {
  /**
   * org parameter
   */
  org: string;
};
type OrgsGetMembershipForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsUpdateMembershipEndpoint = {
  /**
   * org parameter
   */
  org: string;
  /**
   * The state that the membership should be in. Only `"active"` will be accepted.
   */
  state: "active";
};
type OrgsUpdateMembershipRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsStartForAuthenticatedUserEndpoint = {
  /**
   * An array of repositories to include in the migration.
   */
  repositories: string[];
  /**
   * Locks the `repositories` to prevent changes during the migration when set to `true`.
   */
  lock_repositories?: boolean;
  /**
   * Does not include attachments uploaded to GitHub.com in the migration data when set to `true`. Excluding attachments will reduce the migration archive file size.
   */
  exclude_attachments?: boolean;
};
type MigrationsStartForAuthenticatedUserRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsListForAuthenticatedUserEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type MigrationsListForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetStatusForAuthenticatedUserEndpoint = {
  /**
   * migration_id parameter
   */
  migration_id: number;
};
type MigrationsGetStatusForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsGetArchiveForAuthenticatedUserEndpoint = {
  /**
   * migration_id parameter
   */
  migration_id: number;
};
type MigrationsGetArchiveForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsDeleteArchiveForAuthenticatedUserEndpoint = {
  /**
   * migration_id parameter
   */
  migration_id: number;
};
type MigrationsDeleteArchiveForAuthenticatedUserRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsUnlockRepoForAuthenticatedUserEndpoint = {
  /**
   * migration_id parameter
   */
  migration_id: number;
  /**
   * repo_name parameter
   */
  repo_name: string;
};
type MigrationsUnlockRepoForAuthenticatedUserRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListForAuthenticatedUserEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsCreateForAuthenticatedUserEndpoint = {
  /**
   * The name of the project.
   */
  name: string;
  /**
   * The description of the project.
   */
  body?: string;
};
type ProjectsCreateForAuthenticatedUserRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListPublicEmailsEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListPublicEmailsRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListEndpoint = {
  /**
   * Can be one of `all`, `public`, or `private`.
   */
  visibility?: "all" | "public" | "private";
  /**
   * Comma-separated list of values. Can include:
   * \* `owner`: Repositories that are owned by the authenticated user.
   * \* `collaborator`: Repositories that the user has been added to as a collaborator.
   * \* `organization_member`: Repositories that the user has access to through being a member of an organization. This includes every repository on every team that the user is on.
   */
  affiliation?: string;
  /**
   * Can be one of `all`, `owner`, `public`, `private`, `member`. Default: `all`
   *
   * Will cause a `422` error if used in the same request as **visibility** or **affiliation**. Will cause a `422` error if used in the same request as **visibility** or **affiliation**.
   */
  type?: "all" | "owner" | "public" | "private" | "member";
  /**
   * Can be one of `created`, `updated`, `pushed`, `full_name`.
   */
  sort?: "created" | "updated" | "pushed" | "full_name";
  /**
   * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposCreateForAuthenticatedUserEndpoint = {
  /**
   * The name of the repository.
   */
  name: string;
  /**
   * A short description of the repository.
   */
  description?: string;
  /**
   * A URL with more information about the repository.
   */
  homepage?: string;
  /**
   * Either `true` to create a private repository or `false` to create a public one. Creating private repositories requires a paid GitHub account.
   */
  private?: boolean;
  /**
   * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://help.github.com/github/creating-cloning-and-archiving-repositories/creating-an-internal-repository)" in the GitHub Help documentation.
   * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
   */
  visibility?: "public" | "private" | "visibility" | "internal";
  /**
   * Either `true` to enable issues for this repository or `false` to disable them.
   */
  has_issues?: boolean;
  /**
   * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
   */
  has_projects?: boolean;
  /**
   * Either `true` to enable the wiki for this repository or `false` to disable it.
   */
  has_wiki?: boolean;
  /**
   * Either `true` to make this repo available as a template repository or `false` to prevent it.
   */
  is_template?: boolean;
  /**
   * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
   */
  team_id?: number;
  /**
   * Pass `true` to create an initial commit with empty README.
   */
  auto_init?: boolean;
  /**
   * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
   */
  gitignore_template?: string;
  /**
   * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
   */
  license_template?: string;
  /**
   * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
   */
  allow_squash_merge?: boolean;
  /**
   * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
   */
  allow_merge_commit?: boolean;
  /**
   * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
   */
  allow_rebase_merge?: boolean;
  /**
   * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
   */
  delete_branch_on_merge?: boolean;
};
type ReposCreateForAuthenticatedUserRequestOptions = {
  method: "POST";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListInvitationsForAuthenticatedUserEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListInvitationsForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposAcceptInvitationEndpoint = {
  /**
   * invitation_id parameter
   */
  invitation_id: number;
};
type ReposAcceptInvitationRequestOptions = {
  method: "PATCH";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposDeclineInvitationEndpoint = {
  /**
   * invitation_id parameter
   */
  invitation_id: number;
};
type ReposDeclineInvitationRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListReposStarredByAuthenticatedUserEndpoint = {
  /**
   * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
   */
  sort?: "created" | "updated";
  /**
   * One of `asc` (ascending) or `desc` (descending).
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListReposStarredByAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityCheckStarringRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ActivityCheckStarringRepoRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityStarRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ActivityStarRepoRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityUnstarRepoEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ActivityUnstarRepoRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListWatchedReposForAuthenticatedUserEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListWatchedReposForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityCheckWatchingRepoLegacyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ActivityCheckWatchingRepoLegacyRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityWatchRepoLegacyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ActivityWatchRepoLegacyRequestOptions = {
  method: "PUT";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityStopWatchingRepoLegacyEndpoint = {
  /**
   * owner parameter
   */
  owner: string;
  /**
   * repo parameter
   */
  repo: string;
};
type ActivityStopWatchingRepoLegacyRequestOptions = {
  method: "DELETE";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type TeamsListForAuthenticatedUserEndpoint = {
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type TeamsListForAuthenticatedUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type MigrationsListReposForUserEndpoint = {
  /**
   * migration_id parameter
   */
  migration_id: number;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type MigrationsListReposForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListEndpoint = {
  /**
   * The integer ID of the last User that you've seen.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersGetByUsernameEndpoint = {
  /**
   * username parameter
   */
  username: string;
};
type UsersGetByUsernameRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListEventsForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListEventsForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListEventsForOrgEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * org parameter
   */
  org: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListEventsForOrgRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListPublicEventsForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListPublicEventsForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListFollowersForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListFollowersForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListFollowingForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListFollowingForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersCheckFollowingForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * target_user parameter
   */
  target_user: string;
};
type UsersCheckFollowingForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type GistsListPublicForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
   */
  since?: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type GistsListPublicForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListGpgKeysForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListGpgKeysForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersGetContextForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Identifies which additional information you'd like to receive about the person's hovercard. Can be `organization`, `repository`, `issue`, `pull_request`. **Required** when using `subject_id`.
   */
  subject_type?: "organization" | "repository" | "issue" | "pull_request";
  /**
   * Uses the ID for the `subject_type` you specified. **Required** when using `subject_type`.
   */
  subject_id?: string;
};
type UsersGetContextForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsGetUserInstallationEndpoint = {
  /**
   * username parameter
   */
  username: string;
};
type AppsGetUserInstallationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type AppsFindUserInstallationEndpoint = {
  /**
   * username parameter
   */
  username: string;
};
type AppsFindUserInstallationRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type UsersListPublicKeysForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type UsersListPublicKeysForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type OrgsListForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type OrgsListForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ProjectsListForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
   */
  state?: "open" | "closed" | "all";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ProjectsListForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListReceivedEventsForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListReceivedEventsForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListReceivedPublicEventsForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListReceivedPublicEventsForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ReposListForUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Can be one of `all`, `owner`, `member`.
   */
  type?: "all" | "owner" | "member";
  /**
   * Can be one of `created`, `updated`, `pushed`, `full_name`.
   */
  sort?: "created" | "updated" | "pushed" | "full_name";
  /**
   * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ReposListForUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListReposStarredByUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
   */
  sort?: "created" | "updated";
  /**
   * One of `asc` (ascending) or `desc` (descending).
   */
  direction?: "asc" | "desc";
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListReposStarredByUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};
type ActivityListReposWatchedByUserEndpoint = {
  /**
   * username parameter
   */
  username: string;
  /**
   * Results per page (max 100)
   */
  per_page?: number;
  /**
   * Page number of the results to fetch.
   */
  page?: number;
};
type ActivityListReposWatchedByUserRequestOptions = {
  method: "GET";
  url: Url;
  headers: RequestHeaders;
  request: RequestRequestOptions;
};

export type AppsCreateInstallationTokenParamsPermissions = {};
export type GistsCreateParamsFiles = {
  content?: string;
};
export type GistsUpdateParamsFiles = {
  content?: string;
  filename?: string;
};
export type OrgsCreateHookParamsConfig = {
  url: string;
  content_type?: string;
  secret?: string;
  insecure_ssl?: string;
};
export type OrgsUpdateHookParamsConfig = {
  url: string;
  content_type?: string;
  secret?: string;
  insecure_ssl?: string;
};
export type TeamsCreateOrUpdateIdPGroupConnectionsInOrgParamsGroups = {
  group_id: string;
  group_name: string;
  group_description: string;
};
export type ReposUpdateBranchProtectionParamsRequiredStatusChecks = {
  strict: boolean;
  contexts: string[];
};
export type ReposUpdateBranchProtectionParamsRequiredPullRequestReviews = {
  dismissal_restrictions?: ReposUpdateBranchProtectionParamsRequiredPullRequestReviewsDismissalRestrictions;
  dismiss_stale_reviews?: boolean;
  require_code_owner_reviews?: boolean;
  required_approving_review_count?: number;
};
export type ReposUpdateBranchProtectionParamsRequiredPullRequestReviewsDismissalRestrictions = {
  users?: string[];
  teams?: string[];
};
export type ReposUpdateBranchProtectionParamsRestrictions = {
  users: string[];
  teams: string[];
  apps?: string[];
};
export type ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions = {
  users?: string[];
  teams?: string[];
};
export type ChecksCreateParamsOutput = {
  title: string;
  summary: string;
  text?: string;
  annotations?: ChecksCreateParamsOutputAnnotations[];
  images?: ChecksCreateParamsOutputImages[];
};
export type ChecksCreateParamsOutputAnnotations = {
  path: string;
  start_line: number;
  end_line: number;
  start_column?: number;
  end_column?: number;
  annotation_level: "notice" | "warning" | "failure";
  message: string;
  title?: string;
  raw_details?: string;
};
export type ChecksCreateParamsOutputImages = {
  alt: string;
  image_url: string;
  caption?: string;
};
export type ChecksCreateParamsActions = {
  label: string;
  description: string;
  identifier: string;
};
export type ChecksUpdateParamsOutput = {
  title?: string;
  summary: string;
  text?: string;
  annotations?: ChecksUpdateParamsOutputAnnotations[];
  images?: ChecksUpdateParamsOutputImages[];
};
export type ChecksUpdateParamsOutputAnnotations = {
  path: string;
  start_line: number;
  end_line: number;
  start_column?: number;
  end_column?: number;
  annotation_level: "notice" | "warning" | "failure";
  message: string;
  title?: string;
  raw_details?: string;
};
export type ChecksUpdateParamsOutputImages = {
  alt: string;
  image_url: string;
  caption?: string;
};
export type ChecksUpdateParamsActions = {
  label: string;
  description: string;
  identifier: string;
};
export type ChecksSetSuitesPreferencesParamsAutoTriggerChecks = {
  app_id: number;
  setting: boolean;
};
export type ReposCreateOrUpdateFileParamsCommitter = {
  name: string;
  email: string;
};
export type ReposCreateOrUpdateFileParamsAuthor = {
  name: string;
  email: string;
};
export type ReposCreateFileParamsCommitter = {
  name: string;
  email: string;
};
export type ReposCreateFileParamsAuthor = {
  name: string;
  email: string;
};
export type ReposUpdateFileParamsCommitter = {
  name: string;
  email: string;
};
export type ReposUpdateFileParamsAuthor = {
  name: string;
  email: string;
};
export type ReposDeleteFileParamsCommitter = {
  name?: string;
  email?: string;
};
export type ReposDeleteFileParamsAuthor = {
  name?: string;
  email?: string;
};
export type ReposCreateDispatchEventParamsClientPayload = {};
export type GitCreateCommitParamsAuthor = {
  name?: string;
  email?: string;
  date?: string;
};
export type GitCreateCommitParamsCommitter = {
  name?: string;
  email?: string;
  date?: string;
};
export type GitCreateTagParamsTagger = {
  name?: string;
  email?: string;
  date?: string;
};
export type GitCreateTreeParamsTree = {
  path?: string;
  mode?: "100644" | "100755" | "040000" | "160000" | "120000";
  type?: "blob" | "tree" | "commit";
  sha?: string | null;
  content?: string;
};
export type ReposCreateHookParamsConfig = {
  url: string;
  content_type?: string;
  secret?: string;
  insecure_ssl?: string;
};
export type ReposUpdateHookParamsConfig = {
  url: string;
  content_type?: string;
  secret?: string;
  insecure_ssl?: string;
};
export type ReposEnablePagesSiteParamsSource = {
  branch?: "master" | "gh-pages";
  path?: string;
};
export type PullsCreateReviewParamsComments = {
  path: string;
  position: number;
  body: string;
};
export type TeamsCreateOrUpdateIdPGroupConnectionsLegacyParamsGroups = {
  group_id: string;
  group_name: string;
  group_description: string;
};
export type TeamsCreateOrUpdateIdPGroupConnectionsParamsGroups = {
  group_id: string;
  group_name: string;
  group_description: string;
};
