"use strict";

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.object.keys");

require("core-js/modules/web.dom-collections.for-each");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = jsonToCss;

var _global = require("global");

/**
 * Not all frameworks support an object for the style attribute but we want all to
 * consume `styles.json`. Since `styles.json` uses standard style properties for keys,
 * we can just set them on an element and then get the string result of that element's
 * `style` attribute. This also means that invalid styles are filtered out.
 *
 * @param {Object} jsonStyles
 * @returns {string}
 * @see https://stackoverflow.com/questions/38533544/jsx-css-to-inline-styles
 */
function jsonToCss(jsonStyles) {
  var frag = _global.document.createElement('div');

  Object.keys(jsonStyles).forEach(function (key) {
    frag.style[key] = jsonStyles[key];
  });
  return frag.getAttribute('style');
}