"use strict";

require("core-js/modules/es.object.assign");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _global = require("global");

var _addons = require("@storybook/addons");

var _parameters = _interopRequireDefault(require("./parameters"));

var _styles = _interopRequireDefault(require("./styles"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var INNER_ID = 'sb-addon-centered-inner';
var WRAPPER_ID = 'sb-addon-centered-wrapper';

function getOrCreate(id, style) {
  var elementOnDom = _global.document.getElementById(id);

  if (elementOnDom) {
    return elementOnDom;
  }

  var element = _global.document.createElement('div');

  element.setAttribute('id', id);
  Object.assign(element.style, style);
  return element;
}

function getInnerDiv() {
  return getOrCreate(INNER_ID, _styles["default"].innerStyle);
}

function getWrapperDiv() {
  return getOrCreate(WRAPPER_ID, _styles["default"].style);
}

function centered(storyFn) {
  var inner = getInnerDiv();
  var wrapper = getWrapperDiv();
  wrapper.appendChild(inner);
  var element = storyFn();

  if (typeof element === 'string') {
    inner.innerHTML = element;
  } else if (element instanceof _global.Node) {
    inner.innerHTML = '';
    inner.appendChild(element);
  } else {
    return element;
  }

  return wrapper;
}

var _default = (0, _addons.makeDecorator)(Object.assign({}, _parameters["default"], {
  wrapper: function wrapper(getStory) {
    return centered(getStory);
  }
}));

exports["default"] = _default;

if (module && module.hot && module.hot.decline) {
  module.hot.decline();
}