"use strict";

require("core-js/modules/es.object.assign");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _mithril = _interopRequireDefault(require("mithril"));

var _addons = require("@storybook/addons");

var _parameters = _interopRequireDefault(require("./parameters"));

var _styles = _interopRequireDefault(require("./styles"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/** @jsx m */

/* eslint-disable import/no-extraneous-dependencies */
function centered(storyFn) {
  return {
    view: function view() {
      return (0, _mithril["default"])("div", {
        style: _styles["default"].style
      }, (0, _mithril["default"])("div", {
        style: _styles["default"].innerStyle
      }, (0, _mithril["default"])(storyFn())));
    }
  };
}

var _default = (0, _addons.makeDecorator)(Object.assign({}, _parameters["default"], {
  wrapper: function wrapper(getStory) {
    return centered(getStory);
  }
}));

exports["default"] = _default;

if (module && module.hot && module.hot.decline) {
  module.hot.decline();
}