import { PropsTableProps } from '@storybook/components';
export declare const CURRENT_SELECTION = ".";
export declare type Component = any;
export interface StoryData {
    id?: string;
    kind?: string;
    name?: string;
    parameters?: any;
}
export declare type DocsStoryProps = StoryData & {
    expanded?: boolean;
    withToolbar?: boolean;
};
export interface SlotContext {
    id?: string;
    selectedKind?: string;
    selectedStory?: string;
    parameters?: any;
    storyStore?: any;
}
export declare type StringSlot = (context: SlotContext) => string;
export declare type DescriptionSlot = (description: string, context: SlotContext) => string;
export declare type PropsSlot = (context: SlotContext, component: Component) => PropsTableProps;
export declare type StorySlot = (stories: StoryData[], context: SlotContext) => DocsStoryProps;
export declare type StoriesSlot = (stories: StoryData[], context: SlotContext) => DocsStoryProps[];
export interface DocsPageProps {
    titleSlot?: StringSlot;
    subtitleSlot?: StringSlot;
    descriptionSlot?: DescriptionSlot;
    primarySlot?: StorySlot;
    propsSlot?: PropsSlot;
    storiesSlot?: StoriesSlot;
}
