"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.array.concat");

require("core-js/modules/es.array.find");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.join");

require("core-js/modules/es.array.map");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.entries");

require("core-js/modules/web.dom-collections.for-each");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractComponentDescription = exports.extractProps = exports.checkValidCompodocJson = exports.checkValidComponentOrDirective = exports.getCompdocJson = exports.setCompodocJson = exports.isMethod = void 0;

/* eslint-disable no-underscore-dangle */

/* global window */
var isMethod = function isMethod(methodOrProp) {
  return methodOrProp.args !== undefined;
};

exports.isMethod = isMethod;

var setCompodocJson = function setCompodocJson(compodocJson) {
  // @ts-ignore
  window.__STORYBOOK_COMPODOC_JSON__ = compodocJson;
}; // @ts-ignore


exports.setCompodocJson = setCompodocJson;

var getCompdocJson = function getCompdocJson() {
  return window.__STORYBOOK_COMPODOC_JSON__;
};

exports.getCompdocJson = getCompdocJson;

var checkValidComponentOrDirective = function checkValidComponentOrDirective(component) {
  if (!component.name) {
    throw new Error("Invalid component ".concat(JSON.stringify(component)));
  }
};

exports.checkValidComponentOrDirective = checkValidComponentOrDirective;

var checkValidCompodocJson = function checkValidCompodocJson(compodocJson) {
  if (!compodocJson || !compodocJson.components) {
    throw new Error('Invalid compodoc JSON');
  }
};

exports.checkValidCompodocJson = checkValidCompodocJson;

function isEmpty(obj) {
  return Object.entries(obj).length === 0 && obj.constructor === Object;
}

var hasDecorator = function hasDecorator(item, decoratorName) {
  return item.decorators && item.decorators.find(function (x) {
    return x.name === decoratorName;
  });
};

var mapPropertyToSection = function mapPropertyToSection(key, item) {
  if (hasDecorator(item, 'ViewChild')) {
    return 'view child';
  }

  if (hasDecorator(item, 'ViewChildren')) {
    return 'view children';
  }

  if (hasDecorator(item, 'ContentChild')) {
    return 'content child';
  }

  if (hasDecorator(item, 'ContentChildren')) {
    return 'content children';
  }

  return 'properties';
};

var mapItemToSection = function mapItemToSection(key, item) {
  switch (key) {
    case 'methodsClass':
      return 'methods';

    case 'inputsClass':
      return 'inputs';

    case 'outputsClass':
      return 'outputs';

    case 'propertiesClass':
      if (isMethod(item)) {
        throw new Error("Cannot be of type Method if key === 'propertiesClass'");
      }

      return mapPropertyToSection(key, item);

    default:
      throw new Error("Unknown key: ".concat(key));
  }
};

var getComponentData = function getComponentData(component) {
  if (!component) {
    return null;
  }

  checkValidComponentOrDirective(component);
  var compodocJson = getCompdocJson();
  checkValidCompodocJson(compodocJson);
  var name = component.name;
  return compodocJson.components.find(function (c) {
    return c.name === name;
  }) || compodocJson.directives.find(function (c) {
    return c.name === name;
  });
};

var displaySignature = function displaySignature(item) {
  var args = item.args.map(function (arg) {
    return "".concat(arg.name).concat(arg.optional ? '?' : '', ": ").concat(arg.type);
  });
  return "(".concat(args.join(', '), ") => ").concat(item.returnType);
};

var extractProps = function extractProps(component) {
  var componentData = getComponentData(component);

  if (!componentData) {
    return null;
  }

  var sectionToItems = {};
  var compodocClasses = ['propertiesClass', 'methodsClass', 'inputsClass', 'outputsClass'];
  compodocClasses.forEach(function (key) {
    var data = componentData[key] || [];
    data.forEach(function (item) {
      var sectionItem = {
        name: item.name,
        type: {
          summary: isMethod(item) ? displaySignature(item) : item.type
        },
        required: isMethod(item) ? false : !item.optional,
        description: item.description,
        defaultValue: {
          summary: isMethod(item) ? '' : item.defaultValue
        }
      };
      var section = mapItemToSection(key, item);

      if (!sectionToItems[section]) {
        sectionToItems[section] = [];
      }

      sectionToItems[section].push(sectionItem);
    });
  }); // sort the sections

  var SECTIONS = ['inputs', 'outputs', 'properties', 'methods', 'view child', 'view children', 'content child', 'content children'];
  var sections = {};
  SECTIONS.forEach(function (section) {
    var items = sectionToItems[section];

    if (items) {
      sections[section] = items;
    }
  });
  return isEmpty(sections) ? null : {
    sections: sections
  };
};

exports.extractProps = extractProps;

var extractComponentDescription = function extractComponentDescription(component) {
  var componentData = getComponentData(component);

  if (!componentData) {
    return null;
  }

  return componentData.rawdescription;
};

exports.extractComponentDescription = extractComponentDescription;