"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultValue = createDefaultValue;

var _lodash = require("lodash");

var _captions = require("../captions");

var _inspection = require("../inspection");

var _isHtmlTag = require("../isHtmlTag");

var _lib = require("../../../../lib");

var _generateCode = require("../generateCode");

var _generateObject = require("./generateObject");

var _generateArray = require("./generateArray");

var _prettyIdentifier = require("./prettyIdentifier");

function generateFunc(_ref) {
  var inferedType = _ref.inferedType,
      ast = _ref.ast;
  var _ref2 = inferedType,
      identifier = _ref2.identifier;

  if (!(0, _lodash.isNil)(identifier)) {
    return (0, _lib.createSummaryValue)((0, _prettyIdentifier.getPrettyIdentifier)(inferedType), (0, _generateCode.generateCode)(ast));
  }

  var prettyCaption = (0, _generateCode.generateCode)(ast, true);
  return !(0, _lib.isTooLongForDefaultValueSummary)(prettyCaption) ? (0, _lib.createSummaryValue)(prettyCaption) : (0, _lib.createSummaryValue)(_captions.FUNCTION_CAPTION, (0, _generateCode.generateCode)(ast));
} // All elements are JSX elements.
// JSX elements are not supported by escodegen.


function generateElement(defaultValue, inspectionResult) {
  var inferedType = inspectionResult.inferedType;
  var _ref3 = inferedType,
      identifier = _ref3.identifier;

  if (!(0, _lodash.isNil)(identifier)) {
    if (!(0, _isHtmlTag.isHtmlTag)(identifier)) {
      var prettyIdentifier = (0, _prettyIdentifier.getPrettyIdentifier)(inferedType);
      return (0, _lib.createSummaryValue)(prettyIdentifier, prettyIdentifier !== defaultValue ? defaultValue : undefined);
    }
  }

  return !(0, _lib.isTooLongForDefaultValueSummary)(defaultValue) ? (0, _lib.createSummaryValue)(defaultValue) : (0, _lib.createSummaryValue)(_captions.ELEMENT_CAPTION, defaultValue);
}

function createDefaultValue(defaultValue) {
  try {
    var inspectionResult = (0, _inspection.inspectValue)(defaultValue);

    switch (inspectionResult.inferedType.type) {
      case _inspection.InspectionType.OBJECT:
        return (0, _generateObject.generateObject)(inspectionResult);

      case _inspection.InspectionType.FUNCTION:
        return generateFunc(inspectionResult);

      case _inspection.InspectionType.ELEMENT:
        return generateElement(defaultValue, inspectionResult);

      case _inspection.InspectionType.ARRAY:
        return (0, _generateArray.generateArray)(inspectionResult);

      default:
        return null;
    }
  } catch (e) {
    // eslint-disable-next-line no-console
    console.error(e);
  }

  return null;
}