"use strict";

require("core-js/modules/es.array.map");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enhanceTypeScriptProp = enhanceTypeScriptProp;
exports.enhanceTypeScriptProps = enhanceTypeScriptProps;

var _lodash = require("lodash");

var _defaultValues = require("../lib/defaultValues");

function enhanceTypeScriptProp(extractedProp, rawDefaultProp) {
  var propDef = extractedProp.propDef;
  var defaultValue = extractedProp.docgenInfo.defaultValue;

  if (!(0, _lodash.isNil)(defaultValue) && !(0, _lodash.isNil)(defaultValue.value)) {
    var newDefaultValue = (0, _defaultValues.createDefaultValue)(defaultValue.value);

    if (!(0, _lodash.isNil)(newDefaultValue)) {
      propDef.defaultValue = newDefaultValue;
    }
  } else if (!(0, _lodash.isNil)(rawDefaultProp)) {
    var _newDefaultValue = (0, _defaultValues.createDefaultValueFromRawDefaultProp)(rawDefaultProp, propDef);

    if (!(0, _lodash.isNil)(_newDefaultValue)) {
      propDef.defaultValue = _newDefaultValue;
    }
  }

  return propDef;
}

function enhanceTypeScriptProps(extractedProps) {
  return extractedProps.map(enhanceTypeScriptProp);
}