"use strict";

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.map");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractProps = void 0;

var _docgen = require("../../lib/docgen");

var SECTIONS = ['props', 'events', 'slots'];

var extractProps = function extractProps(component) {
  if (!(0, _docgen.hasDocgen)(component)) {
    return null;
  }

  var sections = {};
  SECTIONS.forEach(function (section) {
    sections[section] = (0, _docgen.extractComponentProps)(component, section).map(function (x) {
      return x.propDef;
    });
  });
  return {
    sections: sections
  };
};

exports.extractProps = extractProps;