"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.array.filter");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.map");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.keys");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractComponentDescription = extractComponentDescription;
exports.extractComponentProps = exports.extractComponentSectionObject = exports.extractComponentSectionArray = void 0;

var _lodash = require("lodash");

var _jsdocParser = require("../jsdocParser");

var _types = require("./types");

var _utils = require("./utils");

var _createPropDef = require("./createPropDef");

var getTypeSystem = function getTypeSystem(docgenInfo) {
  if (!(0, _lodash.isNil)(docgenInfo.type)) {
    return _types.TypeSystem.JAVASCRIPT;
  }

  if (!(0, _lodash.isNil)(docgenInfo.flowType)) {
    return _types.TypeSystem.FLOW;
  }

  if (!(0, _lodash.isNil)(docgenInfo.tsType)) {
    return _types.TypeSystem.TYPESCRIPT;
  }

  return _types.TypeSystem.UNKNOWN;
};

var extractComponentSectionArray = function extractComponentSectionArray(docgenSection) {
  var typeSystem = getTypeSystem(docgenSection[0]);
  var createPropDef = (0, _createPropDef.getPropDefFactory)(typeSystem);
  return docgenSection.map(function (item) {
    return extractProp(item.name, item, typeSystem, createPropDef);
  }).filter(Boolean);
};

exports.extractComponentSectionArray = extractComponentSectionArray;

var extractComponentSectionObject = function extractComponentSectionObject(docgenSection) {
  var docgenPropsKeys = Object.keys(docgenSection);
  var typeSystem = getTypeSystem(docgenSection[docgenPropsKeys[0]]);
  var createPropDef = (0, _createPropDef.getPropDefFactory)(typeSystem);
  return docgenPropsKeys.map(function (propName) {
    var docgenInfo = docgenSection[propName];
    return !(0, _lodash.isNil)(docgenInfo) ? extractProp(propName, docgenInfo, typeSystem, createPropDef) : null;
  }).filter(Boolean);
};

exports.extractComponentSectionObject = extractComponentSectionObject;

var extractComponentProps = function extractComponentProps(component, section) {
  var docgenSection = (0, _utils.getDocgenSection)(component, section);

  if (!(0, _utils.isValidDocgenSection)(docgenSection)) {
    return [];
  } // vue-docgen-api has diverged from react-docgen and returns an array


  return Array.isArray(docgenSection) ? extractComponentSectionArray(docgenSection) : extractComponentSectionObject(docgenSection);
};

exports.extractComponentProps = extractComponentProps;

function extractProp(propName, docgenInfo, typeSystem, createPropDef) {
  var jsDocParsingResult = (0, _jsdocParser.parseJsDoc)(docgenInfo.description);
  var isIgnored = jsDocParsingResult.includesJsDoc && jsDocParsingResult.ignore;

  if (!isIgnored) {
    var propDef = createPropDef(propName, docgenInfo, jsDocParsingResult);
    return {
      propDef: propDef,
      jsDocTags: jsDocParsingResult.extractedTags,
      docgenInfo: docgenInfo,
      typeSystem: typeSystem
    };
  }

  return null;
}

function extractComponentDescription(component) {
  return !(0, _lodash.isNil)(component) && (0, _utils.getDocgenDescription)(component);
}