import { PropsTableProps } from '@storybook/components';
import { Component } from '../../blocks/shared';
export declare type PropsExtractor = (component: Component) => PropsTableProps | null;
export interface DocgenType {
    name: string;
    description?: string;
    required?: boolean;
}
export interface DocgenPropType extends DocgenType {
    value?: any;
    raw?: string;
    computed?: boolean;
}
export interface DocgenFlowType extends DocgenType {
    type?: string;
    raw?: string;
    signature?: any;
    elements?: any[];
}
export interface DocgenTypeScriptType extends DocgenType {
}
export interface DocgenPropDefaultValue {
    value: string;
}
export interface DocgenInfo {
    type?: DocgenPropType;
    flowType?: DocgenFlowType;
    tsType?: DocgenTypeScriptType;
    required: boolean;
    description?: string;
    defaultValue?: DocgenPropDefaultValue;
}
export declare enum TypeSystem {
    JAVASCRIPT = "JavaScript",
    FLOW = "Flow",
    TYPESCRIPT = "TypeScript",
    UNKNOWN = "Unknown"
}
