"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

require("core-js/modules/es.array.for-each");

var commonPreset = _interopRequireWildcard(require("./frameworks/common/preset"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var PRESET_METHODS = ['babel', 'babelDefault', 'managerBabel', 'webpack', 'webpackFinal', 'managerWebpack', 'managerEntries', 'entries', 'config'];

function getFrameworkPreset(frameworkPresetFile) {
  // eslint-disable-next-line import/no-dynamic-require, global-require
  return require(frameworkPresetFile);
} // Create a composite preset that applies the base preset &
// appends any framework-specific extensions as needed


function withFrameworkExtensions(basePreset, mapper) {
  var extended = {};
  PRESET_METHODS.forEach(function (method) {
    extended[method] = function (existing, options) {
      var updated = existing;
      var baseMethod = basePreset[method];

      if (baseMethod) {
        updated = baseMethod(updated, options);
      }

      var frameworkPresetFile = mapper(options.framework);

      if (frameworkPresetFile) {
        var frameworkPreset = getFrameworkPreset(frameworkPresetFile);
        var frameworkMethod = frameworkPreset[method];
        if (frameworkMethod) updated = frameworkMethod(updated, options);
      }

      return updated;
    };
  });
  return extended;
}

module.exports = withFrameworkExtensions(commonPreset, function (framework) {
  try {
    return require.resolve("./frameworks/".concat(framework, "/preset"));
  } catch (err) {
    // there is no custom config for the user's framework, do nothing
    return null;
  }
});