"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Story = exports.StoryError = void 0;

var _react = _interopRequireWildcard(require("react"));

var _IFrame = require("./IFrame");

var _EmptyBlock = require("./EmptyBlock");

var _ZoomContext = require("./ZoomContext");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var BASE_URL = 'iframe.html';
var StoryError;
/** error message for Story with null storyFn
 * if the story id exists, it must be pointing to a non-existing story
 *  if there is assigned story id, the story must be empty
 */

exports.StoryError = StoryError;

(function (StoryError) {
  StoryError["NO_STORY"] = "No component or story to display";
})(StoryError || (exports.StoryError = StoryError = {}));

var MISSING_STORY = function MISSING_STORY(id) {
  return id ? "Story \"".concat(id, "\" doesn't exist.") : StoryError.NO_STORY;
};

var InlineZoomWrapper = function InlineZoomWrapper(_ref) {
  var scale = _ref.scale,
      children = _ref.children;
  return scale === 1 ? _react["default"].createElement(_react["default"].Fragment, null, children) : _react["default"].createElement("div", {
    style: {
      overflow: 'hidden'
    }
  }, _react["default"].createElement("div", {
    style: {
      transform: "scale(".concat(1 / scale, ")"),
      transformOrigin: 'top left'
    }
  }, children));
};

var InlineStory = function InlineStory(_ref2) {
  var storyFn = _ref2.storyFn,
      height = _ref2.height,
      id = _ref2.id;
  return _react["default"].createElement("div", {
    style: {
      height: height
    }
  }, _react["default"].createElement(_ZoomContext.ZoomContext.Consumer, null, function (_ref3) {
    var scale = _ref3.scale;
    return _react["default"].createElement(InlineZoomWrapper, {
      scale: scale
    }, storyFn ? (0, _react.createElement)(storyFn) : _react["default"].createElement(_EmptyBlock.EmptyBlock, null, MISSING_STORY(id)));
  }));
};

InlineStory.displayName = "InlineStory";

var IFrameStory = function IFrameStory(_ref4) {
  var id = _ref4.id,
      title = _ref4.title,
      _ref4$height = _ref4.height,
      height = _ref4$height === void 0 ? '500px' : _ref4$height;
  return _react["default"].createElement("div", {
    style: {
      width: '100%',
      height: height
    }
  }, _react["default"].createElement(_ZoomContext.ZoomContext.Consumer, null, function (_ref5) {
    var scale = _ref5.scale;
    return _react["default"].createElement(_IFrame.IFrame, {
      key: "iframe",
      id: "iframe--".concat(id),
      title: title,
      src: "".concat(BASE_URL, "?id=").concat(id, "&viewMode=story"),
      allowFullScreen: true,
      scale: scale,
      style: {
        width: '100%',
        height: '100%',
        border: '0 none'
      }
    });
  }));
};

IFrameStory.displayName = "IFrameStory";

/**
 * A story element, either renderend inline or in an iframe,
 * with configurable height.
 */
var Story = function Story(props) {
  var _ref6 = props,
      error = _ref6.error;
  var _ref7 = props,
      storyFn = _ref7.storyFn;
  var id = props.id,
      inline = props.inline,
      title = props.title,
      height = props.height;

  if (error) {
    return _react["default"].createElement(_EmptyBlock.EmptyBlock, null, error);
  }

  return inline ? _react["default"].createElement(InlineStory, {
    id: id,
    storyFn: storyFn,
    title: title,
    height: height
  }) : _react["default"].createElement(IFrameStory, {
    id: id,
    title: title,
    height: height
  });
};

exports.Story = Story;