"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

require("core-js/modules/es.symbol");

require("core-js/modules/es.array.concat");

require("core-js/modules/es.array.find");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.entries");

require("core-js/modules/es.object.keys");

require("core-js/modules/es.regexp.exec");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.Link = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _theming = require("@storybook/theming");

var _components = require("@storybook/components");

var _router = require("@storybook/router");

var _treeview = require("./treeview/treeview");

var _SidebarItem = _interopRequireDefault(require("./SidebarItem"));

var _SidebarSearch = _interopRequireDefault(require("./SidebarSearch"));

var _SidebarSubheading = _interopRequireDefault(require("./SidebarSubheading"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var Search = (0, _theming.styled)(_SidebarSearch["default"])({
  margin: '0 20px 1rem'
});
var Subheading = (0, _theming.styled)(_SidebarSubheading["default"])({
  margin: '0 20px'
});
Subheading.propTypes = {
  className: _propTypes["default"].string
};
Subheading.defaultProps = {
  className: 'sidebar-subheading'
};

var Section = _theming.styled.section({
  '& + section': {
    marginTop: 20
  },
  '&:last-of-type': {
    marginBottom: 40
  }
});

var List = _theming.styled.div();

List.displayName = 'List';
var plain = {
  color: 'inherit',
  display: 'block',
  textDecoration: 'none',
  userSelect: 'none'
}; // @ts-ignore

var PlainRouterLink = (0, _theming.styled)(_router.Link)(plain); // @ts-ignore

var PlainLink = _theming.styled.a(plain);

var Wrapper = _theming.styled.div({});

var refinedViewMode = function refinedViewMode(viewMode, isDocsOnly) {
  if (isDocsOnly) {
    return 'docs';
  }

  return viewMode === 'settings' || !viewMode ? 'story' : viewMode;
};

var targetId = function targetId(childIds) {
  return childIds && childIds.find(function (childId) {
    return /.*--.*/.exec(childId);
  });
};

var Link = function Link(_ref) {
  var id = _ref.id,
      prefix = _ref.prefix,
      name = _ref.name,
      children = _ref.children,
      isLeaf = _ref.isLeaf,
      isComponent = _ref.isComponent,
      onClick = _ref.onClick,
      onKeyUp = _ref.onKeyUp,
      childIds = _ref.childIds,
      isExpanded = _ref.isExpanded;
  return isLeaf || isComponent && !isExpanded ? _react["default"].createElement(_router.Location, null, function (_ref2) {
    var viewMode = _ref2.viewMode;
    return _react["default"].createElement(PlainRouterLink, {
      title: name,
      id: prefix + id,
      to: "/".concat(refinedViewMode(viewMode, isLeaf && isComponent), "/").concat(targetId(childIds) || id),
      onKeyUp: onKeyUp,
      onClick: onClick
    }, children);
  }) : _react["default"].createElement(PlainLink, {
    title: name,
    id: prefix + id,
    onKeyUp: onKeyUp,
    onClick: onClick
  }, children);
};

exports.Link = Link;
Link.displayName = 'Link';
Link.propTypes = {
  children: _propTypes["default"].node.isRequired,
  id: _propTypes["default"].string.isRequired,
  name: _propTypes["default"].string.isRequired,
  isLeaf: _propTypes["default"].bool.isRequired,
  prefix: _propTypes["default"].string.isRequired,
  onKeyUp: _propTypes["default"].func.isRequired,
  onClick: _propTypes["default"].func.isRequired,
  childIds: _propTypes["default"].arrayOf(_propTypes["default"].string),
  isExpanded: _propTypes["default"].bool
};
Link.defaultProps = {
  childIds: null,
  isExpanded: false
};

var _ref4 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  loading: true
});

var _ref5 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  loading: true
});

var _ref6 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 1,
  loading: true
});

var _ref7 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 1,
  loading: true
});

var _ref8 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 2,
  loading: true
});

var _ref9 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 3,
  loading: true
});

var _ref10 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 3,
  loading: true
});

var _ref11 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 3,
  loading: true
});

var _ref12 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 1,
  loading: true
});

var _ref13 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 1,
  loading: true
});

var _ref14 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 1,
  loading: true
});

var _ref15 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 2,
  loading: true
});

var _ref16 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 2,
  loading: true
});

var _ref17 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 2,
  loading: true
});

var _ref18 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  depth: 3,
  loading: true
});

var _ref19 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  loading: true
});

var _ref20 =
/*#__PURE__*/
_react["default"].createElement(_SidebarItem["default"], {
  loading: true
});

var _ref21 =
/*#__PURE__*/
_react["default"].createElement(_components.Placeholder, {
  key: "empty"
}, _react["default"].createElement(_react.Fragment, {
  key: "title"
}, "No stories found"), _react["default"].createElement(_react.Fragment, null, "Learn how to\xA0", _react["default"].createElement(_components.Link, {
  href: "https://storybook.js.org/basics/writing-stories/",
  target: "_blank"
}, "write stories")));

var SidebarStories = (0, _react.memo)(function (_ref3) {
  var stories = _ref3.stories,
      storyId = _ref3.storyId,
      loading = _ref3.loading,
      className = _ref3.className,
      rest = _objectWithoutProperties(_ref3, ["stories", "storyId", "loading", "className"]);

  var list = Object.entries(stories);

  if (loading) {
    return _react["default"].createElement(Wrapper, {
      className: className
    }, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9, _ref10, _ref11, _ref12, _ref13, _ref14, _ref15, _ref16, _ref17, _ref18, _ref19, _ref20);
  }

  if (list.length < 1) {
    return _react["default"].createElement(Wrapper, {
      className: className
    }, _ref21);
  }

  return _react["default"].createElement(Wrapper, {
    className: className
  }, _react["default"].createElement(_treeview.TreeState, _extends({
    key: "treestate",
    dataset: stories,
    prefix: "explorer",
    selectedId: storyId,
    filter: "",
    List: List,
    Head: _SidebarItem["default"],
    Link: Link,
    Leaf: _SidebarItem["default"],
    Title: Subheading,
    Section: Section,
    Message: _components.Placeholder // eslint-disable-next-line react/jsx-no-duplicate-props
    ,
    Filter: Search
  }, rest)));
});
var _default = SidebarStories;
exports["default"] = _default;