"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _polished = require("polished");

var _theming = require("@storybook/theming");

var Subheading = _theming.styled.div(function (_ref) {
  var theme = _ref.theme;
  return {
    letterSpacing: '0.35em',
    textTransform: 'uppercase',
    fontWeight: theme.typography.weight.black,
    fontSize: theme.typography.size.s1 - 1,
    lineHeight: '24px',
    color: (0, _polished.transparentize)(0.5, theme.color.defaultText)
  };
}); // issue #6098


Subheading.defaultProps = {
  className: 'sidebar-subheading'
};
var _default = Subheading;
exports["default"] = _default;