"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Issue_1 = require("../Issue");
var IssueOrigin_1 = require("../IssueOrigin");
var IssueSeverity_1 = require("../IssueSeverity");
/**
 * Based on the TypeScript source - not used directly from the `typescript`
 * package as there is an option to pass a custom TypeScript instance.
 */
function flattenDiagnosticMessageText(messageText) {
    if (typeof messageText === 'string') {
        return messageText;
    }
    else {
        var diagnosticChain = messageText;
        var flattenMessageText = '';
        var indent = 0;
        while (diagnosticChain) {
            if (indent) {
                flattenMessageText += '\n';
                for (var i = 0; i < indent; i++) {
                    flattenMessageText += '  ';
                }
            }
            flattenMessageText += diagnosticChain.messageText;
            indent++;
            diagnosticChain = diagnosticChain.next;
        }
        return flattenMessageText;
    }
}
function createIssueFromTsDiagnostic(diagnostic) {
    var file;
    var line;
    var character;
    if (diagnostic.file) {
        file = diagnostic.file.fileName;
        if (diagnostic.start) {
            var position = diagnostic.file.getLineAndCharacterOfPosition(diagnostic.start);
            line = position.line + 1;
            character = position.character + 1;
        }
    }
    return {
        origin: IssueOrigin_1.IssueOrigin.TYPESCRIPT,
        code: String(diagnostic.code),
        // we don't handle Suggestion and Message diagnostics
        severity: diagnostic.category === 0 ? IssueSeverity_1.IssueSeverity.WARNING : IssueSeverity_1.IssueSeverity.ERROR,
        message: flattenDiagnosticMessageText(diagnostic.messageText),
        file: file,
        line: line,
        character: character
    };
}
exports.createIssueFromTsDiagnostic = createIssueFromTsDiagnostic;
function createIssuesFromTsDiagnostics(diagnostic) {
    return Issue_1.deduplicateAndSortIssues(diagnostic.map(createIssueFromTsDiagnostic));
}
exports.createIssuesFromTsDiagnostics = createIssuesFromTsDiagnostics;
//# sourceMappingURL=TypeScriptIssueFactory.js.map