'use strict'

function asReqValue (req) {
  return {
    method: req.method,
    url: req.url,
    headers: req.headers,
    remoteAddress: req.connection && req.connection.remoteAddress,
    remotePort: req.connection && req.connection.remotePort
  }
}

function asResValue (res) {
  return {
    statusCode: res.statusCode,
    header: res._header
  }
}

function mapHttpRequest (req) {
  return {
    req: asReqValue(req)
  }
}

function mapHttpResponse (res) {
  return {
    res: asResValue(res)
  }
}

function asErrValue (err) {
  var obj = {
    type: err.constructor.name,
    message: err.message,
    stack: err.stack
  }
  for (var key in err) {
    if (obj[key] === undefined) {
      obj[key] = err[key]
    }
  }
  return obj
}

module.exports = {
  asReqValue: asReqValue,
  asResValue: asResValue,
  mapHttpRequest: mapHttpRequest,
  mapHttpResponse: mapHttpResponse,
  asErrValue: asErrValue
}
