/**
 * Returns the name of the event at a specified event record index
 * @param {KeyEventType} keyEventType
 * @returns {KeyEventName} Name of the key event
 */
function describeKeyEventType(keyEventType) {
  switch (parseInt(keyEventType, 10)) {
    case 0:
      return 'keydown';

    case 1:
      return 'keypress';

    default:
      return 'keyup';
  }
}

export default describeKeyEventType;