import isUndefined from '../../utils/isUndefined';
/**
 * Returns whether the specified component's focus tree ID indicates it is a focus-only
 * HotKeys component, or not
 * @param {FocusTreeId} focusTreeId The focus tree id for the component
 * @returns {boolean} Whether the HotKeys component is focus-only
 */

function isFromFocusOnlyComponent(focusTreeId) {
  return !isUndefined(focusTreeId);
}

export default isFromFocusOnlyComponent;