import AltShiftedKeysDictionary from '../../const/AltShiftedKeysDictionary';
/**
 * Returns the corresponding symbol or character for a particular key, when it is
 * pressed with the alt and shift keys also held down
 * @param {NormalizedKeyName} keyName Name of the key
 * @returns {ReactKeyName[]} Symbol or character for the key, when it is pressed with the
 *          alt and shit keys
 */

function resolveAltShiftedAlias(keyName) {
  return AltShiftedKeysDictionary[keyName] || [keyName];
}

export default resolveAltShiftedAlias;