"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var bs_logger_1 = require("bs-logger");
var fs_1 = require("fs");
var json5 = require("json5");
var path_1 = require("path");
var semver = require("semver");
var __1 = require("..");
var compiler_1 = require("../compiler");
var transformers_1 = require("../transformers");
var backports_1 = require("../util/backports");
var get_package_version_1 = require("../util/get-package-version");
var importer_1 = require("../util/importer");
var json_1 = require("../util/json");
var jsonable_value_1 = require("../util/jsonable-value");
var logger_1 = require("../util/logger");
var memoize_1 = require("../util/memoize");
var messages_1 = require("../util/messages");
var normalize_slashes_1 = require("../util/normalize-slashes");
var sha1_1 = require("../util/sha1");
var ts_error_1 = require("../util/ts-error");
var logger = logger_1.rootLogger.child({ namespace: 'config' });
exports.MATCH_NOTHING = /a^/;
exports.IGNORE_DIAGNOSTIC_CODES = [
    6059,
    18002,
    18003,
];
var DiagnosticCodes;
(function (DiagnosticCodes) {
    DiagnosticCodes[DiagnosticCodes["TsJest"] = 151000] = "TsJest";
    DiagnosticCodes[DiagnosticCodes["ConfigModuleOption"] = 151001] = "ConfigModuleOption";
})(DiagnosticCodes = exports.DiagnosticCodes || (exports.DiagnosticCodes = {}));
var normalizeRegex = function (pattern) {
    return pattern ? (typeof pattern === 'string' ? pattern : pattern.source) : undefined;
};
var toDiagnosticCode = function (code) {
    return code ? parseInt(("" + code).trim().replace(/^TS/, ''), 10) || undefined : undefined;
};
var toDiagnosticCodeList = function (items, into) {
    var e_1, _a;
    if (into === void 0) { into = []; }
    if (!Array.isArray(items))
        items = [items];
    try {
        for (var items_1 = __values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
            var item = items_1_1.value;
            if (!item)
                continue;
            if (Array.isArray(item)) {
                toDiagnosticCodeList(item, into);
                continue;
            }
            else if (typeof item === 'string') {
                var children = item.trim().split(/\s*,\s*/g);
                if (children.length > 1) {
                    toDiagnosticCodeList(children, into);
                    continue;
                }
                item = children[0];
            }
            if (!item)
                continue;
            var code = toDiagnosticCode(item);
            if (code && !into.includes(code))
                into.push(code);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (items_1_1 && !items_1_1.done && (_a = items_1.return)) _a.call(items_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return into;
};
var ConfigSet = (function () {
    function ConfigSet(jestConfig, parentOptions, parentLogger) {
        var _a;
        this.parentOptions = parentOptions;
        this._jestConfig = jestConfig;
        this.logger = parentLogger ? parentLogger.child((_a = {}, _a[bs_logger_1.LogContexts.namespace] = 'config', _a)) : logger;
    }
    Object.defineProperty(ConfigSet.prototype, "projectPackageJson", {
        get: function () {
            var packageJson = this.tsJest.packageJson;
            if (packageJson && packageJson.kind === 'inline') {
                return packageJson.value;
            }
            if (packageJson && packageJson.kind === 'file' && packageJson.value) {
                var path = this.resolvePath(packageJson.value);
                if (fs_1.existsSync(path)) {
                    return require(path);
                }
                this.logger.warn(messages_1.Errors.UnableToFindProjectRoot);
                return {};
            }
            var tsJestRoot = path_1.resolve(__dirname, '..', '..');
            var pkgPath = path_1.resolve(tsJestRoot, '..', '..', 'package.json');
            if (fs_1.existsSync(pkgPath)) {
                return require(pkgPath);
            }
            if (fs_1.realpathSync(this.rootDir) === fs_1.realpathSync(tsJestRoot)) {
                pkgPath = path_1.resolve(tsJestRoot, 'package.json');
                if (fs_1.existsSync(pkgPath)) {
                    return require(pkgPath);
                }
            }
            this.logger.warn(messages_1.Errors.UnableToFindProjectRoot);
            return {};
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "projectDependencies", {
        get: function () {
            var pkg = this.projectPackageJson;
            var names = Object.keys(__assign(__assign(__assign(__assign({}, pkg.optionalDependencies), pkg.peerDependencies), pkg.devDependencies), pkg.dependencies));
            return names.reduce(function (map, name) {
                var version = get_package_version_1.getPackageVersion(name);
                if (version)
                    map[name] = version;
                return map;
            }, {});
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "jest", {
        get: function () {
            var config = backports_1.backportJestConfig(this.logger, this._jestConfig);
            if (this.parentOptions) {
                var globals = config.globals || (config.globals = {});
                globals['ts-jest'] = __assign(__assign({}, this.parentOptions), globals['ts-jest']);
            }
            this.logger.debug({ jestConfig: config }, 'normalized jest config');
            return config;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsJest", {
        get: function () {
            var _this = this;
            var parsedConfig = this.jest;
            var _a = parsedConfig.globals, globals = _a === void 0 ? {} : _a;
            var options = __assign({}, globals['ts-jest']);
            var tsConfigOpt = options.tsConfig;
            var tsConfig;
            if (typeof tsConfigOpt === 'string' || tsConfigOpt == null || tsConfigOpt === true) {
                tsConfig = {
                    kind: 'file',
                    value: typeof tsConfigOpt === 'string' ? this.resolvePath(tsConfigOpt) : undefined,
                };
            }
            else if (typeof tsConfigOpt === 'object') {
                tsConfig = {
                    kind: 'inline',
                    value: tsConfigOpt,
                };
            }
            var packageJsonOpt = options.packageJson;
            var packageJson;
            if (typeof packageJsonOpt === 'string' || packageJsonOpt == null || packageJsonOpt === true) {
                packageJson = {
                    kind: 'file',
                    value: typeof packageJsonOpt === 'string' ? this.resolvePath(packageJsonOpt) : undefined,
                };
            }
            else if (typeof packageJsonOpt === 'object') {
                packageJson = {
                    kind: 'inline',
                    value: packageJsonOpt,
                };
            }
            var transformers = (options.astTransformers || []).map(function (mod) { return _this.resolvePath(mod, { nodeResolve: true }); });
            var babelConfigOpt = options.babelConfig;
            var babelConfig;
            if (typeof babelConfigOpt === 'string' || babelConfigOpt === true) {
                babelConfig = {
                    kind: 'file',
                    value: babelConfigOpt === true ? undefined : this.resolvePath(babelConfigOpt),
                };
            }
            else if (babelConfigOpt) {
                babelConfig = {
                    kind: 'inline',
                    value: babelConfigOpt,
                };
            }
            var diagnostics;
            var _b = options.diagnostics, diagnosticsOpt = _b === void 0 ? true : _b;
            var ignoreList = [exports.IGNORE_DIAGNOSTIC_CODES, process.env.TS_JEST_IGNORE_DIAGNOSTICS];
            if (diagnosticsOpt === true || diagnosticsOpt == null) {
                diagnostics = { ignoreCodes: [], pretty: true, throws: true };
            }
            else if (diagnosticsOpt === false) {
                diagnostics = {
                    throws: false,
                    pretty: true,
                    ignoreCodes: [],
                    pathRegex: exports.MATCH_NOTHING.source,
                };
            }
            else {
                ignoreList.push(diagnosticsOpt.ignoreCodes);
                diagnostics = {
                    pretty: diagnosticsOpt.pretty == null ? true : !!diagnosticsOpt.pretty,
                    ignoreCodes: [],
                    pathRegex: normalizeRegex(diagnosticsOpt.pathRegex),
                    throws: !diagnosticsOpt.warnOnly,
                };
            }
            diagnostics.ignoreCodes = toDiagnosticCodeList(ignoreList);
            var stringifyContentPathRegex = normalizeRegex(options.stringifyContentPathRegex);
            var res = {
                tsConfig: tsConfig,
                packageJson: packageJson,
                babelConfig: babelConfig,
                diagnostics: diagnostics,
                isolatedModules: !!options.isolatedModules,
                compiler: options.compiler || 'typescript',
                transformers: transformers,
                stringifyContentPathRegex: stringifyContentPathRegex,
            };
            this.logger.debug({ tsJestConfig: res }, 'normalized ts-jest config');
            return res;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "typescript", {
        get: function () {
            return this._typescript.resolved;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsconfig", {
        get: function () {
            return this._typescript.input;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "versions", {
        get: function () {
            var modules = ['jest', this.tsJest.compiler];
            if (this.tsJest.babelConfig) {
                modules.push('@babel/core', 'babel-jest');
            }
            return modules.reduce(function (map, name) {
                map[name] = get_package_version_1.getPackageVersion(name) || '-';
                return map;
            }, { 'ts-jest': __1.version });
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "_typescript", {
        get: function () {
            var tsConfig = this.tsJest.tsConfig;
            var configFilePath = tsConfig && tsConfig.kind === 'file' ? tsConfig.value : undefined;
            var result = this.readTsConfig(tsConfig && tsConfig.kind === 'inline' ? tsConfig.value : undefined, configFilePath, tsConfig == null);
            this.raiseDiagnostics(result.resolved.errors, configFilePath);
            this.logger.debug({ tsconfig: result }, 'normalized typescript config');
            return result;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "raiseDiagnostics", {
        get: function () {
            var _this = this;
            var _a = this, createTsError = _a.createTsError, filterDiagnostics = _a.filterDiagnostics, throws = _a.tsJest.diagnostics.throws, DiagnosticCategory = _a.compilerModule.DiagnosticCategory;
            return function (diagnostics, filePath, logger) {
                if (logger === void 0) { logger = _this.logger; }
                var filteredDiagnostics = filterDiagnostics(diagnostics, filePath);
                if (filteredDiagnostics.length === 0)
                    return;
                var error = createTsError(filteredDiagnostics);
                var importantCategories = [DiagnosticCategory.Warning, DiagnosticCategory.Error];
                if (throws && filteredDiagnostics.some(function (d) { return importantCategories.includes(d.category); })) {
                    throw error;
                }
                logger.warn({ error: error }, error.message);
            };
        },
        enumerable: true,
        configurable: true
    });
    ConfigSet.loadConfig = function (base) {
        var _a = importer_1.importer.babelCore(messages_1.ImportReasons.BabelJest), OptionManager = _a.OptionManager, loadPartialConfig = _a.loadPartialConfig, version = _a.version;
        if (version && semver.satisfies(version, '>=6 <7')) {
            delete base.cwd;
        }
        if (typeof loadPartialConfig === 'function') {
            var partialConfig = loadPartialConfig(base);
            if (partialConfig) {
                return partialConfig.options;
            }
        }
        return new OptionManager().init(base);
    };
    Object.defineProperty(ConfigSet.prototype, "babel", {
        get: function () {
            var babelConfig = this.tsJest.babelConfig;
            if (babelConfig == null) {
                this.logger.debug('babel is disabled');
                return;
            }
            var base = { cwd: this.cwd };
            if (babelConfig.kind === 'file') {
                if (babelConfig.value) {
                    if (path_1.extname(babelConfig.value) === '.js') {
                        base = __assign(__assign({}, base), require(babelConfig.value));
                    }
                    else {
                        base = __assign(__assign({}, base), json5.parse(fs_1.readFileSync(babelConfig.value, 'utf8')));
                    }
                }
            }
            else if (babelConfig.kind === 'inline') {
                base = __assign(__assign({}, base), babelConfig.value);
            }
            var config = ConfigSet.loadConfig(base);
            this.logger.debug({ babelConfig: config }, 'normalized babel config');
            return config;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "compilerModule", {
        get: function () {
            return importer_1.importer.typescript(messages_1.ImportReasons.TsJest, this.tsJest.compiler);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "babelJestTransformer", {
        get: function () {
            var babel = this.babel;
            if (!babel)
                return;
            this.logger.debug('creating babel-jest transformer');
            return importer_1.importer.babelJest(messages_1.ImportReasons.BabelJest).createTransformer(babel);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsCompiler", {
        get: function () {
            return compiler_1.createCompiler(this);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "astTransformers", {
        get: function () {
            return __spread(transformers_1.internals, this.tsJest.transformers.map(function (m) { return require(m); }));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsCustomTransformers", {
        get: function () {
            var _this = this;
            return {
                before: this.astTransformers.map(function (t) { return t.factory(_this); }),
            };
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "hooks", {
        get: function () {
            var hooksFile = process.env.TS_JEST_HOOKS;
            if (hooksFile) {
                hooksFile = path_1.resolve(this.cwd, hooksFile);
                return importer_1.importer.tryTheseOr(hooksFile, {});
            }
            return {};
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "filterDiagnostics", {
        get: function () {
            var _a = this, ignoreCodes = _a.tsJest.diagnostics.ignoreCodes, shouldReportDiagnostic = _a.shouldReportDiagnostic;
            return function (diagnostics, filePath) {
                if (filePath && !shouldReportDiagnostic(filePath))
                    return [];
                return diagnostics.filter(function (diagnostic) {
                    if (diagnostic.file && diagnostic.file.fileName && !shouldReportDiagnostic(diagnostic.file.fileName)) {
                        return false;
                    }
                    return ignoreCodes.indexOf(diagnostic.code) === -1;
                });
            };
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "shouldReportDiagnostic", {
        get: function () {
            var pathRegex = this.tsJest.diagnostics.pathRegex;
            if (pathRegex) {
                var regex_1 = new RegExp(pathRegex);
                return function (file) { return regex_1.test(file); };
            }
            else {
                return function () { return true; };
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "shouldStringifyContent", {
        get: function () {
            var stringifyContentPathRegex = this.tsJest.stringifyContentPathRegex;
            if (stringifyContentPathRegex) {
                var regex_2 = new RegExp(stringifyContentPathRegex);
                return function (file) { return regex_2.test(file); };
            }
            else {
                return function () { return false; };
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "createTsError", {
        get: function () {
            var _this = this;
            var pretty = this.tsJest.diagnostics.pretty;
            var formatDiagnostics = pretty
                ? this.compilerModule.formatDiagnosticsWithColorAndContext
                : this.compilerModule.formatDiagnostics;
            var diagnosticHost = {
                getNewLine: function () { return '\n'; },
                getCurrentDirectory: function () { return _this.cwd; },
                getCanonicalFileName: function (path) { return path; },
            };
            return function (diagnostics) {
                var diagnosticText = formatDiagnostics(diagnostics, diagnosticHost);
                var diagnosticCodes = diagnostics.map(function (x) { return x.code; });
                return new ts_error_1.TSError(diagnosticText, diagnosticCodes);
            };
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsCacheDir", {
        get: function () {
            if (!this.jest.cache) {
                logger.debug('file caching disabled');
                return;
            }
            var cacheSuffix = sha1_1.sha1(json_1.stringify({
                version: this.compilerModule.version,
                digest: this.tsJestDigest,
                dependencies: this.projectDependencies,
                compiler: this.tsJest.compiler,
                compilerOptions: this.typescript.options,
                isolatedModules: this.tsJest.isolatedModules,
                diagnostics: this.tsJest.diagnostics,
            }));
            var res = path_1.join(this.jest.cacheDirectory, 'ts-jest', cacheSuffix.substr(0, 2), cacheSuffix.substr(2));
            logger.debug({ cacheDirectory: res }, 'will use file caching');
            return res;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "overriddenCompilerOptions", {
        get: function () {
            var options = {
                sourceMap: true,
                inlineSourceMap: false,
                inlineSources: true,
                declaration: false,
                noEmit: false,
                outDir: '$$ts-jest$$',
                removeComments: false,
                out: undefined,
                outFile: undefined,
                composite: undefined,
                declarationDir: undefined,
                declarationMap: undefined,
                emitDeclarationOnly: undefined,
                incremental: undefined,
                sourceRoot: undefined,
                tsBuildInfoFile: undefined,
            };
            if (!this.tsJest.babelConfig) {
                options.module = this.compilerModule.ModuleKind.CommonJS;
            }
            return options;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "rootDir", {
        get: function () {
            return path_1.normalize(this.jest.rootDir || this.cwd);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "cwd", {
        get: function () {
            return path_1.normalize(this.jest.cwd || process.cwd());
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "isDoctoring", {
        get: function () {
            return !!process.env.TS_JEST_DOCTOR;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsJestDigest", {
        get: function () {
            return __1.digest;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "jsonValue", {
        get: function () {
            var jest = __assign({}, this.jest);
            var globals = (jest.globals = __assign({}, jest.globals));
            delete jest.name;
            delete jest.cacheDirectory;
            delete globals['ts-jest'];
            return new jsonable_value_1.JsonableValue({
                versions: this.versions,
                projectDepVersions: this.projectDependencies,
                digest: this.tsJestDigest,
                transformers: this.astTransformers.map(function (t) { return t.name + "@" + t.version; }),
                jest: jest,
                tsJest: this.tsJest,
                babel: this.babel,
                tsconfig: this.typescript.options,
            });
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "cacheKey", {
        get: function () {
            return this.jsonValue.serialized;
        },
        enumerable: true,
        configurable: true
    });
    ConfigSet.prototype.makeDiagnostic = function (code, messageText, options) {
        if (options === void 0) { options = {}; }
        var _a = options.category, category = _a === void 0 ? this.compilerModule.DiagnosticCategory.Warning : _a, file = options.file, start = options.start, length = options.length;
        return {
            code: code,
            messageText: messageText,
            category: category,
            file: file,
            start: start,
            length: length,
        };
    };
    ConfigSet.prototype.readTsConfig = function (compilerOptions, resolvedConfigFile, noProject) {
        var e_2, _a;
        var config = { compilerOptions: {} };
        var basePath = normalize_slashes_1.normalizeSlashes(this.rootDir);
        var configFileName;
        var ts = this.compilerModule;
        var input;
        if (noProject) {
            input = { compilerOptions: __assign({}, compilerOptions) };
        }
        else {
            configFileName = resolvedConfigFile
                ? normalize_slashes_1.normalizeSlashes(resolvedConfigFile)
                : ts.findConfigFile(normalize_slashes_1.normalizeSlashes(this.rootDir), ts.sys.fileExists);
            if (configFileName) {
                this.logger.debug({ tsConfigFileName: configFileName }, 'readTsConfig(): reading', configFileName);
                var result_1 = ts.readConfigFile(configFileName, ts.sys.readFile);
                if (result_1.error) {
                    return {
                        resolved: { errors: [result_1.error], fileNames: [], options: {} },
                    };
                }
                config = result_1.config;
                input = __assign(__assign({}, result_1.config), { compilerOptions: __assign(__assign({}, (result_1.config && result_1.config.compilerOptions)), compilerOptions) });
                basePath = normalize_slashes_1.normalizeSlashes(path_1.dirname(configFileName));
            }
        }
        config.compilerOptions = __assign(__assign({}, config.compilerOptions), compilerOptions);
        var result = ts.parseJsonConfigFileContent(config, ts.sys, basePath, undefined, configFileName);
        var forcedOptions = this.overriddenCompilerOptions;
        var finalOptions = result.options;
        if (finalOptions.target === undefined) {
            finalOptions.target = ts.ScriptTarget.ES5;
        }
        var target = finalOptions.target;
        var defaultModule = [ts.ScriptTarget.ES3, ts.ScriptTarget.ES5].includes(target)
            ? ts.ModuleKind.CommonJS
            : ts.ModuleKind.ESNext;
        var moduleValue = finalOptions.module == null ? defaultModule : finalOptions.module;
        if ('module' in forcedOptions &&
            moduleValue !== forcedOptions.module &&
            !(finalOptions.esModuleInterop || finalOptions.allowSyntheticDefaultImports)) {
            result.errors.push(this.makeDiagnostic(DiagnosticCodes.ConfigModuleOption, messages_1.Errors.ConfigNoModuleInterop, {
                category: ts.DiagnosticCategory.Message,
            }));
            if (!('allowSyntheticDefaultImports' in config.compilerOptions)) {
                finalOptions.allowSyntheticDefaultImports = true;
            }
        }
        try {
            for (var _b = __values(Object.keys(forcedOptions)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                var val = forcedOptions[key];
                if (val === undefined) {
                    delete finalOptions[key];
                }
                else {
                    finalOptions[key] = val;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return { input: input, resolved: result };
    };
    ConfigSet.prototype.resolvePath = function (inputPath, _a) {
        var _b = _a === void 0 ? {} : _a, _c = _b.throwIfMissing, throwIfMissing = _c === void 0 ? true : _c, _d = _b.nodeResolve, nodeResolve = _d === void 0 ? false : _d;
        var path = inputPath;
        var nodeResolved = false;
        if (path.startsWith('<rootDir>')) {
            path = path_1.resolve(path_1.join(this.rootDir, path.substr(9)));
        }
        else if (!path_1.isAbsolute(path)) {
            if (!path.startsWith('.') && nodeResolve) {
                try {
                    path = require.resolve(path);
                    nodeResolved = true;
                }
                catch (_) { }
            }
            if (!nodeResolved) {
                path = path_1.resolve(this.cwd, path);
            }
        }
        if (!nodeResolved && nodeResolve) {
            try {
                path = require.resolve(path);
                nodeResolved = true;
            }
            catch (_) { }
        }
        if (throwIfMissing && !fs_1.existsSync(path)) {
            throw new Error(messages_1.interpolate(messages_1.Errors.FileNotFound, { inputPath: inputPath, resolvedPath: path }));
        }
        this.logger.debug({ fromPath: inputPath, toPath: path }, 'resolved path from', inputPath, 'to', path);
        return path;
    };
    ConfigSet.prototype.toJSON = function () {
        return this.jsonValue.value;
    };
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "projectPackageJson", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "projectDependencies", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "jest", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsJest", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "versions", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "_typescript", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "raiseDiagnostics", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "babel", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "compilerModule", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "babelJestTransformer", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsCompiler", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "astTransformers", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsCustomTransformers", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "hooks", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "filterDiagnostics", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "shouldReportDiagnostic", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "shouldStringifyContent", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "createTsError", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsCacheDir", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "overriddenCompilerOptions", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "rootDir", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "cwd", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsJestDigest", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "jsonValue", null);
    return ConfigSet;
}());
exports.ConfigSet = ConfigSet;
