"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var pug = __importStar(require("pug"));
var vue_template_compiler_1 = require("vue-template-compiler");
var cacher_1 = __importDefault(require("./utils/cacher"));
function parseTemplate(tpl, documentation, handlers, filePath) {
    if (tpl && tpl.content) {
        var template_1 = tpl.attrs && tpl.attrs.lang === 'pug'
            ? pug.render(tpl.content, { filename: filePath })
            : tpl.content;
        var ast = cacher_1.default(function () { return vue_template_compiler_1.compile(template_1, { comments: true, optimize: false }).ast; }, template_1);
        var functional = !!tpl.attrs.functional;
        if (functional) {
            documentation.set('functional', functional);
        }
        var rootLeadingComment = extractRootLeadingComments(template_1);
        if (ast) {
            traverse(ast, documentation, handlers, {
                functional: functional,
                rootLeadingComment: rootLeadingComment
            });
        }
    }
}
exports.default = parseTemplate;
function traverse(templateAst, documentation, handlers, options) {
    var traverseAstChildren = function (templateAst) {
        var children = templateAst.children;
        if (children) {
            for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
                var childNode = children_1[_i];
                if (isASTElement(childNode)) {
                    traverse(childNode, documentation, handlers, options);
                }
            }
        }
        var scopedSlots = templateAst.scopedSlots;
        if (scopedSlots) {
            Object.keys(scopedSlots).forEach(function (key) {
                var slotNode = scopedSlots[key];
                if (isASTElement(slotNode)) {
                    traverse(slotNode, documentation, handlers, options);
                }
            });
        }
    };
    if (templateAst.type === 1) {
        handlers.forEach(function (handler) {
            handler(documentation, templateAst, options);
        });
        if (templateAst.if && templateAst.ifConditions) {
            // for if statement iterate through the branches
            templateAst.ifConditions.forEach(function (_a) {
                var block = _a.block;
                traverseAstChildren(block);
            });
        }
        else {
            traverseAstChildren(templateAst);
        }
    }
}
exports.traverse = traverse;
function isASTElement(node) {
    return !!node && node.children !== undefined;
}
function extractRootLeadingComments(template) {
    var t = template.trim();
    var comments = [];
    while (/^<!--/.test(t)) {
        var endOfRootLeadingComment = t.indexOf('-->');
        var rootLeadingComment = t.slice(4, endOfRootLeadingComment).trim();
        comments.push(rootLeadingComment);
        t = t.slice(endOfRootLeadingComment + 3).trim();
    }
    return comments;
}
