"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var recast_1 = __importDefault(require("recast"));
var getDocblock_1 = __importDefault(require("../utils/getDocblock"));
var getDoclets_1 = __importDefault(require("../utils/getDoclets"));
var resolveIdentifier_1 = __importDefault(require("../utils/resolveIdentifier"));
function eventHandler(documentation, path, astPath) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            recast_1.default.visit(path.node, {
                visitCallExpression: function (pathExpression) {
                    if (bt.isMemberExpression(pathExpression.node.callee) &&
                        bt.isThisExpression(pathExpression.node.callee.object) &&
                        bt.isIdentifier(pathExpression.node.callee.property) &&
                        pathExpression.node.callee.property.name === '$emit') {
                        var args = pathExpression.node.arguments;
                        if (!args.length) {
                            return false;
                        }
                        // fetch the leading comments on the wrapping expression
                        var docblock = getDocblock_1.default(pathExpression.parentPath);
                        var doclets = getDoclets_1.default(docblock || '');
                        var eventName = void 0;
                        var eventTags = doclets.tags ? doclets.tags.filter(function (d) { return d.title === 'event'; }) : [];
                        // if someone wants to document it with anything else, they can force it
                        if (eventTags.length) {
                            eventName = eventTags[0].content;
                        }
                        else {
                            var firstArg = pathExpression.get('arguments', 0);
                            if (bt.isIdentifier(firstArg.node)) {
                                firstArg = resolveIdentifier_1.default(astPath, firstArg);
                            }
                            if (!firstArg || !bt.isStringLiteral(firstArg.node)) {
                                return false;
                            }
                            eventName = firstArg.node.value;
                        }
                        // if this event is documented somewhere else leave it alone
                        var evtDescriptor = documentation.getEventDescriptor(eventName);
                        setEventDescriptor(evtDescriptor, doclets);
                        if (args.length > 1 && !evtDescriptor.type) {
                            evtDescriptor.type = {
                                names: ['undefined']
                            };
                        }
                        if (args.length > 2 && !evtDescriptor.properties) {
                            evtDescriptor.properties = [];
                        }
                        if (evtDescriptor.properties && evtDescriptor.properties.length < args.length - 2) {
                            var i = args.length - 2 - evtDescriptor.properties.length;
                            while (i--) {
                                evtDescriptor.properties.push({
                                    type: { names: ['undefined'] },
                                    name: "<anonymous" + (args.length - i - 2) + ">"
                                });
                            }
                        }
                        return false;
                    }
                    this.traverse(pathExpression);
                }
            });
            return [2 /*return*/];
        });
    });
}
exports.default = eventHandler;
/**
 * Accepted tags for conveying event properties
 */
var PROPERTY_TAGS = ['property', 'arg', 'arguments', 'param'];
function setEventDescriptor(eventDescriptor, jsDoc) {
    if (jsDoc.description && jsDoc.description.length) {
        eventDescriptor.description = jsDoc.description;
    }
    var nonNullTags = jsDoc.tags ? jsDoc.tags : [];
    var typeTags = nonNullTags.filter(function (tg) { return tg.title === 'type'; });
    eventDescriptor.type = typeTags.length
        ? { names: typeTags.map(function (t) { return t.type.name; }) }
        : undefined;
    var propertyTags = nonNullTags.filter(function (tg) { return PROPERTY_TAGS.includes(tg.title); });
    if (propertyTags.length) {
        eventDescriptor.properties = propertyTags.map(function (tg) {
            return { type: { names: [tg.type.name] }, name: tg.name, description: tg.description };
        });
    }
    // remove the property an type tags from the tag array
    var tags = nonNullTags.filter(function (tg) { return tg.title !== 'type' && tg.title !== 'property' && tg.title !== 'event'; });
    if (tags.length) {
        eventDescriptor.tags = tags;
    }
    else {
        delete eventDescriptor.tags;
    }
    return eventDescriptor;
}
exports.setEventDescriptor = setEventDescriptor;
