"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var getDocblock_1 = __importDefault(require("../utils/getDocblock"));
var getDoclets_1 = __importDefault(require("../utils/getDoclets"));
var getTypeFromAnnotation_1 = __importDefault(require("../utils/getTypeFromAnnotation"));
var transformTagsIntoObject_1 = __importDefault(require("../utils/transformTagsIntoObject"));
var getPropsFilter_1 = __importDefault(require("../utils/getPropsFilter"));
function methodHandler(documentation, path) {
    return __awaiter(this, void 0, void 0, function () {
        var methodsPath, methodsObject;
        return __generator(this, function (_a) {
            if (bt.isObjectExpression(path.node)) {
                methodsPath = path
                    .get('properties')
                    .filter(function (p) { return bt.isObjectProperty(p.node) && getPropsFilter_1.default('methods')(p); });
                // if no method return
                if (!methodsPath.length) {
                    return [2 /*return*/];
                }
                methodsObject = methodsPath[0].get('value');
                if (bt.isObjectExpression(methodsObject.node)) {
                    methodsObject.get('properties').each(function (p) {
                        var methodName = '<anonymous>';
                        if (bt.isObjectProperty(p.node)) {
                            var val = p.get('value');
                            methodName = p.node.key.name;
                            if (!Array.isArray(val)) {
                                p = val;
                            }
                        }
                        if (bt.isFunction(p.node)) {
                            methodName = bt.isObjectMethod(p.node) ? p.node.key.name : methodName;
                            var docBlock = getDocblock_1.default(bt.isObjectMethod(p.node) ? p : p.parentPath);
                            var jsDoc = docBlock
                                ? getDoclets_1.default(docBlock)
                                : { description: '', tags: [] };
                            var jsDocTags = jsDoc.tags ? jsDoc.tags : [];
                            // ignore the method if there is no public tag
                            if (!jsDocTags.some(function (t) { return t.title === 'access' && t.content === 'public'; })) {
                                return;
                            }
                            var methodDescriptor = documentation.getMethodDescriptor(methodName);
                            if (jsDoc.description) {
                                methodDescriptor.description = jsDoc.description;
                            }
                            setMethodDescriptor(methodDescriptor, p, jsDocTags);
                        }
                    });
                }
            }
            return [2 /*return*/];
        });
    });
}
exports.default = methodHandler;
function setMethodDescriptor(methodDescriptor, method, jsDocTags) {
    // params
    describeParams(method, methodDescriptor, jsDocTags.filter(function (tag) { return ['param', 'arg', 'argument'].indexOf(tag.title) >= 0; }));
    // returns
    describeReturns(method, methodDescriptor, jsDocTags.filter(function (t) { return t.title === 'returns'; }));
    // tags
    methodDescriptor.tags = transformTagsIntoObject_1.default(jsDocTags);
    return methodDescriptor;
}
exports.setMethodDescriptor = setMethodDescriptor;
function describeParams(methodPath, methodDescriptor, jsDocParamTags) {
    // if there is no parameter no need to parse them
    var fExp = methodPath.node;
    if (!fExp.params.length && !jsDocParamTags.length) {
        return;
    }
    var params = [];
    fExp.params.forEach(function (par, i) {
        var name;
        if (bt.isIdentifier(par)) {
            // simple params
            name = par.name;
        }
        else if (bt.isIdentifier(par.left)) {
            // es6 default params
            name = par.left.name;
        }
        else {
            // unrecognized pattern
            return;
        }
        var jsDocTags = jsDocParamTags.filter(function (tag) { return tag.name === name; });
        var jsDocTag = jsDocTags.length ? jsDocTags[0] : undefined;
        // if tag is not namely described try finding it by its order
        if (!jsDocTag) {
            if (jsDocParamTags[i] && !jsDocParamTags[i].name) {
                jsDocTag = jsDocParamTags[i];
            }
        }
        var param = { name: name };
        if (jsDocTag) {
            if (jsDocTag.type) {
                param.type = jsDocTag.type;
            }
            if (jsDocTag.description) {
                param.description = jsDocTag.description;
            }
        }
        if (!param.type && par.typeAnnotation) {
            var type = getTypeFromAnnotation_1.default(par.typeAnnotation);
            if (type) {
                param.type = type;
            }
        }
        params.push(param);
    });
    // in case the arguments are abstracted (using the arguments keyword)
    if (!params.length) {
        jsDocParamTags.forEach(function (doc) {
            params.push(doc);
        });
    }
    if (params.length) {
        methodDescriptor.params = params;
    }
}
function describeReturns(methodPath, methodDescriptor, jsDocReturnTags) {
    if (jsDocReturnTags.length) {
        methodDescriptor.returns = jsDocReturnTags[0];
    }
    if (!methodDescriptor.returns || !methodDescriptor.returns.type) {
        var methodNode = methodPath.node;
        if (methodNode.returnType) {
            var type = getTypeFromAnnotation_1.default(methodNode.returnType);
            if (type) {
                methodDescriptor.returns = methodDescriptor.returns || {};
                methodDescriptor.returns.type = type;
            }
        }
    }
}
