"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var recast_1 = __importDefault(require("recast"));
var babel_parser_1 = __importDefault(require("../babel-parser"));
var extractLeadingComment_1 = __importDefault(require("../utils/extractLeadingComment"));
var getDoclets_1 = __importDefault(require("../utils/getDoclets"));
var eventHandler_1 = require("../script-handlers/eventHandler");
var parser = babel_parser_1.default({ plugins: ['typescript'] });
var allowRE = /^(v-on|@)/;
function eventHandler(documentation, templateAst, options) {
    var bindings = templateAst.attrsMap;
    var keys = Object.keys(bindings);
    for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
        var key = keys_1[_i];
        // only look at expressions
        if (allowRE.test(key)) {
            var expression = bindings[key];
            if (expression && expression.length) {
                getEventsFromExpression(templateAst.parent, templateAst, expression, documentation, options);
            }
        }
    }
}
exports.default = eventHandler;
function getEventsFromExpression(parentAst, item, expression, documentation, options) {
    // this allows for weird expressions like {[t]:val} to be parsed properly
    var ast = parser.parse("(() => (" + expression + "))()");
    var eventsFound = [];
    recast_1.default.visit(ast.program, {
        visitCallExpression: function (path) {
            var obj = path.node ? path.node.callee : undefined;
            var args = path.node ? path.node.arguments : undefined;
            if (obj && args && bt.isIdentifier(obj) && obj.name === '$emit' && args.length) {
                // TODO: resolve variable if any
                var evtName = bt.isStringLiteral(args[0]) ? args[0].value : '<undefined>';
                documentation.getEventDescriptor(evtName);
                eventsFound.push(evtName);
                return false;
            }
            this.traverse(path);
        }
    });
    if (eventsFound.length) {
        var leadingComments_1 = extractLeadingComment_1.default(parentAst, item, options.rootLeadingComment);
        if (leadingComments_1.length) {
            eventsFound.forEach(function (evtName) {
                leadingComments_1.forEach(function (comment) {
                    var doclets = getDoclets_1.default(comment);
                    var eventTags = doclets.tags && doclets.tags.filter(function (d) { return d.title === 'event'; });
                    if (!(eventTags &&
                        eventTags.length &&
                        eventTags.findIndex(function (et) { return et.content === evtName; }) > -1)) {
                        return;
                    }
                    var e = documentation.getEventDescriptor(evtName);
                    eventHandler_1.setEventDescriptor(e, doclets);
                });
            });
        }
    }
}
