"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var recast_1 = __importDefault(require("recast"));
var babel_parser_1 = __importDefault(require("../babel-parser"));
var extractLeadingComment_1 = __importDefault(require("../utils/extractLeadingComment"));
var getDoclets_1 = __importDefault(require("../utils/getDoclets"));
var parser = babel_parser_1.default({ plugins: ['typescript'] });
function propTemplateHandler(documentation, templateAst, options) {
    if (options.functional) {
        propsInAttributes(templateAst, documentation, options);
        propsInInterpolation(templateAst, documentation, options);
    }
}
exports.default = propTemplateHandler;
var allowRE = /^(v-bind|:|v-on|@)/;
function propsInAttributes(templateAst, documentation, options) {
    var bindings = templateAst.attrsMap;
    var keys = Object.keys(bindings);
    for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
        var key = keys_1[_i];
        // only look at expressions
        if (allowRE.test(key)) {
            var expression = bindings[key];
            if (expression && expression.length) {
                getPropsFromExpression(templateAst.parent, templateAst, expression, documentation, options);
            }
        }
    }
}
function propsInInterpolation(templateAst, documentation, options) {
    if (templateAst.children) {
        templateAst.children.filter(function (c) { return c.type === 2; }).forEach(function (expr) {
            getPropsFromExpression(templateAst, expr, expr.expression, documentation, options);
        });
    }
}
function getPropsFromExpression(parentAst, item, expression, documentation, options) {
    // this allows for weird expressions like {[t]:val} to be parsed properly
    var ast = parser.parse("(() => (" + expression + "))()");
    var propsFound = [];
    recast_1.default.visit(ast.program, {
        visitMemberExpression: function (path) {
            var obj = path.node ? path.node.object : undefined;
            var propName = path.node ? path.node.property : undefined;
            if (obj &&
                propName &&
                bt.isIdentifier(obj) &&
                obj.name === 'props' &&
                bt.isIdentifier(propName)) {
                var pName = propName.name;
                var p = documentation.getPropDescriptor(pName);
                propsFound.push(pName);
                p.type = { name: 'undefined' };
            }
            return false;
        }
    });
    if (propsFound.length) {
        var comments = extractLeadingComment_1.default(parentAst, item, options.rootLeadingComment);
        comments.forEach(function (comment) {
            var doclets = getDoclets_1.default(comment);
            var propTags = doclets.tags && doclets.tags.filter(function (d) { return d.title === 'prop'; });
            if (propTags && propTags.length) {
                propsFound.forEach(function (pName) {
                    var propTag = propTags.filter(function (pt) { return pt.name === pName; });
                    if (propTag.length) {
                        var p = documentation.getPropDescriptor(pName);
                        p.type = propTag[0].type;
                        if (typeof propTag[0].description === 'string') {
                            p.description = propTag[0].description;
                        }
                    }
                });
            }
        });
    }
}
