"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bt = __importStar(require("@babel/types"));
var recast_1 = __importDefault(require("recast"));
var babel_parser_1 = __importDefault(require("../babel-parser"));
var extractLeadingComment_1 = __importDefault(require("../utils/extractLeadingComment"));
var slotHandler_1 = require("../script-handlers/slotHandler");
var parser = babel_parser_1.default({ plugins: ['typescript'] });
function slotHandler(documentation, templateAst, options) {
    if (templateAst.tag === 'slot') {
        var bindings_1 = extractAndFilterAttr(templateAst.attrsMap);
        var name_1 = 'default';
        if (bindings_1.name) {
            name_1 = bindings_1.name;
            delete bindings_1.name;
        }
        if (bindings_1['']) {
            var vBindCode = templateAst.attrsMap['v-bind'];
            var ast = parser.parse("() => (" + vBindCode + ")");
            var rawVBind_1 = false;
            recast_1.default.visit(ast.program, {
                visitObjectExpression: function (path) {
                    if (!path.node) {
                        return false;
                    }
                    path.get('properties').each(function (property) {
                        var node = property.node;
                        if (bt.isProperty(node) || bt.isObjectProperty(node)) {
                            bindings_1[node.key.name] = recast_1.default.print(property.get('value')).code;
                        }
                        else {
                            rawVBind_1 = true;
                        }
                    });
                    return false;
                }
            });
            if (rawVBind_1) {
                bindings_1['v-bind'] = vBindCode;
            }
            delete bindings_1[''];
        }
        var slotDescriptor_1 = documentation.getSlotDescriptor(name_1);
        if (bindings_1 && Object.keys(bindings_1).length) {
            slotDescriptor_1.scoped = true;
        }
        var comments = extractLeadingComment_1.default(templateAst.parent, templateAst, options.rootLeadingComment);
        var bindingDescriptors_1 = [];
        comments.forEach(function (comment) {
            // if a comment contains @slot,
            // use it to determine bindings and tags
            // if multiple @slot, use the last one
            if (comment.length) {
                var doclets = slotHandler_1.parseSlotDocBlock(comment, slotDescriptor_1);
                if (doclets && doclets.bindings) {
                    bindingDescriptors_1 = doclets.bindings;
                }
            }
        });
        if (Object.keys(bindings_1).length) {
            slotDescriptor_1.bindings = Object.keys(bindings_1).map(function (b) {
                var bindingDesc = bindingDescriptors_1.filter(function (t) { return t.name === b; })[0];
                return bindingDesc || { name: b };
            });
        }
    }
}
exports.default = slotHandler;
var dirRE = /^(v-|:|@)/;
var allowRE = /^(v-bind|:)/;
function extractAndFilterAttr(attrsMap) {
    var res = {};
    var keys = Object.keys(attrsMap);
    for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
        var key = keys_1[_i];
        if (!dirRE.test(key) || allowRE.test(key)) {
            res[key.replace(allowRE, '')] = attrsMap[key];
        }
    }
    return res;
}
