"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var ts_map_1 = __importDefault(require("ts-map"));
var path = __importStar(require("path"));
var recursiveResolveIEV_1 = __importDefault(require("../utils/recursiveResolveIEV"));
var parse_1 = require("../parse");
var makePathResolver_1 = __importDefault(require("./makePathResolver"));
/**
 * Document all components in varToFilePath in documentation
 * Instead of giving it only one component file, here we give it a whole set of variable -> file
 *
 * @param documentation if omitted (undefined), it will return all docs in an array
 * @param varToFilePath variable of object to document
 * @param originObject to build the origin flag
 * @param opt parsing options
 */
function documentRequiredComponents(documentation, varToFilePath, originObject, opt) {
    return __awaiter(this, void 0, void 0, function () {
        var originalDirName, pathResolver, files, _loop_1, _i, _a, varName, docs;
        var _this = this;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    originalDirName = path.dirname(opt.filePath);
                    pathResolver = makePathResolver_1.default(originalDirName, opt.alias, opt.modules);
                    // resolve where components are through immediately exported variables
                    return [4 /*yield*/, recursiveResolveIEV_1.default(pathResolver, varToFilePath, opt.validExtends)];
                case 1:
                    // resolve where components are through immediately exported variables
                    _b.sent();
                    files = new ts_map_1.default();
                    _loop_1 = function (varName) {
                        var _a = varToFilePath[varName], filePath = _a.filePath, exportName = _a.exportName;
                        filePath.forEach(function (p) {
                            var fullFilePath = pathResolver(p);
                            if (opt.validExtends(fullFilePath)) {
                                var vars = files.get(fullFilePath) || [];
                                vars.push(exportName);
                                files.set(fullFilePath, vars);
                            }
                        });
                    };
                    for (_i = 0, _a = Object.keys(varToFilePath); _i < _a.length; _i++) {
                        varName = _a[_i];
                        _loop_1(varName);
                    }
                    docs = [];
                    return [4 /*yield*/, files.keys().reduce(function (_, fullFilePath) { return __awaiter(_this, void 0, void 0, function () {
                            var vars, originVar_1, e_1, _a, _b;
                            var _c;
                            var _this = this;
                            return __generator(this, function (_d) {
                                switch (_d.label) {
                                    case 0: return [4 /*yield*/, _];
                                    case 1:
                                        _d.sent();
                                        vars = files.get(fullFilePath);
                                        if (!(fullFilePath && vars)) return [3 /*break*/, 8];
                                        if (!(originObject && documentation)) return [3 /*break*/, 6];
                                        _d.label = 2;
                                    case 2:
                                        _d.trys.push([2, 4, , 5]);
                                        originVar_1 = (_c = {},
                                            _c[originObject] = {
                                                name: '-',
                                                path: path.relative(path.dirname(documentation.componentFullfilePath), fullFilePath)
                                            },
                                            _c);
                                        return [4 /*yield*/, vars.reduce(function (_, v) { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    switch (_a.label) {
                                                        case 0: return [4 /*yield*/, _];
                                                        case 1:
                                                            _a.sent();
                                                            return [4 /*yield*/, parse_1.parseFile(__assign(__assign(__assign({}, opt), { filePath: fullFilePath, nameFilter: [v] }), originVar_1), documentation)];
                                                        case 2:
                                                            _a.sent();
                                                            return [2 /*return*/];
                                                    }
                                                });
                                            }); }, Promise.resolve())];
                                    case 3:
                                        _d.sent();
                                        if (documentation && originVar_1[originObject]) {
                                            originVar_1[originObject].name =
                                                documentation.get('displayName') || documentation.get('exportName');
                                            documentation.set('displayName', null);
                                        }
                                        return [3 /*break*/, 5];
                                    case 4:
                                        e_1 = _d.sent();
                                        return [3 /*break*/, 5];
                                    case 5: return [3 /*break*/, 8];
                                    case 6:
                                        _b = (_a = docs).concat;
                                        return [4 /*yield*/, parse_1.parseFile(__assign(__assign({}, opt), { filePath: fullFilePath, nameFilter: vars }), documentation)];
                                    case 7:
                                        docs = _b.apply(_a, [_d.sent()]);
                                        _d.label = 8;
                                    case 8: return [2 /*return*/];
                                }
                            });
                        }); }, Promise.resolve())];
                case 2:
                    _b.sent();
                    return [2 /*return*/, docs];
            }
        });
    });
}
exports.default = documentRequiredComponents;
