"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Extract leading comments to an html node
 * Even if the comment is on multiple lines it's still taken as a whole
 * @param templateAst
 * @param rootLeadingComment
 */
function extractLeadingComment(parentAst, templateAst, rootLeadingComments) {
    if (parentAst) {
        var slotSiblings = parentAst.children;
        // First find the position of the slot in the list
        var i = slotSiblings.length - 1;
        var currentSlotIndex = -1;
        do {
            if (slotSiblings[i] === templateAst) {
                currentSlotIndex = i;
            }
        } while (currentSlotIndex < 0 && i--);
        // Find the first leading comment
        // get all siblings before the current node
        var slotSiblingsBeforeSlot = slotSiblings.slice(0, currentSlotIndex).reverse();
        // find the first node that is not a potential comment
        var indexLastComment = slotSiblingsBeforeSlot.findIndex(function (sibling) { return sibling.type !== 3 || (!sibling.isComment && sibling.text.trim().length); });
        // cut the comments array on this index
        var slotPotentialComments = (indexLastComment > 0
            ? slotSiblingsBeforeSlot.slice(0, indexLastComment)
            : slotSiblingsBeforeSlot).reverse();
        // return each comment text
        return slotPotentialComments
            .filter(function (pc) { return pc.isComment; })
            .map(function (potentialComment) { return potentialComment.text.trim(); });
    }
    else if (rootLeadingComments.length) {
        return rootLeadingComments;
    }
    return [];
}
exports.default = extractLeadingComment;
