"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Helper functions to work with docblock comments.
 */
/**
 * Extracts the text from a docblock comment
 * @param {rawDocblock} str
 * @return str stripped from stars and spaces
 */
function parseDocblock(str) {
    var lines = str.split('\n');
    for (var i = 0, l = lines.length; i < l; i++) {
        lines[i] = lines[i].replace(/^\s*\*\s?/, '').replace(/\r$/, '');
    }
    return lines.join('\n').trim();
}
exports.parseDocblock = parseDocblock;
var DOCBLOCK_HEADER = /^\*\s/;
/**
 * Given a path, this function returns the closest preceding docblock if it
 * exists.
 */
function getDocblock(path, trailing) {
    if (trailing === void 0) { trailing = false; }
    var comments = [];
    if (trailing && path.node.trailingComments) {
        comments = path.node.trailingComments.filter(function (comment) {
            return comment.type === 'CommentBlock' && DOCBLOCK_HEADER.test(comment.value);
        });
    }
    else if (path.node.leadingComments) {
        comments = path.node.leadingComments.filter(function (comment) {
            return comment.type === 'CommentBlock' && DOCBLOCK_HEADER.test(comment.value);
        });
    }
    if (comments.length > 0) {
        return parseDocblock(comments[comments.length - 1].value);
    }
    return null;
}
exports.default = getDocblock;
